/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.util.coprocessor;

import com.zillion.database.util.DatabaseImpl_HBase;
import com.zillion.util.coprocessor.ObserverTool;
import com.zillion.util.coprocessor.StatObjectWrapper;
import com.zillion.util.coprocessor.StatTableWrapper;
import com.zillion.util.table.HBaseAdminUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.util.Bytes;
import org.zillion.util.log.LogUtil;

public class StatThread
extends Thread {
    boolean needStop = false;

    public void RequestStop() {
        this.needStop = true;
    }

    @Override
    public void run() {
        while (!ObserverTool.container.initialized) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        long last_milliseconds = (new Date().getTime() - ObserverTool.stat_lag) / ObserverTool.stat_interval;
        while (!this.needStop) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            long milliseconds = (new Date().getTime() - ObserverTool.stat_lag) / ObserverTool.stat_interval;
            if (milliseconds == last_milliseconds) continue;
            this.Process(milliseconds);
            last_milliseconds = milliseconds;
        }
    }

    private void Process(long milliseconds) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        DatabaseImpl_HBase DatabaseImpl_HBase2 = (DatabaseImpl_HBase)ObserverTool.container.DatabaseImpl;
        try {
            HashMap<String, HTable> tableMap = new HashMap<String, HTable>();
            for (String region_name : ObserverTool.statMap.keySet()) {
                int index_1 = region_name.indexOf(58);
                int index_2 = region_name.indexOf(44, index_1 + 1);
                int index_3 = region_name.indexOf(44, index_2 + 1);
                int index_4 = region_name.indexOf(44, index_3 + 1);
                String namespace = region_name.substring(0, index_1);
                String table_name = region_name.substring(index_1 + 1, index_2);
                String regionCode = region_name.substring(index_2 + 1, index_3);
                String startKey = region_name.substring(index_3 + 1, index_4);
                String endKey = region_name.substring(index_4 + 1);
                StatTableWrapper StatTableWrapper2 = (StatTableWrapper)ObserverTool.statMap.get(region_name);
                List<StatObjectWrapper> sowList = StatTableWrapper2.pop(milliseconds);
                for (StatObjectWrapper sow : sowList) {
                    TableName tableName;
                    String timeString = sdf.format(new Date(sow.milliseconds * ObserverTool.stat_interval));
                    String timeMonth = timeString.substring(0, 6);
                    String[] familyNames = new String[]{"f"};
                    TableName[] tableNames = new TableName[]{TableName.valueOf((String)namespace, (String)("zillion_meta_stat_1_" + timeMonth)), TableName.valueOf((String)namespace, (String)("zillion_meta_stat_2_" + timeMonth))};
                    HTable[] tableInners = new HTable[tableNames.length];
                    int i = 0;
                    while (i < tableNames.length) {
                        tableName = tableNames[i];
                        if (!tableMap.containsKey(tableName.getNameAsString())) {
                            if (!HBaseAdminUtil.tableExists(DatabaseImpl_HBase2.admin, tableName)) {
                                try {
                                    HBaseAdminUtil.createTable(DatabaseImpl_HBase2.admin, null, tableName, familyNames, null, false, Compression.Algorithm.NONE);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            tableInners[i] = (HTable)DatabaseImpl_HBase2.connection.getTable(tableName);
                            tableMap.put(tableName.getNameAsString(), tableInners[i]);
                        } else {
                            tableInners[i] = (HTable)tableMap.get(tableName.getNameAsString());
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < tableNames.length) {
                        tableName = tableNames[i];
                        HTable table = tableInners[i];
                        Put row = tableName.getNameAsString().contains("zillion_meta_stat_1_") ? new Put(Bytes.toBytes((String)(String.valueOf(table_name) + "," + timeString + "," + regionCode))) : new Put(Bytes.toBytes((String)(String.valueOf(timeString) + "," + table_name + "," + regionCode)));
                        row.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"startKey"), Bytes.toBytes((String)startKey));
                        row.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"endKey"), Bytes.toBytes((String)endKey));
                        if (sow.read_lines.get() > 0L) {
                            row.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"read_lines"), Bytes.toBytes((long)sow.read_lines.get()));
                            long read_rowkey_bytes = sow.read_rowkey_bytes.get();
                            long read_column_bytes = sow.read_column_bytes.get();
                            row.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"read_bytes"), Bytes.toBytes((long)(read_rowkey_bytes + read_column_bytes)));
                            row.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"read_rowkey_bytes"), Bytes.toBytes((long)read_rowkey_bytes));
                            row.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"read_column_bytes"), Bytes.toBytes((long)read_column_bytes));
                            LogUtil.warn(String.valueOf(region_name) + "\t" + "read" + "\t" + sow.read_lines.get() + "\t" + sow.read_rowkey_bytes.get() + "\t" + sow.read_column_bytes.get());
                        }
                        if (sow.insert_lines.get() > 0L) {
                            row.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"insert_lines"), Bytes.toBytes((long)sow.insert_lines.get()));
                            long insert_rowkey_bytes = sow.insert_rowkey_bytes.get();
                            long insert_column_bytes = sow.insert_column_bytes.get();
                            row.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"insert_bytes"), Bytes.toBytes((long)(insert_rowkey_bytes + insert_column_bytes)));
                            row.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"insert_rowkey_bytes"), Bytes.toBytes((long)insert_rowkey_bytes));
                            row.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"insert_column_bytes"), Bytes.toBytes((long)insert_column_bytes));
                            LogUtil.warn(String.valueOf(region_name) + "\t" + "insert" + "\t" + sow.insert_lines.get() + "\t" + sow.insert_rowkey_bytes.get() + "\t" + sow.insert_column_bytes.get());
                        }
                        if (sow.update_lines.get() > 0L) {
                            row.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"update_lines"), Bytes.toBytes((long)sow.update_lines.get()));
                            long update_rowkey_bytes = sow.update_rowkey_bytes.get();
                            long update_column_bytes = sow.update_column_bytes.get();
                            row.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"update_bytes"), Bytes.toBytes((long)(update_rowkey_bytes + update_column_bytes)));
                            row.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"update_rowkey_bytes"), Bytes.toBytes((long)update_rowkey_bytes));
                            row.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"update_column_bytes"), Bytes.toBytes((long)update_column_bytes));
                            LogUtil.warn(String.valueOf(region_name) + "\t" + "update" + "\t" + sow.update_lines.get() + "\t" + sow.update_rowkey_bytes.get() + "\t" + sow.update_column_bytes.get());
                        }
                        if (sow.delete_lines.get() > 0L) {
                            row.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"delete_lines"), Bytes.toBytes((long)sow.delete_lines.get()));
                            long delete_rowkey_bytes = sow.delete_rowkey_bytes.get();
                            row.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"delete_bytes"), Bytes.toBytes((long)delete_rowkey_bytes));
                            LogUtil.warn(String.valueOf(region_name) + "\t" + "delete" + "\t" + sow.delete_lines.get() + "\t" + sow.delete_rowkey_bytes.get());
                        }
                        table.put(row);
                        ++i;
                    }
                }
            }
            for (String key : tableMap.keySet()) {
                HTable table = (HTable)tableMap.get(key);
                table.close();
            }
        }
        catch (Exception e) {
            LogUtil.error(e);
        }
    }
}

