/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.database.async;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.zillion.util.common.MyException;

public class AsyncResultSet {
    public String uuid;
    public long PageSize;
    public long Timeout;
    List<JSONObject> itemList = new ArrayList<JSONObject>();
    boolean finish;
    boolean success;
    String reason;

    public AsyncResultSet(String uuid, long PageSize, long Timeout) {
        this.uuid = uuid;
        this.PageSize = PageSize;
        this.Timeout = Timeout;
        this.finish = false;
    }

    public synchronized int GetSize() {
        return this.itemList.size();
    }

    public synchronized void Finish(boolean success, String reason) {
        this.finish = true;
        this.success = success;
        this.reason = reason;
    }

    public synchronized boolean IsFinish() {
        return this.finish;
    }

    public synchronized boolean isSuccess() {
        return this.success;
    }

    public synchronized void Push(JSONObject item) {
        this.itemList.add(item);
    }

    public synchronized List<JSONObject> PopOnePage() {
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        int i = 0;
        while ((long)i < this.PageSize) {
            if (this.GetSize() <= 0) break;
            result.add(this.itemList.remove(0));
            ++i;
        }
        return result;
    }

    public void TryPush(JSONObject item) throws Exception {
        Date time_enter = new Date();
        while (true) {
            if (this.IsFinish()) {
                throw new MyException("BufferedResultSet TryPush:" + this.reason);
            }
            if ((long)this.GetSize() < this.PageSize) break;
            Date time_curr = new Date();
            if (time_curr.getTime() - time_enter.getTime() > this.Timeout) {
                this.Finish(false, "TryPush timeout");
                throw new MyException("BufferedResultSet: TryPush timeout");
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.Push(item);
    }

    public List<JSONObject> TryPopOnePage() throws Exception {
        List<JSONObject> result;
        Date time_enter = new Date();
        while (true) {
            if (this.IsFinish()) {
                if (this.isSuccess()) {
                    result = this.PopOnePage();
                    break;
                }
                throw new MyException("BufferedResultSet TryPopOnePage:" + this.reason);
            }
            if ((long)this.GetSize() >= this.PageSize) {
                result = this.PopOnePage();
                break;
            }
            Date time_curr = new Date();
            if (time_curr.getTime() - time_enter.getTime() > this.Timeout) {
                this.Finish(false, "TryPopOnePage timeout");
                throw new MyException("BufferedResultSet: TryPopOnePage timeout");
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return result;
    }
}

