/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.simple;

import java.util.Collections;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.QueryBuilder;

public class SimpleQueryParser
extends QueryBuilder {
    protected final Map<String, Float> weights;
    protected final int flags;
    public static final int AND_OPERATOR = 1;
    public static final int NOT_OPERATOR = 2;
    public static final int OR_OPERATOR = 4;
    public static final int PREFIX_OPERATOR = 8;
    public static final int PHRASE_OPERATOR = 16;
    public static final int PRECEDENCE_OPERATORS = 32;
    public static final int ESCAPE_OPERATOR = 64;
    public static final int WHITESPACE_OPERATOR = 128;
    public static final int FUZZY_OPERATOR = 256;
    public static final int NEAR_OPERATOR = 512;
    private BooleanClause.Occur defaultOperator = BooleanClause.Occur.SHOULD;

    public SimpleQueryParser(Analyzer analyzer, String field) {
        this(analyzer, Collections.singletonMap(field, Float.valueOf(1.0f)));
    }

    public SimpleQueryParser(Analyzer analyzer, Map<String, Float> weights) {
        this(analyzer, weights, -1);
    }

    public SimpleQueryParser(Analyzer analyzer, Map<String, Float> weights, int flags) {
        super(analyzer);
        this.weights = weights;
        this.flags = flags;
    }

    public Query parse(String queryText) {
        char[] data = queryText.toCharArray();
        char[] buffer = new char[data.length];
        State state = new State(data, buffer, 0, data.length);
        this.parseSubQuery(state);
        if (state.top == null) {
            return new MatchNoDocsQuery();
        }
        return state.top;
    }

    private void parseSubQuery(State state) {
        while (state.index < state.length) {
            if (state.data[state.index] == '(' && (this.flags & 0x20) != 0) {
                this.consumeSubQuery(state);
            } else if (state.data[state.index] == ')' && (this.flags & 0x20) != 0) {
                ++state.index;
            } else if (state.data[state.index] == '\"' && (this.flags & 0x10) != 0) {
                this.consumePhrase(state);
            } else if (state.data[state.index] == '+' && (this.flags & 1) != 0) {
                if (state.currentOperation == null && state.top != null) {
                    state.currentOperation = BooleanClause.Occur.MUST;
                }
                ++state.index;
            } else if (state.data[state.index] == '|' && (this.flags & 4) != 0) {
                if (state.currentOperation == null && state.top != null) {
                    state.currentOperation = BooleanClause.Occur.SHOULD;
                }
                ++state.index;
            } else {
                if (state.data[state.index] == '-' && (this.flags & 2) != 0) {
                    ++state.not;
                    ++state.index;
                    continue;
                }
                if ((state.data[state.index] == ' ' || state.data[state.index] == '\t' || state.data[state.index] == '\n' || state.data[state.index] == '\r') && (this.flags & 0x80) != 0) {
                    ++state.index;
                } else {
                    this.consumeToken(state);
                }
            }
            state.not = 0;
        }
    }

    private void consumeSubQuery(State state) {
        assert ((this.flags & 0x20) != 0);
        int start = ++state.index;
        int precedence = 1;
        boolean escaped = false;
        while (state.index < state.length) {
            if (!escaped) {
                if (state.data[state.index] == '\\' && (this.flags & 0x40) != 0) {
                    escaped = true;
                    ++state.index;
                    continue;
                }
                if (state.data[state.index] == '(') {
                    ++precedence;
                } else if (state.data[state.index] == ')' && --precedence == 0) break;
            }
            escaped = false;
            ++state.index;
        }
        if (state.index == state.length) {
            state.index = start;
        } else if (state.index == start) {
            state.currentOperation = null;
            ++state.index;
        } else {
            State subState = new State(state.data, state.buffer, start, state.index);
            this.parseSubQuery(subState);
            this.buildQueryTree(state, subState.top);
            ++state.index;
        }
    }

    private void consumePhrase(State state) {
        assert ((this.flags & 0x10) != 0);
        int start = ++state.index;
        int copied = 0;
        boolean escaped = false;
        boolean hasSlop = false;
        while (state.index < state.length) {
            if (!escaped) {
                if (state.data[state.index] == '\\' && (this.flags & 0x40) != 0) {
                    escaped = true;
                    ++state.index;
                    continue;
                }
                if (state.data[state.index] == '\"') {
                    if (state.length <= state.index + 1 || state.data[state.index + 1] != '~' || (this.flags & 0x200) == 0) break;
                    ++state.index;
                    if (state.length <= state.index + 1) break;
                    hasSlop = true;
                    break;
                }
            }
            escaped = false;
            state.buffer[copied++] = state.data[state.index++];
        }
        if (state.index == state.length) {
            state.index = start;
        } else if (state.index == start) {
            state.currentOperation = null;
            ++state.index;
        } else {
            String phrase = new String(state.buffer, 0, copied);
            Query branch = hasSlop ? this.newPhraseQuery(phrase, this.parseFuzziness(state)) : this.newPhraseQuery(phrase, 0);
            this.buildQueryTree(state, branch);
            ++state.index;
        }
    }

    private void consumeToken(State state) {
        int copied = 0;
        boolean escaped = false;
        boolean prefix = false;
        boolean fuzzy = false;
        while (state.index < state.length) {
            if (!escaped) {
                if (state.data[state.index] == '\\' && (this.flags & 0x40) != 0) {
                    escaped = true;
                    prefix = false;
                    ++state.index;
                    continue;
                }
                if (this.tokenFinished(state)) break;
                if (copied > 0 && state.data[state.index] == '~' && (this.flags & 0x100) != 0) {
                    fuzzy = true;
                    break;
                }
                prefix = copied > 0 && state.data[state.index] == '*' && (this.flags & 8) != 0;
            }
            escaped = false;
            state.buffer[copied++] = state.data[state.index++];
        }
        if (copied > 0) {
            Query branch;
            if (fuzzy && (this.flags & 0x100) != 0) {
                String token = new String(state.buffer, 0, copied);
                int fuzziness = this.parseFuzziness(state);
                branch = (fuzziness = Math.min(fuzziness, 2)) == 0 ? this.newDefaultQuery(token) : this.newFuzzyQuery(token, fuzziness);
            } else if (prefix) {
                String token = new String(state.buffer, 0, copied - 1);
                branch = this.newPrefixQuery(token);
            } else {
                String token = new String(state.buffer, 0, copied);
                branch = this.newDefaultQuery(token);
            }
            this.buildQueryTree(state, branch);
        }
    }

    private static BooleanQuery addClause(BooleanQuery bq, Query query, BooleanClause.Occur occur) {
        BooleanQuery.Builder newBq = new BooleanQuery.Builder();
        newBq.setDisableCoord(bq.isCoordDisabled());
        newBq.setMinimumNumberShouldMatch(bq.getMinimumNumberShouldMatch());
        for (BooleanClause clause : bq) {
            newBq.add(clause);
        }
        newBq.add(query, occur);
        return newBq.build();
    }

    private void buildQueryTree(State state, Query branch) {
        if (branch != null) {
            if (state.not % 2 == 1) {
                BooleanQuery.Builder nq = new BooleanQuery.Builder();
                nq.add(branch, BooleanClause.Occur.MUST_NOT);
                nq.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.SHOULD);
                branch = nq.build();
            }
            if (state.top == null) {
                state.top = branch;
            } else {
                if (state.currentOperation == null) {
                    state.currentOperation = this.defaultOperator;
                }
                if (state.previousOperation != state.currentOperation) {
                    BooleanQuery.Builder bq = new BooleanQuery.Builder();
                    bq.add(state.top, state.currentOperation);
                    state.top = bq.build();
                }
                state.top = SimpleQueryParser.addClause((BooleanQuery)state.top, branch, state.currentOperation);
                state.previousOperation = state.currentOperation;
            }
            state.currentOperation = null;
        }
    }

    private int parseFuzziness(State state) {
        char[] slopText = new char[state.length];
        int slopLength = 0;
        if (state.data[state.index] == '~') {
            while (state.index < state.length) {
                ++state.index;
                if (state.index >= state.length) continue;
                if (this.tokenFinished(state)) break;
                slopText[slopLength] = state.data[state.index];
                ++slopLength;
            }
            int fuzziness = 0;
            try {
                fuzziness = Integer.parseInt(new String(slopText, 0, slopLength));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (fuzziness < 0) {
                fuzziness = 0;
            }
            return fuzziness;
        }
        return 0;
    }

    private boolean tokenFinished(State state) {
        return state.data[state.index] == '\"' && (this.flags & 0x10) != 0 || state.data[state.index] == '|' && (this.flags & 4) != 0 || state.data[state.index] == '+' && (this.flags & 1) != 0 || state.data[state.index] == '(' && (this.flags & 0x20) != 0 || state.data[state.index] == ')' && (this.flags & 0x20) != 0 || (state.data[state.index] == ' ' || state.data[state.index] == '\t' || state.data[state.index] == '\n' || state.data[state.index] == '\r') && (this.flags & 0x80) != 0;
    }

    protected Query newDefaultQuery(String text) {
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.setDisableCoord(true);
        for (Map.Entry<String, Float> entry : this.weights.entrySet()) {
            Query q = this.createBooleanQuery(entry.getKey(), text, this.defaultOperator);
            if (q == null) continue;
            float boost = entry.getValue().floatValue();
            if (boost != 1.0f) {
                q = new BoostQuery(q, boost);
            }
            bq.add(q, BooleanClause.Occur.SHOULD);
        }
        return this.simplify(bq.build());
    }

    protected Query newFuzzyQuery(String text, int fuzziness) {
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.setDisableCoord(true);
        for (Map.Entry<String, Float> entry : this.weights.entrySet()) {
            FuzzyQuery q = new FuzzyQuery(new Term(entry.getKey(), text), fuzziness);
            float boost = entry.getValue().floatValue();
            if (boost != 1.0f) {
                q = new BoostQuery((Query)q, boost);
            }
            bq.add((Query)q, BooleanClause.Occur.SHOULD);
        }
        return this.simplify(bq.build());
    }

    protected Query newPhraseQuery(String text, int slop) {
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.setDisableCoord(true);
        for (Map.Entry<String, Float> entry : this.weights.entrySet()) {
            Query q = this.createPhraseQuery(entry.getKey(), text, slop);
            if (q == null) continue;
            float boost = entry.getValue().floatValue();
            if (boost != 1.0f) {
                q = new BoostQuery(q, boost);
            }
            bq.add(q, BooleanClause.Occur.SHOULD);
        }
        return this.simplify(bq.build());
    }

    protected Query newPrefixQuery(String text) {
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.setDisableCoord(true);
        for (Map.Entry<String, Float> entry : this.weights.entrySet()) {
            PrefixQuery q = new PrefixQuery(new Term(entry.getKey(), text));
            float boost = entry.getValue().floatValue();
            if (boost != 1.0f) {
                q = new BoostQuery((Query)q, boost);
            }
            bq.add((Query)q, BooleanClause.Occur.SHOULD);
        }
        return this.simplify(bq.build());
    }

    protected Query simplify(BooleanQuery bq) {
        if (bq.clauses().isEmpty()) {
            return null;
        }
        if (bq.clauses().size() == 1) {
            return ((BooleanClause)bq.clauses().iterator().next()).getQuery();
        }
        return bq;
    }

    public BooleanClause.Occur getDefaultOperator() {
        return this.defaultOperator;
    }

    public void setDefaultOperator(BooleanClause.Occur operator) {
        if (operator != BooleanClause.Occur.SHOULD && operator != BooleanClause.Occur.MUST) {
            throw new IllegalArgumentException("invalid operator: only SHOULD or MUST are allowed");
        }
        this.defaultOperator = operator;
    }

    static class State {
        final char[] data;
        final char[] buffer;
        int index;
        int length;
        BooleanClause.Occur currentOperation;
        BooleanClause.Occur previousOperation;
        int not;
        Query top;

        State(char[] data, char[] buffer, int index, int length) {
            this.data = data;
            this.buffer = buffer;
            this.index = index;
            this.length = length;
        }
    }
}

