/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.nodestart;

import java.io.File;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.F;
import org.jetbrains.annotations.Nullable;

public class IgniteRemoteStartSpecification {
    private final String host;
    private final int port;
    private final String uname;
    private final String passwd;
    private final File key;
    private final String keyName;
    private final int nodes;
    private String igniteHome;
    private String cfg;
    private String cfgName;
    private String script;
    private IgniteLogger logger;
    private boolean valid;

    public IgniteRemoteStartSpecification(@Nullable String host, int port, @Nullable String uname, @Nullable String passwd, @Nullable File key, int nodes, @Nullable String igniteHome, @Nullable String cfg, @Nullable String script) {
        this(host, port, uname, passwd, key, nodes, igniteHome, cfg, script, null);
    }

    public IgniteRemoteStartSpecification(@Nullable String host, int port, @Nullable String uname, @Nullable String passwd, @Nullable File key, int nodes, @Nullable String igniteHome, @Nullable String cfg, @Nullable String script, @Nullable IgniteLogger logger) {
        assert (port > 0);
        assert (nodes > 0);
        this.host = !F.isEmpty(host) ? host : null;
        this.port = port;
        this.uname = !F.isEmpty(uname) ? uname : null;
        this.passwd = !F.isEmpty(passwd) ? passwd : null;
        this.key = key;
        this.nodes = nodes;
        this.igniteHome = !F.isEmpty(igniteHome) ? igniteHome : null;
        this.cfg = !F.isEmpty(cfg) ? cfg : null;
        this.cfgName = cfg == null ? null : IgniteRemoteStartSpecification.shorten(cfg);
        this.keyName = key == null ? "" : IgniteRemoteStartSpecification.shorten(key.getAbsolutePath());
        this.script = !F.isEmpty(script) ? script : null;
        this.logger = logger;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IgniteRemoteStartSpecification)) {
            return false;
        }
        IgniteRemoteStartSpecification that = (IgniteRemoteStartSpecification)o;
        return (this.host == null ? that.host == null : this.host.equals(that.host)) && (this.uname == null ? that.uname == null : this.uname.equals(that.uname)) && (this.passwd == null ? that.passwd == null : this.passwd.equals(that.passwd)) && (this.key == null ? that.key == null : this.key.equals(that.key)) && (this.igniteHome == null ? that.igniteHome == null : this.igniteHome.equals(that.igniteHome)) && (this.cfg == null ? that.cfg == null : this.cfg.equals(that.cfg)) && (this.script == null ? that.script == null : this.script.equals(that.script)) && this.port == that.port && this.nodes == that.nodes;
    }

    public int hashCode() {
        int res = this.host == null ? 0 : this.host.hashCode();
        res = 31 * res + (this.uname == null ? 0 : this.uname.hashCode());
        res = 31 * res + (this.passwd == null ? 0 : this.passwd.hashCode());
        res = 31 * res + (this.key == null ? 0 : this.key.hashCode());
        res = 31 * res + (this.igniteHome == null ? 0 : this.igniteHome.hashCode());
        res = 31 * res + (this.cfg == null ? 0 : this.cfg.hashCode());
        res = 31 * res + (this.script == null ? 0 : this.script.hashCode());
        res = 31 * res + this.port;
        res = 31 * res + this.nodes;
        return res;
    }

    private static String shorten(String path) {
        int idx2;
        int idx1 = path.lastIndexOf(47);
        int idx = Math.max(idx1, idx2 = path.lastIndexOf(92));
        return idx == -1 ? path : path.substring(idx + 1);
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String username() {
        return this.uname;
    }

    public String password() {
        return this.passwd;
    }

    public File key() {
        return this.key;
    }

    public String keyName() {
        return this.keyName;
    }

    public int nodes() {
        return this.nodes;
    }

    public String igniteHome() {
        return this.igniteHome;
    }

    public String configuration() {
        return this.cfg;
    }

    public String configurationName() {
        return this.cfgName;
    }

    public String script() {
        return this.script;
    }

    public IgniteLogger logger() {
        return this.logger;
    }

    public boolean valid() {
        return this.valid;
    }

    public void valid(boolean valid) {
        this.valid = valid;
    }

    public void fixPaths(char separator) {
        if (this.igniteHome != null) {
            this.igniteHome = this.igniteHome.replace('\\', separator).replace('/', separator);
        }
        if (this.script != null) {
            this.script = this.script.replace('\\', separator).replace('/', separator);
        }
        if (this.cfg != null) {
            this.cfg = this.cfg.replace('\\', separator).replace('/', separator);
        }
    }
}

