/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.nio;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.util.nio.GridCommunicationClient;
import org.apache.ignite.internal.util.nio.GridNioMetricsListener;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public abstract class GridAbstractCommunicationClient
implements GridCommunicationClient {
    private volatile long lastUsed = U.currentTimeMillis();
    private final AtomicBoolean closed = new AtomicBoolean();
    protected final GridNioMetricsListener metricsLsnr;
    private final int connIdx;

    protected GridAbstractCommunicationClient(int connIdx, @Nullable GridNioMetricsListener metricsLsnr) {
        this.connIdx = connIdx;
        this.metricsLsnr = metricsLsnr;
    }

    @Override
    public int connectionIndex() {
        return this.connIdx;
    }

    @Override
    public boolean close() {
        return !this.closed.get() && this.closed.compareAndSet(false, true);
    }

    @Override
    public void forceClose() {
        this.closed.set(true);
    }

    @Override
    public boolean closed() {
        return this.closed.get();
    }

    @Override
    public boolean reserve() {
        return !this.closed.get();
    }

    @Override
    public void release() {
    }

    @Override
    public long getIdleTime() {
        return U.currentTimeMillis() - this.lastUsed;
    }

    protected void markUsed() {
        this.lastUsed = U.currentTimeMillis();
    }

    @Override
    public boolean async() {
        return false;
    }

    public String toString() {
        return S.toString(GridAbstractCommunicationClient.class, this);
    }
}

