/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import org.apache.ignite.internal.util.typedef.X;

public abstract class IgfsThread
extends Thread {
    protected IgfsThread() {
        super("igfs-worker");
    }

    protected IgfsThread(String name) {
        super(name);
    }

    @Override
    public final void run() {
        try {
            this.body();
        }
        catch (InterruptedException ignore) {
            this.interrupt();
        }
        catch (Throwable e) {
            X.error("Failed to execute IGFS ad-hoc thread: " + e.getMessage(), new Object[0]);
            e.printStackTrace();
            if (e instanceof Error) {
                throw e;
            }
        }
        finally {
            block17: {
                try {
                    this.cleanup();
                }
                catch (Throwable e) {
                    X.error("Failed to clean up IGFS ad-hoc thread: " + e.getMessage(), new Object[0]);
                    e.printStackTrace();
                    if (!(e instanceof Error)) break block17;
                    throw e;
                }
            }
        }
    }

    protected abstract void body() throws InterruptedException;

    protected void cleanup() {
    }
}

