/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.igfs;

import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteFileSystem;
import org.apache.ignite.configuration.FileSystemConfiguration;
import org.apache.ignite.igfs.IgfsBlockLocation;
import org.apache.ignite.igfs.IgfsFile;
import org.apache.ignite.igfs.IgfsInputStream;
import org.apache.ignite.igfs.IgfsMetrics;
import org.apache.ignite.igfs.IgfsMode;
import org.apache.ignite.igfs.IgfsOutputStream;
import org.apache.ignite.igfs.IgfsPath;
import org.apache.ignite.igfs.IgfsPathSummary;
import org.apache.ignite.igfs.mapreduce.IgfsRecordResolver;
import org.apache.ignite.igfs.mapreduce.IgfsTask;
import org.apache.ignite.igfs.secondary.IgfsSecondaryFileSystem;
import org.apache.ignite.internal.AsyncSupportAdapter;
import org.apache.ignite.internal.processors.igfs.IgfsContext;
import org.apache.ignite.internal.processors.igfs.IgfsEx;
import org.apache.ignite.internal.processors.igfs.IgfsImpl;
import org.apache.ignite.internal.processors.igfs.IgfsStatus;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class IgfsAsyncImpl
extends AsyncSupportAdapter<IgniteFileSystem>
implements IgfsEx {
    private final IgfsImpl igfs;

    public IgfsAsyncImpl(IgfsImpl igfs) {
        super(true);
        this.igfs = igfs;
    }

    @Override
    public void clear() {
        try {
            this.saveOrGet(this.igfs.clearAsync0());
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public IgniteFuture<Void> clearAsync() throws IgniteException {
        return this.igfs.clearAsync();
    }

    @Override
    public <T, R> R execute(IgfsTask<T, R> task, @Nullable IgfsRecordResolver rslvr, Collection<IgfsPath> paths, @Nullable T arg) {
        try {
            return this.saveOrGet(this.igfs.executeAsync0(task, rslvr, paths, arg));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <T, R> IgniteFuture<R> executeAsync(IgfsTask<T, R> task, @Nullable IgfsRecordResolver rslvr, Collection<IgfsPath> paths, @Nullable T arg) throws IgniteException {
        return this.igfs.executeAsync(task, rslvr, paths, arg);
    }

    @Override
    public <T, R> R execute(IgfsTask<T, R> task, @Nullable IgfsRecordResolver rslvr, Collection<IgfsPath> paths, boolean skipNonExistentFiles, long maxRangeLen, @Nullable T arg) {
        try {
            return this.saveOrGet(this.igfs.executeAsync0(task, rslvr, paths, skipNonExistentFiles, maxRangeLen, arg));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <T, R> IgniteFuture<R> executeAsync(IgfsTask<T, R> task, @Nullable IgfsRecordResolver rslvr, Collection<IgfsPath> paths, boolean skipNonExistentFiles, long maxRangeLen, @Nullable T arg) throws IgniteException {
        return this.igfs.executeAsync(task, rslvr, paths, skipNonExistentFiles, maxRangeLen, arg);
    }

    @Override
    public <T, R> R execute(Class<? extends IgfsTask<T, R>> taskCls, @Nullable IgfsRecordResolver rslvr, Collection<IgfsPath> paths, @Nullable T arg) {
        try {
            return this.saveOrGet(this.igfs.executeAsync0(taskCls, rslvr, paths, arg));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <T, R> IgniteFuture<R> executeAsync(Class<? extends IgfsTask<T, R>> taskCls, @Nullable IgfsRecordResolver rslvr, Collection<IgfsPath> paths, @Nullable T arg) throws IgniteException {
        return this.igfs.executeAsync(taskCls, rslvr, paths, arg);
    }

    @Override
    public <T, R> R execute(Class<? extends IgfsTask<T, R>> taskCls, @Nullable IgfsRecordResolver rslvr, Collection<IgfsPath> paths, boolean skipNonExistentFiles, long maxRangeLen, @Nullable T arg) {
        try {
            return this.saveOrGet(this.igfs.executeAsync0(taskCls, rslvr, paths, skipNonExistentFiles, maxRangeLen, arg));
        }
        catch (IgniteCheckedException e) {
            throw U.convertException(e);
        }
    }

    @Override
    public <T, R> IgniteFuture<R> executeAsync(Class<? extends IgfsTask<T, R>> taskCls, @Nullable IgfsRecordResolver rslvr, Collection<IgfsPath> paths, boolean skipNonExistentFiles, long maxRangeLen, @Nullable T arg) throws IgniteException {
        return this.igfs.executeAsync(taskCls, rslvr, paths, skipNonExistentFiles, maxRangeLen, arg);
    }

    @Override
    public void stop(boolean cancel) {
        this.igfs.stop(cancel);
    }

    @Override
    public IgfsContext context() {
        return this.igfs.context();
    }

    @Override
    public IgfsInputStream open(IgfsPath path, int bufSize, int seqReadsBeforePrefetch) {
        return this.igfs.open(path, bufSize, seqReadsBeforePrefetch);
    }

    @Override
    public IgfsInputStream open(IgfsPath path) {
        return this.igfs.open(path);
    }

    @Override
    public IgfsInputStream open(IgfsPath path, int bufSize) {
        return this.igfs.open(path, bufSize);
    }

    @Override
    public IgfsStatus globalSpace() throws IgniteCheckedException {
        return this.igfs.globalSpace();
    }

    @Override
    public void globalSampling(@Nullable Boolean val) throws IgniteCheckedException {
        this.igfs.globalSampling(val);
    }

    @Override
    @Nullable
    public Boolean globalSampling() {
        return this.igfs.globalSampling();
    }

    @Override
    public long groupBlockSize() {
        return this.igfs.groupBlockSize();
    }

    @Override
    @Nullable
    public String clientLogDirectory() {
        return this.igfs.clientLogDirectory();
    }

    @Override
    public void clientLogDirectory(String logDir) {
        this.igfs.clientLogDirectory(logDir);
    }

    @Override
    public boolean evictExclude(IgfsPath path, boolean primary) {
        return this.igfs.evictExclude(path, primary);
    }

    @Override
    public IgniteUuid nextAffinityKey() {
        return this.igfs.nextAffinityKey();
    }

    @Override
    public boolean isProxy(URI path) {
        return this.igfs.isProxy(path);
    }

    @Override
    public String name() {
        return this.igfs.name();
    }

    @Override
    public FileSystemConfiguration configuration() {
        return this.igfs.configuration();
    }

    @Override
    public IgfsPathSummary summary(IgfsPath path) {
        return this.igfs.summary(path);
    }

    @Override
    public IgfsOutputStream create(IgfsPath path, boolean overwrite) {
        return this.igfs.create(path, overwrite);
    }

    @Override
    public IgfsOutputStream create(IgfsPath path, int bufSize, boolean overwrite, int replication, long blockSize, @Nullable Map<String, String> props) {
        return this.igfs.create(path, bufSize, overwrite, replication, blockSize, props);
    }

    @Override
    public IgfsOutputStream create(IgfsPath path, int bufSize, boolean overwrite, @Nullable IgniteUuid affKey, int replication, long blockSize, @Nullable Map<String, String> props) {
        return this.igfs.create(path, bufSize, overwrite, affKey, replication, blockSize, props);
    }

    @Override
    public IgfsOutputStream append(IgfsPath path, boolean create) {
        return this.igfs.append(path, create);
    }

    @Override
    public IgfsOutputStream append(IgfsPath path, int bufSize, boolean create, @Nullable Map<String, String> props) {
        return this.igfs.append(path, bufSize, create, props);
    }

    @Override
    public void setTimes(IgfsPath path, long modificationTime, long accessTime) {
        this.igfs.setTimes(path, modificationTime, accessTime);
    }

    @Override
    public Collection<IgfsBlockLocation> affinity(IgfsPath path, long start, long len) {
        return this.igfs.affinity(path, start, len);
    }

    @Override
    public Collection<IgfsBlockLocation> affinity(IgfsPath path, long start, long len, long maxLen) {
        return this.igfs.affinity(path, start, len, maxLen);
    }

    @Override
    public IgfsMetrics metrics() {
        return this.igfs.metrics();
    }

    @Override
    public void resetMetrics() {
        this.igfs.resetMetrics();
    }

    @Override
    public long size(IgfsPath path) {
        return this.igfs.size(path);
    }

    @Override
    public boolean exists(IgfsPath path) {
        return this.igfs.exists(path);
    }

    @Override
    @Nullable
    public IgfsFile update(IgfsPath path, Map<String, String> props) {
        return this.igfs.update(path, props);
    }

    @Override
    public void rename(IgfsPath src, IgfsPath dest) {
        this.igfs.rename(src, dest);
    }

    @Override
    public boolean delete(IgfsPath path, boolean recursive) {
        return this.igfs.delete(path, recursive);
    }

    @Override
    public void mkdirs(IgfsPath path) {
        this.igfs.mkdirs(path);
    }

    @Override
    public void mkdirs(IgfsPath path, @Nullable Map<String, String> props) {
        this.igfs.mkdirs(path, props);
    }

    @Override
    public Collection<IgfsPath> listPaths(IgfsPath path) {
        return this.igfs.listPaths(path);
    }

    @Override
    public Collection<IgfsFile> listFiles(IgfsPath path) {
        return this.igfs.listFiles(path);
    }

    @Override
    @Nullable
    public IgfsFile info(IgfsPath path) {
        return this.igfs.info(path);
    }

    @Override
    public IgfsMode mode(IgfsPath path) {
        return this.igfs.mode(path);
    }

    @Override
    public long usedSpaceSize() {
        return this.igfs.usedSpaceSize();
    }

    @Override
    public IgfsSecondaryFileSystem asSecondary() {
        return this.igfs.asSecondary();
    }

    @Override
    public void await(IgfsPath ... paths) {
        this.igfs.await(paths);
    }
}

