/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.tree;

import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRowAdapter;
import org.apache.ignite.internal.processors.cache.persistence.CacheSearchRow;
import org.apache.ignite.internal.processors.cache.persistence.tree.BPlusTree;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusLeafIO;
import org.apache.ignite.internal.processors.cache.tree.CacheDataTree;
import org.apache.ignite.internal.processors.cache.tree.RowLinkIO;
import org.apache.ignite.lang.IgniteInClosure;

public abstract class AbstractDataLeafIO
extends BPlusLeafIO<CacheSearchRow>
implements RowLinkIO {
    AbstractDataLeafIO(int type, int ver, int itemSize) {
        super(type, ver, itemSize);
    }

    @Override
    public void storeByOffset(long pageAddr, int off, CacheSearchRow row) {
        assert (row.link() != 0L);
        PageUtils.putLong(pageAddr, off, row.link());
        PageUtils.putInt(pageAddr, off + 8, row.hash());
        if (this.storeCacheId()) {
            assert (row.cacheId() != 0);
            PageUtils.putInt(pageAddr, off + 12, row.cacheId());
        }
    }

    @Override
    public void store(long dstPageAddr, int dstIdx, BPlusIO<CacheSearchRow> srcIo, long srcPageAddr, int srcIdx) {
        int hash = ((RowLinkIO)((Object)srcIo)).getHash(srcPageAddr, srcIdx);
        long link = ((RowLinkIO)((Object)srcIo)).getLink(srcPageAddr, srcIdx);
        int off = this.offset(dstIdx);
        PageUtils.putLong(dstPageAddr, off, link);
        PageUtils.putInt(dstPageAddr, off + 8, hash);
        if (this.storeCacheId()) {
            int cacheId = ((RowLinkIO)((Object)srcIo)).getCacheId(srcPageAddr, srcIdx);
            assert (cacheId != 0);
            PageUtils.putInt(dstPageAddr, off + 12, cacheId);
        }
    }

    @Override
    public CacheSearchRow getLookupRow(BPlusTree<CacheSearchRow, ?> tree, long buf, int idx) {
        int cacheId = this.getCacheId(buf, idx);
        int hash = this.getHash(buf, idx);
        long link = this.getLink(buf, idx);
        return ((CacheDataTree)tree).rowStore().keySearchRow(cacheId, hash, link);
    }

    @Override
    public long getLink(long pageAddr, int idx) {
        assert (idx < this.getCount(pageAddr)) : idx;
        return PageUtils.getLong(pageAddr, this.offset(idx));
    }

    @Override
    public int getHash(long pageAddr, int idx) {
        return PageUtils.getInt(pageAddr, this.offset(idx) + 8);
    }

    @Override
    public void visit(long pageAddr, IgniteInClosure<CacheSearchRow> c) {
        int cnt = this.getCount(pageAddr);
        for (int i = 0; i < cnt; ++i) {
            c.apply(new CacheDataRowAdapter(this.getLink(pageAddr, i)));
        }
    }

    protected abstract boolean storeCacheId();
}

