/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.freelist.FreeList;
import org.apache.ignite.internal.processors.query.GridQueryRowCacheCleaner;

public class RowStore {
    private final FreeList freeList;
    private final GridCacheSharedContext ctx;
    protected final PageMemory pageMem;
    protected final CacheObjectContext coctx;
    private final boolean persistenceEnabled;
    private GridQueryRowCacheCleaner rowCacheCleaner;

    public RowStore(CacheGroupContext grp, FreeList freeList) {
        assert (grp != null);
        assert (freeList != null);
        this.freeList = freeList;
        this.ctx = grp.shared();
        this.coctx = grp.cacheObjectContext();
        this.pageMem = grp.dataRegion().pageMemory();
        this.persistenceEnabled = grp.dataRegion().config().isPersistenceEnabled();
    }

    public void removeRow(long link) throws IgniteCheckedException {
        assert (link != 0L);
        if (this.rowCacheCleaner != null) {
            this.rowCacheCleaner.remove(link);
        }
        if (!this.persistenceEnabled) {
            this.freeList.removeDataRowByLink(link);
        } else {
            this.ctx.database().checkpointReadLock();
            try {
                this.freeList.removeDataRowByLink(link);
            }
            finally {
                this.ctx.database().checkpointReadUnlock();
            }
        }
    }

    public void addRow(CacheDataRow row) throws IgniteCheckedException {
        if (!this.persistenceEnabled) {
            this.freeList.insertDataRow(row);
        } else {
            this.ctx.database().checkpointReadLock();
            try {
                this.freeList.insertDataRow(row);
            }
            finally {
                this.ctx.database().checkpointReadUnlock();
            }
        }
    }

    public boolean updateRow(long link, CacheDataRow row) throws IgniteCheckedException {
        assert (!this.persistenceEnabled || this.ctx.database().checkpointLockIsHeldByThread());
        if (this.rowCacheCleaner != null) {
            this.rowCacheCleaner.remove(link);
        }
        return this.freeList.updateDataRow(link, row);
    }

    public FreeList freeList() {
        return this.freeList;
    }

    public void setRowCacheCleaner(GridQueryRowCacheCleaner rowCacheCleaner) {
        this.rowCacheCleaner = rowCacheCleaner;
    }
}

