/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.TimeUnit;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class IgniteExternalizableExpiryPolicy
implements ExpiryPolicy,
Externalizable {
    private static final long serialVersionUID = 0L;
    private ExpiryPolicy plc;
    private static final byte CREATE_TTL_MASK = 1;
    private static final byte UPDATE_TTL_MASK = 2;
    private static final byte ACCESS_TTL_MASK = 4;
    private Duration forCreate;
    private Duration forUpdate;
    private Duration forAccess;

    public IgniteExternalizableExpiryPolicy() {
    }

    public IgniteExternalizableExpiryPolicy(ExpiryPolicy plc) {
        assert (plc != null);
        this.plc = plc;
    }

    public Duration getExpiryForCreation() {
        return this.forCreate;
    }

    public Duration getExpiryForAccess() {
        return this.forAccess;
    }

    public Duration getExpiryForUpdate() {
        return this.forUpdate;
    }

    private void writeDuration(ObjectOutput out, @Nullable Duration duration) throws IOException {
        if (duration != null) {
            if (duration.getDurationAmount() == 0L) {
                if (duration.isEternal()) {
                    out.writeLong(0L);
                } else {
                    out.writeLong(-2L);
                }
            } else {
                out.writeLong(duration.getTimeUnit().toMillis(duration.getDurationAmount()));
            }
        }
    }

    private Duration readDuration(ObjectInput in) throws IOException {
        long ttl = in.readLong();
        assert (ttl >= 0L || ttl == -2L) : ttl;
        if (ttl == 0L) {
            return Duration.ETERNAL;
        }
        if (ttl == -2L) {
            return Duration.ZERO;
        }
        return new Duration(TimeUnit.MILLISECONDS, ttl);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Duration access;
        Duration update;
        byte flags = 0;
        Duration create = this.plc.getExpiryForCreation();
        if (create != null) {
            flags = (byte)(flags | 1);
        }
        if ((update = this.plc.getExpiryForUpdate()) != null) {
            flags = (byte)(flags | 2);
        }
        if ((access = this.plc.getExpiryForAccess()) != null) {
            flags = (byte)(flags | 4);
        }
        out.writeByte(flags);
        this.writeDuration(out, create);
        this.writeDuration(out, update);
        this.writeDuration(out, access);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte flags = in.readByte();
        if ((flags & 1) != 0) {
            this.forCreate = this.readDuration(in);
        }
        if ((flags & 2) != 0) {
            this.forUpdate = this.readDuration(in);
        }
        if ((flags & 4) != 0) {
            this.forAccess = this.readDuration(in);
        }
    }

    public String toString() {
        return S.toString(IgniteExternalizableExpiryPolicy.class, this);
    }
}

