/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.lang.reflect.Field;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.affinity.AffinityKeyMapped;
import org.apache.ignite.cache.affinity.AffinityKeyMapper;
import org.apache.ignite.internal.util.GridArgumentCheck;
import org.apache.ignite.internal.util.GridReflectionCache;
import org.apache.ignite.internal.util.typedef.P1;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.jetbrains.annotations.Nullable;

public class GridCacheDefaultAffinityKeyMapper
implements AffinityKeyMapper {
    private static final long serialVersionUID = 0L;
    protected transient Ignite ignite;
    private GridReflectionCache reflectCache = new GridReflectionCache((IgnitePredicate<Field>)new P1<Field>(){

        @Override
        public boolean apply(Field f) {
            return f.getAnnotation(AffinityKeyMapped.class) != null;
        }
    }, null);
    @LoggerResource
    protected transient IgniteLogger log;

    @Override
    public Object affinityKey(Object key) {
        GridArgumentCheck.notNull(key, "key");
        try {
            Object o = this.reflectCache.firstFieldValue(key);
            if (o != null) {
                return o;
            }
        }
        catch (IgniteCheckedException e) {
            U.error(this.log, "Failed to access affinity field for key [field=" + this.reflectCache.firstField(key.getClass()) + ", key=" + key + ']', e);
        }
        return key;
    }

    @Nullable
    public String affinityKeyPropertyName(Class<?> cls) {
        Field field = this.reflectCache.firstField(cls);
        if (field != null) {
            return field.getName();
        }
        return null;
    }

    @IgniteInstanceResource
    public void ignite(Ignite ignite) {
        this.ignite = ignite;
    }

    @Override
    public void reset() {
    }
}

