/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.freelist.io.PagesListNodeIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class PagesListSetPreviousRecord
extends PageDeltaRecord {
    private final long prevPageId;

    public PagesListSetPreviousRecord(int grpId, long pageId, long prevPageId) {
        super(grpId, pageId);
        this.prevPageId = prevPageId;
    }

    public long previousPageId() {
        return this.prevPageId;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        PagesListNodeIO io = PagesListNodeIO.VERSIONS.forPage(pageAddr);
        io.setPreviousId(pageAddr, this.prevPageId);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.PAGES_LIST_SET_PREVIOUS;
    }

    @Override
    public String toString() {
        return S.toString(PagesListSetPreviousRecord.class, this, "super", super.toString());
    }
}

