/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryType;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryObjectExImpl;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.binary.BinaryPrimitives;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryReaderHandles;
import org.apache.ignite.internal.binary.BinarySchema;
import org.apache.ignite.internal.binary.BinarySerializedFieldComparator;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.builder.BinaryObjectBuilderImpl;
import org.apache.ignite.internal.binary.streams.BinaryOffheapInputStream;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public class BinaryObjectOffheapImpl
extends BinaryObjectExImpl
implements Externalizable,
CacheObject {
    private static final long serialVersionUID = 0L;
    private final BinaryContext ctx;
    private final long ptr;
    private final int start;
    private final int size;

    public BinaryObjectOffheapImpl() {
        throw new UnsupportedOperationException();
    }

    public BinaryObjectOffheapImpl(BinaryContext ctx, long ptr, int start, int size) {
        this.ctx = ctx;
        this.ptr = ptr;
        this.start = start;
        this.size = size;
    }

    public BinaryObject heapCopy() {
        return new BinaryObjectImpl(this.ctx, U.copyMemory(this.ptr, this.size), this.start);
    }

    @Override
    public int typeId() {
        int typeId = BinaryPrimitives.readInt(this.ptr, this.start + 4);
        if (typeId == 0) {
            int off = this.start + 24;
            String clsName = BinaryUtils.doReadClassName(new BinaryOffheapInputStream(this.ptr + (long)off, this.size));
            typeId = this.ctx.typeId(clsName);
        }
        return typeId;
    }

    @Override
    public int length() {
        return BinaryPrimitives.readInt(this.ptr, this.start + 12);
    }

    public int hashCode() {
        return BinaryPrimitives.readInt(this.ptr, this.start + 8);
    }

    @Override
    public boolean hasSchema() {
        short flags = BinaryPrimitives.readShort(this.ptr, this.start + 2);
        return BinaryUtils.hasSchema(flags);
    }

    @Override
    public int schemaId() {
        return BinaryPrimitives.readInt(this.ptr, this.start + 16);
    }

    @Override
    public BinarySchema createSchema() {
        return this.reader(null, false).getOrCreateSchema();
    }

    @Override
    public BinaryContext context() {
        return this.ctx;
    }

    @Override
    public int start() {
        return this.start;
    }

    @Override
    public byte[] array() {
        return null;
    }

    @Override
    public boolean putValue(ByteBuffer buf) throws IgniteCheckedException {
        throw new UnsupportedOperationException("TODO implement");
    }

    @Override
    public int putValue(long addr) throws IgniteCheckedException {
        throw new UnsupportedOperationException("TODO implement");
    }

    @Override
    public boolean putValue(ByteBuffer buf, int off, int len) throws IgniteCheckedException {
        throw new UnsupportedOperationException("TODO implement");
    }

    @Override
    public int valueBytesLength(CacheObjectContext ctx) throws IgniteCheckedException {
        throw new UnsupportedOperationException("TODO implement");
    }

    @Override
    public long offheapAddress() {
        return this.ptr;
    }

    @Override
    public boolean hasArray() {
        return false;
    }

    @Override
    public boolean isFlagSet(short flag) {
        short flags = BinaryPrimitives.readShort(this.ptr, this.start + 2);
        return BinaryUtils.isFlagSet(flags, flag);
    }

    @Override
    @Nullable
    public BinaryType type() throws BinaryObjectException {
        return BinaryUtils.typeProxy(this.ctx, this);
    }

    @Override
    @Nullable
    public BinaryType rawType() throws BinaryObjectException {
        return BinaryUtils.type(this.ctx, this);
    }

    @Override
    @Nullable
    public <F> F field(String fieldName) throws BinaryObjectException {
        return (F)this.reader(null, false).unmarshalField(fieldName);
    }

    @Override
    @Nullable
    public <F> F field(int fieldId) throws BinaryObjectException {
        return (F)this.reader(null, false).unmarshalField(fieldId);
    }

    @Override
    public BinarySerializedFieldComparator createFieldComparator() {
        int schemaOff = BinaryPrimitives.readInt(this.ptr, this.start + 20);
        short flags = BinaryPrimitives.readShort(this.ptr, this.start + 2);
        int fieldIdLen = BinaryUtils.isCompactFooter(flags) ? 0 : 4;
        int fieldOffLen = BinaryUtils.fieldOffsetLength(flags);
        int orderBase = this.start + schemaOff + fieldIdLen;
        int orderMultiplier = fieldIdLen + fieldOffLen;
        return new BinarySerializedFieldComparator(this, null, this.ptr, this.start, orderBase, orderMultiplier, fieldOffLen);
    }

    @Override
    public int dataStartOffset() {
        int typeId = BinaryPrimitives.readInt(this.ptr, this.start + 4);
        if (typeId == 0) {
            int len = BinaryPrimitives.readInt(this.ptr, this.start + 24 + 1);
            return this.start + 24 + len + 5;
        }
        return this.start + 24;
    }

    @Override
    public int footerStartOffset() {
        short flags = BinaryPrimitives.readShort(this.ptr, this.start + 2);
        if (!BinaryUtils.hasSchema(flags)) {
            return this.start + this.length();
        }
        return this.start + BinaryPrimitives.readInt(this.ptr, this.start + 20);
    }

    @Override
    @Nullable
    public <F> F fieldByOrder(int order) {
        Object val;
        if (order == -1) {
            return null;
        }
        int schemaOff = BinaryPrimitives.readInt(this.ptr, this.start + 20);
        short flags = BinaryPrimitives.readShort(this.ptr, this.start + 2);
        int fieldIdLen = BinaryUtils.isCompactFooter(flags) ? 0 : 4;
        int fieldOffLen = BinaryUtils.fieldOffsetLength(flags);
        int fieldOffsetPos = this.start + schemaOff + order * (fieldIdLen + fieldOffLen) + fieldIdLen;
        int fieldPos = fieldOffLen == 1 ? this.start + (BinaryPrimitives.readByte(this.ptr, fieldOffsetPos) & 0xFF) : (fieldOffLen == 2 ? this.start + (BinaryPrimitives.readShort(this.ptr, fieldOffsetPos) & 0xFFFF) : this.start + BinaryPrimitives.readInt(this.ptr, fieldOffsetPos));
        byte hdr = BinaryPrimitives.readByte(this.ptr, fieldPos);
        switch (hdr) {
            case 3: {
                val = BinaryPrimitives.readInt(this.ptr, fieldPos + 1);
                break;
            }
            case 4: {
                val = BinaryPrimitives.readLong(this.ptr, fieldPos + 1);
                break;
            }
            case 8: {
                val = BinaryPrimitives.readBoolean(this.ptr, fieldPos + 1);
                break;
            }
            case 2: {
                val = BinaryPrimitives.readShort(this.ptr, fieldPos + 1);
                break;
            }
            case 1: {
                val = BinaryPrimitives.readByte(this.ptr, fieldPos + 1);
                break;
            }
            case 7: {
                val = Character.valueOf(BinaryPrimitives.readChar(this.ptr, fieldPos + 1));
                break;
            }
            case 5: {
                val = Float.valueOf(BinaryPrimitives.readFloat(this.ptr, fieldPos + 1));
                break;
            }
            case 6: {
                val = BinaryPrimitives.readDouble(this.ptr, fieldPos + 1);
                break;
            }
            case 9: {
                int dataLen = BinaryPrimitives.readInt(this.ptr, fieldPos + 1);
                byte[] data = BinaryPrimitives.readByteArray(this.ptr, fieldPos + 5, dataLen);
                val = new String(data, StandardCharsets.UTF_8);
                break;
            }
            case 11: {
                long time = BinaryPrimitives.readLong(this.ptr, fieldPos + 1);
                val = new Date(time);
                break;
            }
            case 33: {
                long time = BinaryPrimitives.readLong(this.ptr, fieldPos + 1);
                int nanos = BinaryPrimitives.readInt(this.ptr, fieldPos + 1 + 8);
                Timestamp ts = new Timestamp(time);
                ts.setNanos(ts.getNanos() + nanos);
                val = ts;
                break;
            }
            case 36: {
                long time = BinaryPrimitives.readLong(this.ptr, fieldPos + 1);
                val = new Time(time);
                break;
            }
            case 10: {
                long most = BinaryPrimitives.readLong(this.ptr, fieldPos + 1);
                long least = BinaryPrimitives.readLong(this.ptr, fieldPos + 1 + 8);
                val = new UUID(most, least);
                break;
            }
            case 30: {
                boolean negative;
                int scale = BinaryPrimitives.readInt(this.ptr, fieldPos + 1);
                int dataLen = BinaryPrimitives.readInt(this.ptr, fieldPos + 5);
                byte[] data = BinaryPrimitives.readByteArray(this.ptr, fieldPos + 9, dataLen);
                boolean bl = negative = data[0] < 0;
                if (negative) {
                    data[0] = (byte)(data[0] & 0x7F);
                }
                BigInteger intVal = new BigInteger(data);
                if (negative) {
                    intVal = intVal.negate();
                }
                val = new BigDecimal(intVal, scale);
                break;
            }
            case 101: {
                val = null;
                break;
            }
            default: {
                BinaryOffheapInputStream stream = new BinaryOffheapInputStream(this.ptr, this.size, false);
                stream.position(fieldPos);
                val = BinaryUtils.unmarshal(stream, this.ctx, null);
            }
        }
        return (F)val;
    }

    @Override
    protected boolean writeFieldByOrder(int fieldOffset, ByteBuffer buf) {
        return false;
    }

    @Override
    @Nullable
    protected <F> F field(BinaryReaderHandles rCtx, String fieldName) {
        return (F)this.reader(rCtx, false).unmarshalField(fieldName);
    }

    @Override
    public boolean hasField(String fieldName) {
        return this.reader(null, false).findFieldByName(fieldName);
    }

    @Override
    @Nullable
    public <T> T deserialize() throws BinaryObjectException {
        return (T)this.deserializeValue();
    }

    @Override
    public BinaryObject clone() throws CloneNotSupportedException {
        return this.heapCopy();
    }

    @Override
    public BinaryObjectBuilder toBuilder() throws BinaryObjectException {
        return BinaryObjectBuilderImpl.wrap(this.heapCopy());
    }

    @Override
    public byte cacheObjectType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPlatformType() {
        return false;
    }

    @Override
    @Nullable
    public <T> T value(CacheObjectValueContext ctx, boolean cpy) {
        return (T)this.deserializeValue();
    }

    @Override
    public byte[] valueBytes(CacheObjectValueContext ctx) throws IgniteCheckedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheObject prepareForCache(CacheObjectContext ctx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void finishUnmarshal(CacheObjectValueContext ctx, ClassLoader ldr) throws IgniteCheckedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void prepareMarshal(CacheObjectValueContext ctx) throws IgniteCheckedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short directType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte fieldsCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onAckReceived() {
    }

    private Object deserializeValue() {
        return this.reader(null, true).deserialize();
    }

    private BinaryReaderExImpl reader(@Nullable BinaryReaderHandles rCtx, boolean forUnmarshal) {
        BinaryOffheapInputStream stream = new BinaryOffheapInputStream(this.ptr, this.size, false);
        stream.position(this.start);
        return new BinaryReaderExImpl(this.ctx, stream, this.ctx.configuration().getClassLoader(), rCtx, forUnmarshal);
    }
}

