/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryWriteReplacer;
import org.jetbrains.annotations.Nullable;

public class BinaryMethodWriteReplacer
implements BinaryWriteReplacer {
    private final Method mthd;

    public BinaryMethodWriteReplacer(Method mthd) {
        assert (mthd != null);
        this.mthd = mthd;
    }

    @Override
    @Nullable
    public Object replace(Object target) {
        try {
            return this.mthd.invoke(target, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof BinaryObjectException) {
                throw (BinaryObjectException)e.getTargetException();
            }
            throw new BinaryObjectException("Failed to execute writeReplace() method on " + target, e);
        }
    }
}

