/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.binary.BinaryObjectException;

public class BinaryEnumCache {
    private static final ConcurrentMap<Class<?>, Object[]> ENUM_CACHE = new ConcurrentHashMap();

    public static <T> T get(Class<?> cls, int ord) throws BinaryObjectException {
        assert (cls != null);
        if (ord >= 0) {
            Object[] vals = (Object[])ENUM_CACHE.get(cls);
            if (vals == null) {
                vals = cls.getEnumConstants();
                ENUM_CACHE.putIfAbsent(cls, vals);
            }
            if (ord < vals.length) {
                return (T)vals[ord];
            }
            throw new BinaryObjectException("Failed to get enum value for ordinal (do you have correct class version?) [cls=" + cls.getName() + ", ordinal=" + ord + ", totalValues=" + vals.length + ']');
        }
        return null;
    }

    public static void clear() {
        ENUM_CACHE.clear();
    }
}

