/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.io.Closeable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteScheduler;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.timeout.GridTimeoutProcessor;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.scheduler.SchedulerFuture;
import org.jetbrains.annotations.Nullable;

public class IgniteSchedulerImpl
implements IgniteScheduler,
Externalizable {
    private static final long serialVersionUID = 0L;
    private GridKernalContext ctx;

    public IgniteSchedulerImpl() {
    }

    public IgniteSchedulerImpl(GridKernalContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public IgniteFuture<?> runLocal(Runnable r) {
        A.notNull(r, "r");
        this.guard();
        try {
            IgniteFutureImpl igniteFutureImpl = new IgniteFutureImpl(this.ctx.closure().runLocalSafe(r, false));
            return igniteFutureImpl;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Closeable runLocal(@Nullable Runnable r, long delay, TimeUnit timeUnit) {
        A.notNull(r, "r");
        A.ensure(delay > 0L, "Illegal delay");
        this.guard();
        try {
            GridTimeoutProcessor.CancelableTask cancelableTask = this.ctx.timeout().schedule(r, timeUnit.toMillis(delay), -1L);
            return cancelableTask;
        }
        finally {
            this.unguard();
        }
    }

    @Override
    public <R> IgniteFuture<R> callLocal(Callable<R> c) {
        A.notNull(c, "c");
        this.guard();
        try {
            IgniteFutureImpl<R> igniteFutureImpl = new IgniteFutureImpl<R>(this.ctx.closure().callLocalSafe(c, false));
            return igniteFutureImpl;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SchedulerFuture<?> scheduleLocal(Runnable job, String ptrn) {
        A.notNull(job, "job");
        this.guard();
        try {
            SchedulerFuture<?> schedulerFuture = this.ctx.schedule().schedule(job, ptrn);
            return schedulerFuture;
        }
        finally {
            this.unguard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> SchedulerFuture<R> scheduleLocal(Callable<R> job, String ptrn) {
        A.notNull(job, "job");
        this.guard();
        try {
            SchedulerFuture<R> schedulerFuture = this.ctx.schedule().schedule(job, ptrn);
            return schedulerFuture;
        }
        finally {
            this.unguard();
        }
    }

    private void guard() {
        this.ctx.gateway().readLock();
    }

    private void unguard() {
        this.ctx.gateway().readUnlock();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.ctx);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ctx = (GridKernalContext)in.readObject();
    }

    private Object readResolve() throws ObjectStreamException {
        return this.ctx.grid().scheduler();
    }
}

