/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.util.table;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zillion.database.util.ITableWrapper;
import com.zillion.util.common.HashObject;
import com.zillion.util.common.ZillionConstant;
import com.zillion.util.table.SchemaRepositoryContainer;
import com.zillion.util.table.ZillionTableColumn;
import com.zillion.util.table.ZillionTableIndex;
import com.zillion.util.table.ZillionTableUsing;
import com.zillion.util.zk.ZKLockCEDU;
import com.zillion.util.zk.ZKLockRW;
import com.zillion.util.zk.ZKWrapper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.zillion.util.common.HexToByte;
import org.zillion.util.common.MyException;
import org.zillion.util.log.LogUtil;

public class ZillionTableSchema {
    public int version;
    public JSONObject JSON;
    public boolean delete_UsePutV = true;
    public boolean compress = false;
    public boolean resident_memory = false;
    public boolean store_in_minor_db = false;
    public String table_type;
    public String split_column;
    public byte[][] splitKeys;
    public String Namespace;
    public String table_name;
    public Map<String, ZillionTableColumn> ColumnMap = new HashMap<String, ZillionTableColumn>();
    public String[] Key;
    public Map<String, Boolean> KeyMap;
    public String[] OtherColumn;
    public List<ZillionTableIndex> Indexes = new ArrayList<ZillionTableIndex>();
    private String table_lock = null;
    private ZillionTableUsing using = new ZillionTableUsing();
    private List<ITableWrapper> wrapperList = new ArrayList<ITableWrapper>();
    private Map<String, List<ITableWrapper>> split_wrapperListMap = new HashMap<String, List<ITableWrapper>>();
    private Date last_refresh = null;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");

    public ZillionTableSchema(String Namespace, String TableName2) {
        this.Namespace = Namespace;
        this.table_name = TableName2;
    }

    public synchronized void AddIndex(ZillionTableIndex index) throws Exception {
        this.Indexes.add(index);
    }

    public synchronized ZillionTableIndex RemoveIndex(String indexName) throws Exception {
        ZillionTableIndex result = null;
        int i = 0;
        while (i < this.Indexes.size()) {
            ZillionTableIndex index = this.Indexes.get(i);
            if (index.index_name.equals(indexName)) {
                result = this.Indexes.remove(i);
                break;
            }
            ++i;
        }
        return result;
    }

    public synchronized ITableWrapper connect(SchemaRepositoryContainer container, String child_name, boolean create_split_table) throws Exception {
        if (this.table_type.equals("split_hour")) {
            if (child_name.length() != 10) {
                throw new MyException(String.valueOf(this.table_type) + "\t" + "SplitTime length error:" + "\t" + child_name);
            }
            this.sdf.parse(String.valueOf(child_name) + "0000");
        } else if (this.table_type.equals("split_day")) {
            if (child_name.length() != 8) {
                throw new MyException(String.valueOf(this.table_type) + "\t" + "SplitTime length error:" + "\t" + child_name);
            }
            this.sdf.parse(String.valueOf(child_name) + "000000");
        } else if (this.table_type.equals("split_month")) {
            if (child_name.length() != 6) {
                throw new MyException(String.valueOf(this.table_type) + "\t" + "SplitTime length error:" + "\t" + child_name);
            }
            this.sdf.parse(String.valueOf(child_name) + "01000000");
        } else if (this.table_type.equals("split_year")) {
            if (child_name.length() != 4) {
                throw new MyException(String.valueOf(this.table_type) + "\t" + "SplitTime length error:" + "\t" + child_name);
            }
            this.sdf.parse(String.valueOf(child_name) + "0101000000");
        }
        ITableWrapper wrapper = null;
        if (this.table_type != null && this.table_type.startsWith("split_")) {
            String tableName;
            int wrapper_count = 0;
            if (this.split_wrapperListMap.containsKey(child_name)) {
                List<ITableWrapper> split_wrapperList = this.split_wrapperListMap.get(child_name);
                for (ITableWrapper entity : split_wrapperList) {
                    if (!entity.can_use()) continue;
                    wrapper = entity;
                    break;
                }
                if (wrapper != null) {
                    wrapper.use();
                    return wrapper;
                }
                wrapper_count = split_wrapperList.size();
            }
            if (container.DatabaseImpl.ori_tableExists(this.Namespace, tableName = "zillion_data_" + this.table_name + "_" + child_name)) {
                wrapper = container.DatabaseImpl.generateTableWrapper(this.Namespace, tableName, wrapper_count);
                if (!this.split_wrapperListMap.containsKey(child_name)) {
                    this.split_wrapperListMap.put(child_name, new ArrayList());
                }
                List<ITableWrapper> split_wrapperList = this.split_wrapperListMap.get(child_name);
                split_wrapperList.add(wrapper);
                wrapper.use();
                return wrapper;
            }
            if (create_split_table) {
                String method_name = Thread.currentThread().getStackTrace()[1].getMethodName();
                String zkpath_namespace = "/zillion/ns/" + this.Namespace;
                Stat stat = container.ZK.exists(String.valueOf(zkpath_namespace) + "/splitlocks", false);
                if (stat == null) {
                    try {
                        container.ZK.create(String.valueOf(zkpath_namespace) + "/splitlocks", "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                String parent_path_meta = String.valueOf(zkpath_namespace) + "/splitlocks" + "/" + this.table_name;
                String lock_type_meta = "w";
                stat = container.ZK.exists(parent_path_meta, false);
                if (stat == null) {
                    try {
                        container.ZK.create(parent_path_meta, "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                String node_path_meta = ZKLockRW.Create(container.ZK, parent_path_meta, lock_type_meta, "create_split_table");
                try {
                    LogUtil.info(" ********************************** " + method_name + " metalock:" + " WaitFor " + node_path_meta);
                    boolean wait_success = ZKLockRW.WaitFor(container.ZK, parent_path_meta, node_path_meta, ZillionConstant.WaitFor_seconds_create_split_table);
                    LogUtil.info(" ********************************** " + method_name + " metalock:" + " WaitFor " + wait_success + " " + node_path_meta);
                    if (!wait_success) {
                        throw new MyException("ZillionAgent: WaitFor fail " + node_path_meta);
                    }
                    HashObject hashObject = new HashObject();
                    byte[] hash = hashObject.toBytes();
                    container.ZK.create(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + this.table_name + "/" + child_name, hash, CreateMode.PERSISTENT);
                    container.ZK.create(String.valueOf(zkpath_namespace) + "/hash_tmp" + "/" + this.table_name + "/" + child_name, "true".getBytes("UTF-8"), CreateMode.PERSISTENT);
                    container.DatabaseImpl.meta_query_insert_split(this.Namespace, String.valueOf(this.table_name) + "_" + child_name, hashObject);
                    byte[][] splitKeys = null;
                    if (this.JSON.containsKey((Object)"region_keys")) {
                        JSONArray region_keys = (JSONArray)this.JSON.get((Object)"region_keys");
                        splitKeys = new byte[region_keys.size()][];
                        int index_key = 0;
                        while (index_key < region_keys.size()) {
                            String region_key = (String)region_keys.get(index_key);
                            splitKeys[index_key] = HexToByte.hexToByte(region_key);
                            ++index_key;
                        }
                    }
                    container.DatabaseImpl.table_manage_create_split_data(this.Namespace, this.table_name, child_name, this);
                    wrapper = container.DatabaseImpl.generateTableWrapper(this.Namespace, tableName, wrapper_count);
                    if (!this.split_wrapperListMap.containsKey(child_name)) {
                        this.split_wrapperListMap.put(child_name, new ArrayList());
                    }
                    List<ITableWrapper> split_wrapperList = this.split_wrapperListMap.get(child_name);
                    split_wrapperList.add(wrapper);
                    wrapper.use();
                    ITableWrapper iTableWrapper = wrapper;
                    return iTableWrapper;
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    ZKLockRW.Finish(container.ZK, node_path_meta);
                    LogUtil.info(" ********************************** " + method_name + " metalock:" + " finish " + node_path_meta);
                }
            }
            return null;
        }
        for (ITableWrapper entity : this.wrapperList) {
            if (!entity.can_use()) continue;
            wrapper = entity;
            break;
        }
        if (wrapper == null) {
            wrapper = container.DatabaseImpl.generateTableWrapper(this.Namespace, "zillion_data_" + this.table_name, this.wrapperList.size());
            this.wrapperList.add(wrapper);
        }
        wrapper.use();
        return wrapper;
    }

    public synchronized void close() {
        if (this.table_type != null && this.table_type.startsWith("split_")) {
            for (String key : this.split_wrapperListMap.keySet()) {
                List<ITableWrapper> split_wrapperList = this.split_wrapperListMap.get(key);
                for (ITableWrapper entity : split_wrapperList) {
                    entity.close();
                }
            }
            this.split_wrapperListMap.clear();
        } else {
            for (ITableWrapper entity : this.wrapperList) {
                entity.close();
            }
            this.wrapperList.clear();
        }
    }

    public synchronized void usingAdd() {
        ++this.using.Count;
    }

    public synchronized void usingDel() {
        --this.using.Count;
        this.using.EndTime = new Date();
    }

    public synchronized void timeout_unuse(SchemaRepositoryContainer container) throws Exception {
        Date currentTime = new Date();
        if (this.using.Count == 0 && this.using.EndTime != null && currentTime.getTime() - this.using.EndTime.getTime() > ZillionConstant.table_timeout) {
            this.unuseTable(container.ZK);
        }
    }

    public synchronized void RefreshTableWrapper(SchemaRepositoryContainer container) throws Exception {
        if (this.table_type != null && this.table_type.startsWith("split_")) {
            Date currentTime = new Date();
            if (this.last_refresh != null && currentTime.getTime() - this.last_refresh.getTime() < ZillionConstant.table_timeout) {
                return;
            }
            this.last_refresh = currentTime;
            ArrayList<String> removeList = new ArrayList<String>();
            Iterator<String> keyIter = this.split_wrapperListMap.keySet().iterator();
            if (keyIter.hasNext()) {
                String key = keyIter.next();
                List<ITableWrapper> split_wrapperList = this.split_wrapperListMap.get(key);
                String child_name = key;
                String tableName = "zillion_data_" + this.table_name + "_" + child_name;
                if (!container.DatabaseImpl.ori_tableExists(this.Namespace, tableName)) {
                    Iterator iterator = split_wrapperList.iterator();
                    while (iterator.hasNext()) {
                        ITableWrapper entity = (ITableWrapper)iterator.next();
                        entity.close();
                    }
                    removeList.add(child_name);
                    LogUtil.warn("child_name\t" + this.table_name + "_" + child_name + "\t" + "clear");
                }
            }
            for (String remove : removeList) {
                this.split_wrapperListMap.remove(remove);
            }
            int i = 0;
            while (i < this.Indexes.size()) {
                ZillionTableIndex index = this.Indexes.get(i);
                index.RefreshTableWrapper(container);
                ++i;
            }
        }
    }

    public synchronized boolean useTable(ZKWrapper zookeeper, String lock_content) throws Exception {
        if (this.table_lock != null) {
            return true;
        }
        String zkpath_namespace = "/zillion/ns/" + this.Namespace;
        String parent_path_table = String.valueOf(zkpath_namespace) + "/tablelocks" + "/" + this.table_name;
        String lock_type_table = "u";
        String check_type_table = "d";
        boolean success = ZKLockCEDU.PreCheck(zookeeper, parent_path_table, check_type_table);
        if (success) {
            String node_path_table = ZKLockCEDU.Create(zookeeper, parent_path_table, lock_type_table, lock_content);
            int sequence_id = Integer.parseInt(node_path_table.substring(parent_path_table.length() + 3));
            success = ZKLockCEDU.Check(zookeeper, parent_path_table, sequence_id, check_type_table);
            if (success) {
                LogUtil.info(" **********************************  tablelock: WaitOnce " + node_path_table);
                boolean wait_success = ZKLockCEDU.WaitFor(zookeeper, parent_path_table, node_path_table, ZillionConstant.WaitFor_seconds);
                LogUtil.info(" **********************************  tablelock: WaitOnce " + wait_success + " " + node_path_table);
                if (wait_success) {
                    this.table_lock = node_path_table;
                    return true;
                }
                ZKLockCEDU.Finish(zookeeper, node_path_table);
                return false;
            }
            ZKLockCEDU.Finish(zookeeper, node_path_table);
            LogUtil.info(" **********************************  tablelock: Check fail " + node_path_table);
            return false;
        }
        LogUtil.info(" **********************************  tablelock: PreCheck fail ");
        return false;
    }

    public synchronized void unuseTable(ZKWrapper zookeeper) throws Exception {
        if (this.table_lock != null) {
            String node_path_table = this.table_lock;
            ZKLockCEDU.Finish(zookeeper, node_path_table);
            this.table_lock = null;
            LogUtil.info(" **********************************  tablelock: finish " + node_path_table);
        }
    }
}

