/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.database.agent;

import com.zillion.database.agent.ZillionHashWorkerItem;
import com.zillion.database.agent.ZillionHashWorkerThread;
import com.zillion.database.async.AsyncJob;
import com.zillion.util.common.HashObject;
import com.zillion.util.common.HashUtil;
import com.zillion.util.table.SchemaRepositoryContainer;
import com.zillion.util.table.SchemaWrapper;
import com.zillion.util.table.ZillionTableIndex;
import com.zillion.util.table.ZillionTableSchema;
import java.util.ArrayList;
import java.util.List;
import org.zillion.util.common.MyException;
import org.zillion.util.log.LogUtil;

public class ZillionHashWorker {
    public String work_type;
    public SchemaRepositoryContainer container;
    public ZillionTableSchema schema;
    public List<ZillionTableIndex> schema_indexList;
    public AsyncJob asyncJob;
    int thread_count = 8;
    List<ZillionHashWorkerItem> jobList;
    int jobIndex = 0;

    public synchronized ZillionHashWorkerItem Pop() {
        ZillionHashWorkerItem result = null;
        if (this.jobIndex < this.jobList.size()) {
            result = this.jobList.get(this.jobIndex++);
            if (this.work_type.equals("RefreshHash")) {
                String fullName = this.schema.table_name;
                if (result.schema_index != null) {
                    fullName = String.valueOf(this.schema.table_name) + "." + result.schema_index.index_name;
                }
                if (this.schema.table_type != null && this.schema.table_type.startsWith("split_")) {
                    LogUtil.warn(String.valueOf(this.work_type) + "\t" + fullName + "_" + result.schemaWrapper.child_name);
                } else {
                    LogUtil.warn(String.valueOf(this.work_type) + "\t" + fullName);
                }
            } else {
                String tableName = this.schema.table_name;
                StringBuffer sb = new StringBuffer();
                sb.append("[");
                for (ZillionTableIndex index : this.schema_indexList) {
                    if (sb.length() > 1) {
                        sb.append(",");
                    }
                    sb.append(index.index_name);
                }
                sb.append("]");
                if (this.schema.table_type != null && this.schema.table_type.startsWith("split_")) {
                    LogUtil.warn(String.valueOf(this.work_type) + "\t" + tableName + "." + sb.toString() + "_" + result.schemaWrapper.child_name);
                } else {
                    LogUtil.warn(String.valueOf(this.work_type) + "\t" + tableName + "." + sb.toString());
                }
            }
        }
        return result;
    }

    public ZillionHashWorker(SchemaRepositoryContainer container, ZillionTableSchema schema, String work_type, List<ZillionTableIndex> schema_indexList, List<SchemaWrapper> schemaWrapperList, int thread_count, AsyncJob asyncJob) {
        this.work_type = work_type;
        this.container = container;
        this.schema = schema;
        this.schema_indexList = schema_indexList;
        this.jobList = new ArrayList<ZillionHashWorkerItem>();
        for (SchemaWrapper schemaWrapper : schemaWrapperList) {
            this.jobList.add(new ZillionHashWorkerItem(schemaWrapper, this.schema));
        }
        this.thread_count = thread_count > this.jobList.size() ? this.jobList.size() : thread_count;
        this.asyncJob = asyncJob;
    }

    public ZillionHashWorker(SchemaRepositoryContainer container, ZillionTableSchema schema, List<SchemaWrapper> schemaWrapperList, int thread_count, AsyncJob asyncJob) {
        this.work_type = "RefreshHash";
        this.container = container;
        this.schema = schema;
        this.schema_indexList = new ArrayList<ZillionTableIndex>();
        this.jobList = new ArrayList<ZillionHashWorkerItem>();
        for (SchemaWrapper schemaWrapper : schemaWrapperList) {
            this.jobList.add(new ZillionHashWorkerItem(schemaWrapper, schema));
            for (ZillionTableIndex schema_index : schema.Indexes) {
                this.jobList.add(new ZillionHashWorkerItem(schemaWrapper, schema_index));
            }
        }
        this.thread_count = thread_count > this.jobList.size() ? this.jobList.size() : thread_count;
        this.asyncJob = asyncJob;
    }

    public HashObject Do() throws Exception {
        HashObject result;
        block14: {
            String zkpath_namespace;
            String namespace;
            block13: {
                boolean all_finish;
                ArrayList<ZillionHashWorkerThread> threadList = new ArrayList<ZillionHashWorkerThread>();
                int index2 = 0;
                while (index2 < this.thread_count) {
                    ZillionHashWorkerThread thread = new ZillionHashWorkerThread(this);
                    thread.start();
                    threadList.add(thread);
                    ++index2;
                }
                block3: do {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException index2) {
                        // empty catch block
                    }
                    all_finish = true;
                    for (ZillionHashWorkerThread thread : threadList) {
                        if (!thread.isAlive()) continue;
                        all_finish = false;
                        continue block3;
                    }
                } while (!all_finish);
                result = new HashObject();
                if (!this.work_type.equals("RefreshHash")) break block13;
                namespace = this.schema.Namespace;
                zkpath_namespace = "/zillion/ns/" + namespace;
                String tableName = this.schema.table_name;
                for (ZillionHashWorkerItem workItem : this.jobList) {
                    if (!workItem.finish) {
                        throw new MyException("ZillionHash: some job not finish");
                    }
                    if (workItem.schema == null) continue;
                    result.insert_count += workItem.hash.insert_count;
                    result.hash_code = HashUtil.merge_hash_code(result.hash_code, workItem.hash.hash_code);
                }
                this.container.DatabaseImpl.meta_query_update_data(namespace, tableName, result);
                byte[] hash = result.toBytes();
                this.container.ZK.setData(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName, hash, -1);
                for (ZillionTableIndex schema_index : this.schema.Indexes) {
                    String indexName = schema_index.index_name;
                    HashObject hashObjectInner = new HashObject();
                    for (ZillionHashWorkerItem workItem : this.jobList) {
                        if (!workItem.finish) {
                            throw new MyException("ZillionHash: some job not finish");
                        }
                        if (workItem.schema_index == null || !workItem.schema_index.index_name.equals(indexName)) continue;
                        hashObjectInner.insert_count += workItem.hash.insert_count;
                        hashObjectInner.hash_code = HashUtil.merge_hash_code(hashObjectInner.hash_code, workItem.hash.hash_code);
                    }
                    this.container.DatabaseImpl.meta_query_update_index(namespace, tableName, indexName, hashObjectInner);
                    byte[] hash2 = hashObjectInner.toBytes();
                    this.container.ZK.setData(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName + "." + indexName, hash2, -1);
                }
                break block14;
            }
            namespace = this.schema.Namespace;
            zkpath_namespace = "/zillion/ns/" + namespace;
            String tableName = this.schema.table_name;
            for (ZillionHashWorkerItem workItem : this.jobList) {
                if (!workItem.finish) {
                    throw new MyException("ZillionHash: some job not finish");
                }
                result.insert_count += workItem.hash.insert_count;
                result.hash_code = HashUtil.merge_hash_code(result.hash_code, workItem.hash.hash_code);
            }
            this.container.DatabaseImpl.meta_query_update_data(namespace, tableName, result);
            byte[] hash = result.toBytes();
            this.container.ZK.setData(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName, hash, -1);
            if (!this.work_type.equals("AddIndex") && !this.work_type.equals("RepairIndex")) break block14;
            int index_index = 0;
            while (index_index < this.schema_indexList.size()) {
                ZillionTableIndex schema_index = this.schema_indexList.get(index_index);
                String indexName = schema_index.index_name;
                this.container.DatabaseImpl.meta_query_update_index(namespace, tableName, indexName, result);
                byte[] hash3 = result.toBytes();
                this.container.ZK.setData(String.valueOf(zkpath_namespace) + "/hash_exist" + "/" + tableName + "." + indexName, hash3, -1);
                ++index_index;
            }
        }
        return result;
    }
}

