/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.nio;

import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.util.nio.GridNioFilterChain;
import org.apache.ignite.internal.util.nio.GridNioFinishedFuture;
import org.apache.ignite.internal.util.nio.GridNioFuture;
import org.apache.ignite.internal.util.nio.GridNioRecoveryDescriptor;
import org.apache.ignite.internal.util.nio.GridNioSession;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.jetbrains.annotations.Nullable;

public class GridNioSessionImpl
implements GridNioSession {
    private final Object[] meta = new Object[64];
    private final InetSocketAddress locAddr;
    private final InetSocketAddress rmtAddr;
    private long createTime;
    private final AtomicLong closeTime = new AtomicLong();
    private volatile long bytesSent;
    private volatile long bytesRcvd;
    private volatile long bytesSent0;
    private volatile long bytesRcvd0;
    private volatile long sndSchedTime;
    private volatile long lastSndTime;
    private volatile long lastRcvTime;
    private volatile boolean readsPaused;
    private GridNioFilterChain filterChain;
    private final boolean accepted;

    public GridNioSessionImpl(GridNioFilterChain filterChain, @Nullable InetSocketAddress locAddr, @Nullable InetSocketAddress rmtAddr, boolean accepted) {
        long now;
        this.filterChain = filterChain;
        this.locAddr = locAddr;
        this.rmtAddr = rmtAddr;
        this.accepted = accepted;
        this.sndSchedTime = now = U.currentTimeMillis();
        this.createTime = now;
        this.lastSndTime = now;
        this.lastRcvTime = now;
    }

    @Override
    public GridNioFuture<?> send(Object msg) {
        try {
            this.resetSendScheduleTime();
            return this.chain().onSessionWrite(this, msg, true, null);
        }
        catch (IgniteCheckedException e) {
            this.close();
            return new GridNioFinishedFuture(e);
        }
    }

    @Override
    public void sendNoFuture(Object msg, IgniteInClosure<IgniteException> ackC) throws IgniteCheckedException {
        try {
            this.chain().onSessionWrite(this, msg, false, ackC);
        }
        catch (IgniteCheckedException e) {
            this.close();
            throw e;
        }
    }

    @Override
    public GridNioFuture<?> resumeReads() {
        try {
            return this.chain().onResumeReads(this);
        }
        catch (IgniteCheckedException e) {
            this.close();
            return new GridNioFinishedFuture(e);
        }
    }

    @Override
    public GridNioFuture<?> pauseReads() {
        try {
            return this.chain().onPauseReads(this);
        }
        catch (IgniteCheckedException e) {
            this.close();
            return new GridNioFinishedFuture(e);
        }
    }

    @Override
    public GridNioFuture<Boolean> close() {
        try {
            return this.filterChain.onSessionClose(this);
        }
        catch (IgniteCheckedException e) {
            return new GridNioFinishedFuture<Boolean>(e);
        }
    }

    @Override
    @Nullable
    public InetSocketAddress localAddress() {
        return this.locAddr;
    }

    @Override
    @Nullable
    public InetSocketAddress remoteAddress() {
        return this.rmtAddr;
    }

    @Override
    public long bytesSent() {
        return this.bytesSent;
    }

    @Override
    public long bytesReceived() {
        return this.bytesRcvd;
    }

    public long bytesSent0() {
        return this.bytesSent0;
    }

    public long bytesReceived0() {
        return this.bytesRcvd0;
    }

    public void reset0() {
        this.bytesSent0 = 0L;
        this.bytesRcvd0 = 0L;
    }

    @Override
    public long createTime() {
        return this.createTime;
    }

    @Override
    public long closeTime() {
        return this.closeTime.get();
    }

    @Override
    public long lastReceiveTime() {
        return this.lastRcvTime;
    }

    @Override
    public long lastSendTime() {
        return this.lastSndTime;
    }

    @Override
    public long lastSendScheduleTime() {
        return this.sndSchedTime;
    }

    @Override
    public <T> T meta(int key) {
        assert (key < this.meta.length);
        return (T)this.meta[key];
    }

    @Override
    public <T> T addMeta(int key, @Nullable T val) {
        assert (key < this.meta.length);
        Object prev = this.meta[key];
        this.meta[key] = val;
        return (T)prev;
    }

    @Override
    public <T> T removeMeta(int key) {
        assert (key < this.meta.length);
        Object prev = this.meta[key];
        this.meta[key] = null;
        return (T)prev;
    }

    @Override
    public boolean accepted() {
        return this.accepted;
    }

    protected <T> GridNioFilterChain<T> chain() {
        return this.filterChain;
    }

    public void bytesSent(int cnt) {
        this.bytesSent += (long)cnt;
        this.bytesSent0 += (long)cnt;
        this.lastSndTime = U.currentTimeMillis();
    }

    public void bytesReceived(int cnt) {
        this.bytesRcvd += (long)cnt;
        this.bytesRcvd0 += (long)cnt;
        this.lastRcvTime = U.currentTimeMillis();
    }

    public void resetSendScheduleTime() {
        this.sndSchedTime = U.currentTimeMillis();
    }

    public boolean setClosed() {
        return this.closeTime.compareAndSet(0L, U.currentTimeMillis());
    }

    public boolean closed() {
        return this.closeTime.get() != 0L;
    }

    public void readsPaused(boolean readsPaused) {
        this.readsPaused = readsPaused;
    }

    @Override
    public boolean readsPaused() {
        return this.readsPaused;
    }

    @Override
    public void outRecoveryDescriptor(GridNioRecoveryDescriptor recoveryDesc) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public GridNioRecoveryDescriptor outRecoveryDescriptor() {
        return null;
    }

    @Override
    public void inRecoveryDescriptor(GridNioRecoveryDescriptor recoveryDesc) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public GridNioRecoveryDescriptor inRecoveryDescriptor() {
        return null;
    }

    @Override
    public void systemMessage(Object msg) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return S.toString(GridNioSessionImpl.class, this);
    }
}

