/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastreamer;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class DataStreamerEntry
implements Map.Entry<KeyCacheObject, CacheObject>,
Message {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    protected KeyCacheObject key;
    @GridToStringInclude
    protected CacheObject val;

    public DataStreamerEntry() {
    }

    public DataStreamerEntry(KeyCacheObject key, CacheObject val) {
        this.key = key;
        this.val = val;
    }

    @Override
    public KeyCacheObject getKey() {
        return this.key;
    }

    @Override
    public CacheObject getValue() {
        return this.val;
    }

    @Override
    public CacheObject setValue(CacheObject val) {
        CacheObject old = this.val;
        this.val = val;
        return old;
    }

    public <K, V> Map.Entry<K, V> toEntry(final GridCacheContext ctx, final boolean keepBinary) {
        return new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return ctx.cacheObjectContext().unwrapBinaryIfNeeded(DataStreamerEntry.this.key, keepBinary, false);
            }

            @Override
            public V setValue(V val) {
                throw new UnsupportedOperationException();
            }

            @Override
            public V getValue() {
                return ctx.cacheObjectContext().unwrapBinaryIfNeeded(DataStreamerEntry.this.val, keepBinary, false);
            }
        };
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeMessage("key", this.key)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeMessage("val", this.val)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.key = (KeyCacheObject)reader.readMessage("key");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.val = (CacheObject)reader.readMessage("val");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(DataStreamerEntry.class);
    }

    @Override
    public short directType() {
        return 95;
    }

    @Override
    public byte fieldsCount() {
        return 2;
    }

    public String toString() {
        return S.toString(DataStreamerEntry.class, this);
    }
}

