/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class SplitExistingPageRecord
extends PageDeltaRecord {
    private int mid;
    @GridToStringExclude
    private long fwdId;

    public SplitExistingPageRecord(int grpId, long pageId, int mid, long fwdId) {
        super(grpId, pageId);
        this.mid = mid;
        this.fwdId = fwdId;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        Object io = PageIO.getBPlusIO(pageAddr);
        ((BPlusIO)io).splitExistingPage(pageAddr, this.mid, this.fwdId);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.BTREE_EXISTING_PAGE_SPLIT;
    }

    public int middleIndex() {
        return this.mid;
    }

    public long forwardId() {
        return this.fwdId;
    }

    @Override
    public String toString() {
        return S.toString(SplitExistingPageRecord.class, this, "fwId", U.hexLong(this.fwdId), "super", super.toString());
    }
}

