/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.pagemem.wal.WALPointer;
import org.apache.ignite.internal.pagemem.wal.record.CacheState;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class CheckpointRecord
extends WALRecord {
    private UUID cpId;
    private boolean end;
    private Map<Integer, CacheState> cacheGrpStates;
    private WALPointer cpMark;

    public CheckpointRecord(@Nullable WALPointer cpMark) {
        this(UUID.randomUUID(), cpMark);
    }

    public CheckpointRecord(UUID cpId, @Nullable WALPointer cpMark) {
        this.cpId = cpId;
        this.cpMark = cpMark;
    }

    public CheckpointRecord(UUID cpId, @Nullable WALPointer cpMark, boolean end) {
        this.cpId = cpId;
        this.end = end;
        this.cpMark = cpMark;
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.CHECKPOINT_RECORD;
    }

    public void addCacheGroupState(int grpId, CacheState state) {
        if (this.cacheGrpStates == null) {
            this.cacheGrpStates = new HashMap<Integer, CacheState>();
        }
        this.cacheGrpStates.put(grpId, state);
    }

    public void cacheGroupStates(Map<Integer, CacheState> cacheGrpStates) {
        this.cacheGrpStates = cacheGrpStates;
    }

    public Map<Integer, CacheState> cacheGroupStates() {
        return this.cacheGrpStates != null ? this.cacheGrpStates : Collections.emptyMap();
    }

    public UUID checkpointId() {
        return this.cpId;
    }

    public boolean end() {
        return this.end;
    }

    public WALPointer checkpointMark() {
        return this.cpMark;
    }

    @Override
    public String toString() {
        return S.toString(CheckpointRecord.class, this, "super", super.toString());
    }
}

