/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.binary.BinaryCollectionFactory;
import org.apache.ignite.binary.BinaryInvalidTypeException;
import org.apache.ignite.binary.BinaryMapFactory;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.internal.binary.BinaryClassDescriptor;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryEnumObjectImpl;
import org.apache.ignite.internal.binary.BinaryInternalMapper;
import org.apache.ignite.internal.binary.BinaryObjectImpl;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.binary.BinaryReaderHandles;
import org.apache.ignite.internal.binary.BinaryReaderHandlesHolder;
import org.apache.ignite.internal.binary.BinarySchema;
import org.apache.ignite.internal.binary.BinaryTypeImpl;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.binary.GridBinaryMarshaller;
import org.apache.ignite.internal.binary.streams.BinaryInputStream;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryReaderExImpl
implements BinaryReader,
BinaryRawReaderEx,
BinaryReaderHandlesHolder,
ObjectInput {
    private final BinaryContext ctx;
    private final BinaryInputStream in;
    private final ClassLoader ldr;
    private BinaryReaderHandles hnds;
    private final int start;
    private final int dataStart;
    private final int typeId;
    private final int rawOff;
    private final int footerStart;
    private final int footerLen;
    private BinaryClassDescriptor desc;
    private final BinaryInternalMapper mapper;
    private final int schemaId;
    private final boolean userType;
    private final int fieldIdLen;
    private final int fieldOffLen;
    private final BinarySchema schema;
    private boolean matching = true;
    private int matchingOrder;
    private boolean raw;

    public BinaryReaderExImpl(BinaryContext ctx, BinaryInputStream in, ClassLoader ldr, boolean forUnmarshal) {
        this(ctx, in, ldr, null, forUnmarshal);
    }

    public BinaryReaderExImpl(BinaryContext ctx, BinaryInputStream in, ClassLoader ldr, @Nullable BinaryReaderHandles hnds, boolean forUnmarshal) {
        this(ctx, in, ldr, hnds, false, forUnmarshal);
    }

    public BinaryReaderExImpl(BinaryContext ctx, BinaryInputStream in, ClassLoader ldr, @Nullable BinaryReaderHandles hnds, boolean skipHdrCheck, boolean forUnmarshal) {
        this.ctx = ctx;
        this.in = in;
        this.ldr = ldr;
        this.hnds = hnds;
        this.start = in.position();
        if (!skipHdrCheck && in.readByte() == 103) {
            BinaryUtils.checkProtocolVersion(in.readByte());
            short flags = in.readShort();
            int typeId0 = in.readInt();
            in.readInt();
            int len = in.readInt();
            this.schemaId = in.readInt();
            int offset = in.readInt();
            this.userType = BinaryUtils.isUserType(flags);
            this.fieldIdLen = BinaryUtils.fieldIdLength(flags);
            this.fieldOffLen = BinaryUtils.fieldOffsetLength(flags);
            if (BinaryUtils.hasSchema(flags)) {
                this.footerStart = this.start + offset;
                if (BinaryUtils.hasRaw(flags)) {
                    this.footerLen = len - offset - 4;
                    this.rawOff = this.start + in.readIntPositioned(this.start + len - 4);
                } else {
                    this.footerLen = len - offset;
                    this.rawOff = this.start + len;
                }
            } else {
                this.footerStart = this.start + len;
                this.footerLen = 0;
                this.rawOff = BinaryUtils.hasRaw(flags) ? this.start + offset : this.start + len;
            }
            if (typeId0 == 0) {
                int off = in.position();
                if (forUnmarshal) {
                    this.desc = ctx.descriptorForClass(BinaryUtils.doReadClass(in, ctx, ldr, typeId0), false);
                    this.typeId = this.desc.typeId();
                } else {
                    this.typeId = ctx.typeId(BinaryUtils.doReadClassName(in));
                }
                int clsNameLen = in.position() - off;
                this.dataStart = this.start + 24 + clsNameLen;
            } else {
                this.typeId = typeId0;
                this.dataStart = this.start + 24;
            }
            this.mapper = this.userType ? ctx.userTypeMapper(this.typeId) : BinaryContext.defaultMapper();
            this.schema = BinaryUtils.hasSchema(flags) ? this.getOrCreateSchema() : null;
        } else {
            this.dataStart = 0;
            this.typeId = 0;
            this.rawOff = 0;
            this.footerStart = 0;
            this.footerLen = 0;
            this.mapper = null;
            this.schemaId = 0;
            this.userType = false;
            this.fieldIdLen = 0;
            this.fieldOffLen = 0;
            this.schema = null;
        }
        this.streamPosition(this.start);
    }

    public BinaryInputStream in() {
        return this.in;
    }

    BinaryClassDescriptor descriptor() {
        if (this.desc == null) {
            this.desc = this.ctx.descriptorForTypeId(this.userType, this.typeId, this.ldr, true);
        }
        return this.desc;
    }

    public Object unmarshal(int offset) throws BinaryObjectException {
        this.streamPosition(offset);
        return this.in.position() >= 0 ? BinaryUtils.unmarshal(this.in, this.ctx, this.ldr, this) : null;
    }

    @Nullable
    Object unmarshalField(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) ? BinaryUtils.unmarshal(this.in, this.ctx, this.ldr, this) : null;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Nullable
    Object unmarshalField(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? BinaryUtils.unmarshal(this.in, this.ctx, this.ldr, this) : null;
    }

    @Nullable
    BinaryObject readBinaryObject(int fieldId) throws BinaryObjectException {
        if (this.findFieldById(fieldId)) {
            if (this.checkFlag((byte)27) == Flag.NULL) {
                return null;
            }
            return new BinaryObjectImpl(this.ctx, BinaryUtils.doReadByteArray(this.in), this.in.readInt());
        }
        return null;
    }

    @Nullable
    Class<?> readClass(int fieldId) throws BinaryObjectException {
        if (this.findFieldById(fieldId)) {
            if (this.checkFlag((byte)32) == Flag.NULL) {
                return null;
            }
            return BinaryUtils.doReadClass(this.in, this.ctx, this.ldr);
        }
        return null;
    }

    void setHandle(Object obj) {
        this.setHandle(obj, this.start);
    }

    @Override
    public void setHandle(Object obj, int pos) {
        this.handles().put(pos, obj);
    }

    @Override
    public Object getHandle(int pos) {
        return this.hnds != null ? this.hnds.get(pos) : null;
    }

    @Override
    public BinaryReaderHandles handles() {
        if (this.hnds == null) {
            this.hnds = new BinaryReaderHandles();
        }
        return this.hnds;
    }

    private <T> T readHandleField() {
        int handlePos = BinaryUtils.positionForHandle(this.in) - this.in.readInt();
        Object obj = this.getHandle(handlePos);
        if (obj == null) {
            int retPos = this.in.position();
            this.streamPosition(handlePos);
            obj = BinaryUtils.doReadObject(this.in, this.ctx, this.ldr, this);
            this.streamPosition(retPos);
        }
        return (T)obj;
    }

    private BinaryObjectException wrapFieldException(String fieldName, Exception e) {
        if (S.INCLUDE_SENSITIVE) {
            return new BinaryObjectException("Failed to read field: " + fieldName, e);
        }
        return new BinaryObjectException("Failed to read field.", e);
    }

    @Override
    public byte readByte(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) && this.checkFlagNoHandles((byte)1) == Flag.NORMAL ? this.in.readByte() : (byte)0;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    byte readByte(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) && this.checkFlagNoHandles((byte)1) == Flag.NORMAL ? this.in.readByte() : (byte)0;
    }

    @Nullable
    Byte readByteNullable(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) && this.checkFlagNoHandles((byte)1) == Flag.NORMAL ? Byte.valueOf(this.in.readByte()) : null;
    }

    @Override
    public byte readByte() throws BinaryObjectException {
        return this.in.readByte();
    }

    @Override
    @Nullable
    public byte[] readByteArray(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) ? this.readByteArray() : null;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Nullable
    byte[] readByteArray(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? this.readByteArray() : null;
    }

    @Override
    @Nullable
    public byte[] readByteArray() throws BinaryObjectException {
        switch (this.checkFlag((byte)12)) {
            case NORMAL: {
                return BinaryUtils.doReadByteArray(this.in);
            }
            case HANDLE: {
                return (byte[])this.readHandleField();
            }
        }
        return null;
    }

    @Override
    public boolean readBoolean(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) && this.checkFlagNoHandles((byte)8) == Flag.NORMAL && this.in.readBoolean();
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    boolean readBoolean(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) && this.checkFlagNoHandles((byte)8) == Flag.NORMAL && this.in.readBoolean();
    }

    @Nullable
    Boolean readBooleanNullable(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) && this.checkFlagNoHandles((byte)8) == Flag.NORMAL ? Boolean.valueOf(this.in.readBoolean()) : null;
    }

    @Override
    public boolean readBoolean() throws BinaryObjectException {
        return this.in.readBoolean();
    }

    @Override
    @Nullable
    public boolean[] readBooleanArray(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) ? this.readBooleanArray() : null;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Nullable
    boolean[] readBooleanArray(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? this.readBooleanArray() : null;
    }

    @Override
    @Nullable
    public boolean[] readBooleanArray() throws BinaryObjectException {
        switch (this.checkFlag((byte)19)) {
            case NORMAL: {
                return BinaryUtils.doReadBooleanArray(this.in);
            }
            case HANDLE: {
                return (boolean[])this.readHandleField();
            }
        }
        return null;
    }

    @Override
    public short readShort(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) && this.checkFlagNoHandles((byte)2) == Flag.NORMAL ? this.in.readShort() : (short)0;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    short readShort(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) && this.checkFlagNoHandles((byte)2) == Flag.NORMAL ? this.in.readShort() : (short)0;
    }

    @Nullable
    Short readShortNullable(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) && this.checkFlagNoHandles((byte)2) == Flag.NORMAL ? Short.valueOf(this.in.readShort()) : null;
    }

    @Override
    public short readShort() throws BinaryObjectException {
        return this.in.readShort();
    }

    @Override
    @Nullable
    public short[] readShortArray(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) ? this.readShortArray() : null;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Nullable
    short[] readShortArray(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? this.readShortArray() : null;
    }

    @Override
    @Nullable
    public short[] readShortArray() throws BinaryObjectException {
        switch (this.checkFlag((byte)13)) {
            case NORMAL: {
                return BinaryUtils.doReadShortArray(this.in);
            }
            case HANDLE: {
                return (short[])this.readHandleField();
            }
        }
        return null;
    }

    @Override
    public char readChar(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) && this.checkFlagNoHandles((byte)7) == Flag.NORMAL ? this.in.readChar() : (char)'\u0000';
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    char readChar(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) && this.checkFlagNoHandles((byte)7) == Flag.NORMAL ? this.in.readChar() : (char)'\u0000';
    }

    @Nullable
    Character readCharNullable(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) && this.checkFlagNoHandles((byte)7) == Flag.NORMAL ? Character.valueOf(this.in.readChar()) : null;
    }

    @Override
    public char readChar() throws BinaryObjectException {
        return this.in.readChar();
    }

    @Override
    @Nullable
    public char[] readCharArray(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) ? this.readCharArray() : null;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Nullable
    char[] readCharArray(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? this.readCharArray() : null;
    }

    @Override
    @Nullable
    public char[] readCharArray() throws BinaryObjectException {
        switch (this.checkFlag((byte)18)) {
            case NORMAL: {
                return BinaryUtils.doReadCharArray(this.in);
            }
            case HANDLE: {
                return (char[])this.readHandleField();
            }
        }
        return null;
    }

    @Override
    public int readInt(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) && this.checkFlagNoHandles((byte)3) == Flag.NORMAL ? this.in.readInt() : 0;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    int readInt(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) && this.checkFlagNoHandles((byte)3) == Flag.NORMAL ? this.in.readInt() : 0;
    }

    @Nullable
    Integer readIntNullable(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) && this.checkFlagNoHandles((byte)3) == Flag.NORMAL ? Integer.valueOf(this.in.readInt()) : null;
    }

    @Override
    public int readInt() throws BinaryObjectException {
        return this.in.readInt();
    }

    @Override
    @Nullable
    public int[] readIntArray(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) ? this.readIntArray() : null;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Nullable
    int[] readIntArray(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? this.readIntArray() : null;
    }

    @Override
    @Nullable
    public int[] readIntArray() throws BinaryObjectException {
        switch (this.checkFlag((byte)14)) {
            case NORMAL: {
                return BinaryUtils.doReadIntArray(this.in);
            }
            case HANDLE: {
                return (int[])this.readHandleField();
            }
        }
        return null;
    }

    @Override
    public long readLong(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) && this.checkFlagNoHandles((byte)4) == Flag.NORMAL ? this.in.readLong() : 0L;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    long readLong(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) && this.checkFlagNoHandles((byte)4) == Flag.NORMAL ? this.in.readLong() : 0L;
    }

    @Nullable
    Long readLongNullable(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) && this.checkFlagNoHandles((byte)4) == Flag.NORMAL ? Long.valueOf(this.in.readLong()) : null;
    }

    @Override
    public long readLong() throws BinaryObjectException {
        return this.in.readLong();
    }

    @Override
    @Nullable
    public long[] readLongArray(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) ? this.readLongArray() : null;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Nullable
    long[] readLongArray(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? this.readLongArray() : null;
    }

    @Override
    @Nullable
    public long[] readLongArray() throws BinaryObjectException {
        switch (this.checkFlag((byte)15)) {
            case NORMAL: {
                return BinaryUtils.doReadLongArray(this.in);
            }
            case HANDLE: {
                return (long[])this.readHandleField();
            }
        }
        return null;
    }

    @Override
    public float readFloat(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) && this.checkFlagNoHandles((byte)5) == Flag.NORMAL ? this.in.readFloat() : 0.0f;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    float readFloat(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) && this.checkFlagNoHandles((byte)5) == Flag.NORMAL ? this.in.readFloat() : 0.0f;
    }

    @Nullable
    Float readFloatNullable(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) && this.checkFlagNoHandles((byte)5) == Flag.NORMAL ? Float.valueOf(this.in.readFloat()) : null;
    }

    @Override
    public float readFloat() throws BinaryObjectException {
        return this.in.readFloat();
    }

    @Override
    @Nullable
    public float[] readFloatArray(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) ? this.readFloatArray() : null;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Nullable
    float[] readFloatArray(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? this.readFloatArray() : null;
    }

    @Override
    @Nullable
    public float[] readFloatArray() throws BinaryObjectException {
        switch (this.checkFlag((byte)16)) {
            case NORMAL: {
                return BinaryUtils.doReadFloatArray(this.in);
            }
            case HANDLE: {
                return (float[])this.readHandleField();
            }
        }
        return null;
    }

    @Override
    public double readDouble(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) && this.checkFlagNoHandles((byte)6) == Flag.NORMAL ? this.in.readDouble() : 0.0;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    double readDouble(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) && this.checkFlagNoHandles((byte)6) == Flag.NORMAL ? this.in.readDouble() : 0.0;
    }

    @Nullable
    Double readDoubleNullable(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) && this.checkFlagNoHandles((byte)6) == Flag.NORMAL ? Double.valueOf(this.in.readDouble()) : null;
    }

    @Override
    public double readDouble() throws BinaryObjectException {
        return this.in.readDouble();
    }

    @Override
    @Nullable
    public double[] readDoubleArray(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) ? this.readDoubleArray() : null;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Nullable
    double[] readDoubleArray(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? this.readDoubleArray() : null;
    }

    @Override
    @Nullable
    public double[] readDoubleArray() throws BinaryObjectException {
        switch (this.checkFlag((byte)17)) {
            case NORMAL: {
                return BinaryUtils.doReadDoubleArray(this.in);
            }
            case HANDLE: {
                return (double[])this.readHandleField();
            }
        }
        return null;
    }

    @Override
    @Nullable
    public BigDecimal readDecimal(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) ? this.readDecimal() : null;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Nullable
    BigDecimal readDecimal(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? this.readDecimal() : null;
    }

    @Override
    @Nullable
    public BigDecimal readDecimal() throws BinaryObjectException {
        return this.checkFlagNoHandles((byte)30) == Flag.NORMAL ? BinaryUtils.doReadDecimal(this.in) : null;
    }

    @Override
    @Nullable
    public BigDecimal[] readDecimalArray(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) ? this.readDecimalArray() : null;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Nullable
    BigDecimal[] readDecimalArray(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? this.readDecimalArray() : null;
    }

    @Override
    @Nullable
    public BigDecimal[] readDecimalArray() throws BinaryObjectException {
        switch (this.checkFlag((byte)31)) {
            case NORMAL: {
                return BinaryUtils.doReadDecimalArray(this.in);
            }
            case HANDLE: {
                return (BigDecimal[])this.readHandleField();
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String readString(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) ? this.readString() : null;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Nullable
    String readString(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? this.readString() : null;
    }

    @Override
    @Nullable
    public String readString() throws BinaryObjectException {
        return this.checkFlagNoHandles((byte)9) == Flag.NORMAL ? BinaryUtils.doReadString(this.in) : null;
    }

    @Override
    @Nullable
    public String[] readStringArray(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) ? this.readStringArray() : null;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Nullable
    String[] readStringArray(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? this.readStringArray() : null;
    }

    @Override
    @Nullable
    public String[] readStringArray() throws BinaryObjectException {
        switch (this.checkFlag((byte)20)) {
            case NORMAL: {
                return BinaryUtils.doReadStringArray(this.in);
            }
            case HANDLE: {
                return (String[])this.readHandleField();
            }
        }
        return null;
    }

    @Override
    @Nullable
    public UUID readUuid(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) ? this.readUuid() : null;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Nullable
    UUID readUuid(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? this.readUuid() : null;
    }

    @Override
    @Nullable
    public UUID readUuid() throws BinaryObjectException {
        return this.checkFlagNoHandles((byte)10) == Flag.NORMAL ? BinaryUtils.doReadUuid(this.in) : null;
    }

    @Override
    @Nullable
    public UUID[] readUuidArray(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) ? this.readUuidArray() : null;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Nullable
    UUID[] readUuidArray(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? this.readUuidArray() : null;
    }

    @Override
    @Nullable
    public UUID[] readUuidArray() throws BinaryObjectException {
        switch (this.checkFlag((byte)21)) {
            case NORMAL: {
                return BinaryUtils.doReadUuidArray(this.in);
            }
            case HANDLE: {
                return (UUID[])this.readHandleField();
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Date readDate(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) ? this.readDate() : null;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Nullable
    Date readDate(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? this.readDate() : null;
    }

    @Override
    @Nullable
    public Date readDate() throws BinaryObjectException {
        return this.checkFlagNoHandles((byte)11) == Flag.NORMAL ? BinaryUtils.doReadDate(this.in) : null;
    }

    @Override
    @Nullable
    public Date[] readDateArray(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) ? this.readDateArray() : null;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Nullable
    Date[] readDateArray(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? this.readDateArray() : null;
    }

    @Override
    @Nullable
    public Date[] readDateArray() throws BinaryObjectException {
        switch (this.checkFlag((byte)22)) {
            case NORMAL: {
                return BinaryUtils.doReadDateArray(this.in);
            }
            case HANDLE: {
                return (Date[])this.readHandleField();
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Timestamp readTimestamp(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) ? this.readTimestamp() : null;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Nullable
    Timestamp readTimestamp(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? this.readTimestamp() : null;
    }

    @Override
    @Nullable
    public Timestamp readTimestamp() throws BinaryObjectException {
        return this.checkFlagNoHandles((byte)33) == Flag.NORMAL ? BinaryUtils.doReadTimestamp(this.in) : null;
    }

    @Override
    @Nullable
    public Timestamp[] readTimestampArray(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) ? this.readTimestampArray() : null;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Nullable
    Timestamp[] readTimestampArray(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? this.readTimestampArray() : null;
    }

    @Override
    @Nullable
    public Timestamp[] readTimestampArray() throws BinaryObjectException {
        switch (this.checkFlag((byte)34)) {
            case NORMAL: {
                return BinaryUtils.doReadTimestampArray(this.in);
            }
            case HANDLE: {
                return (Timestamp[])this.readHandleField();
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Time readTime(String fieldName) throws BinaryObjectException {
        return this.findFieldByName(fieldName) ? this.readTime() : null;
    }

    @Override
    @Nullable
    public Time readTime() throws BinaryObjectException {
        return this.checkFlagNoHandles((byte)36) == Flag.NORMAL ? BinaryUtils.doReadTime(this.in) : null;
    }

    @Override
    @Nullable
    public Time[] readTimeArray(String fieldName) throws BinaryObjectException {
        return this.findFieldByName(fieldName) ? this.readTimeArray() : null;
    }

    @Nullable
    Time readTime(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? this.readTime() : null;
    }

    @Nullable
    Time[] readTimeArray(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? this.readTimeArray() : null;
    }

    @Override
    @Nullable
    public Time[] readTimeArray() throws BinaryObjectException {
        switch (this.checkFlag((byte)37)) {
            case NORMAL: {
                return BinaryUtils.doReadTimeArray(this.in);
            }
            case HANDLE: {
                return (Time[])this.readHandleField();
            }
        }
        return null;
    }

    @Override
    @Nullable
    public <T> T readObject(String fieldName) throws BinaryObjectException {
        try {
            return (T)(this.findFieldByName(fieldName) ? BinaryUtils.doReadObject(this.in, this.ctx, this.ldr, this) : null);
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Nullable
    Object readObject(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? BinaryUtils.doReadObject(this.in, this.ctx, this.ldr, this) : null;
    }

    @Override
    public Object readObject() throws BinaryObjectException {
        return BinaryUtils.doReadObject(this.in, this.ctx, this.ldr, this);
    }

    @Override
    @Nullable
    public Object readObjectDetached() throws BinaryObjectException {
        return BinaryUtils.unmarshal(this.in, this.ctx, this.ldr, this, true);
    }

    @Override
    @Nullable
    public Object[] readObjectArray(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) ? this.readObjectArray() : null;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Nullable
    Object[] readObjectArray(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? this.readObjectArray() : null;
    }

    @Override
    @Nullable
    public Object[] readObjectArray() throws BinaryObjectException {
        switch (this.checkFlag((byte)23)) {
            case NORMAL: {
                return BinaryUtils.doReadObjectArray(this.in, this.ctx, this.ldr, this, true);
            }
            case HANDLE: {
                return (Object[])this.readHandleField();
            }
        }
        return null;
    }

    @Override
    @Nullable
    public <T extends Enum<?>> T readEnum(String fieldName) throws BinaryObjectException {
        try {
            return (T)(this.findFieldByName(fieldName) ? this.readEnum0(null) : null);
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Nullable
    Enum<?> readEnum(int fieldId, @Nullable Class<?> cls) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? this.readEnum0(cls) : null;
    }

    @Override
    @Nullable
    public <T extends Enum<?>> T readEnum() throws BinaryObjectException {
        return (T)this.readEnum0(null);
    }

    private Enum<?> readEnum0(@Nullable Class<?> cls) throws BinaryObjectException {
        if (this.checkFlagNoHandles((byte)28) == Flag.NORMAL) {
            Class cls0 = BinaryUtils.doReadClass(this.in, this.ctx, this.ldr);
            if (cls == null) {
                cls = cls0;
            }
            return BinaryUtils.doReadEnum(this.in, cls);
        }
        return null;
    }

    @Override
    @Nullable
    public <T extends Enum<?>> T[] readEnumArray(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) ? (Enum[])this.readEnumArray0(null) : null;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Nullable
    BinaryEnumObjectImpl readBinaryEnum(int fieldId) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? BinaryUtils.doReadBinaryEnum(this.in, this.ctx) : null;
    }

    @Nullable
    Object[] readEnumArray(int fieldId, @Nullable Class<?> cls) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? this.readEnumArray0(cls) : null;
    }

    @Override
    @Nullable
    public <T extends Enum<?>> T[] readEnumArray() throws BinaryObjectException {
        return (Enum[])this.readEnumArray0(null);
    }

    private Object[] readEnumArray0(@Nullable Class<?> cls) throws BinaryObjectException {
        switch (this.checkFlag((byte)29)) {
            case NORMAL: {
                Class cls0 = BinaryUtils.doReadClass(this.in, this.ctx, this.ldr);
                if (cls == null) {
                    cls = cls0;
                }
                return BinaryUtils.doReadEnumArray(this.in, this.ctx, this.ldr, cls);
            }
            case HANDLE: {
                return (Object[])this.readHandleField();
            }
        }
        return null;
    }

    @Override
    @Nullable
    public <T> Collection<T> readCollection(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) ? this.readCollection0(null) : null;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Override
    @Nullable
    public <T> Collection<T> readCollection(String fieldName, BinaryCollectionFactory<T> factory) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) ? this.readCollection0(factory) : null;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Nullable
    <T> Collection<T> readCollection(int fieldId, @Nullable BinaryCollectionFactory<T> factory) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? this.readCollection0(factory) : null;
    }

    @Override
    @Nullable
    public <T> Collection<T> readCollection() throws BinaryObjectException {
        return this.readCollection0(null);
    }

    @Override
    @Nullable
    public <T> Collection<T> readCollection(BinaryCollectionFactory<T> factory) throws BinaryObjectException {
        return this.readCollection0(factory);
    }

    private Collection readCollection0(@Nullable BinaryCollectionFactory factory) throws BinaryObjectException {
        switch (this.checkFlag((byte)24)) {
            case NORMAL: {
                return BinaryUtils.doReadCollection(this.in, this.ctx, this.ldr, this, true, factory);
            }
            case HANDLE: {
                int handlePos = BinaryUtils.positionForHandle(this.in) - this.in.readInt();
                Object obj = this.getHandle(handlePos);
                if (obj == null) {
                    int retPos = this.in.position();
                    this.streamPosition(handlePos);
                    obj = this.readCollection0(factory);
                    this.streamPosition(retPos);
                }
                return (Collection)obj;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public <K, V> Map<K, V> readMap(String fieldName) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) ? this.readMap0(null) : null;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Override
    @Nullable
    public <K, V> Map<K, V> readMap(String fieldName, BinaryMapFactory<K, V> factory) throws BinaryObjectException {
        try {
            return this.findFieldByName(fieldName) ? this.readMap0(factory) : null;
        }
        catch (Exception ex) {
            throw this.wrapFieldException(fieldName, ex);
        }
    }

    @Nullable
    Map<?, ?> readMap(int fieldId, @Nullable BinaryMapFactory factory) throws BinaryObjectException {
        return this.findFieldById(fieldId) ? this.readMap0(factory) : null;
    }

    @Override
    @Nullable
    public <K, V> Map<K, V> readMap() throws BinaryObjectException {
        return this.readMap0(null);
    }

    @Override
    @Nullable
    public <K, V> Map<K, V> readMap(BinaryMapFactory<K, V> factory) throws BinaryObjectException {
        return this.readMap0(factory);
    }

    private Map readMap0(@Nullable BinaryMapFactory factory) throws BinaryObjectException {
        switch (this.checkFlag((byte)25)) {
            case NORMAL: {
                return BinaryUtils.doReadMap(this.in, this.ctx, this.ldr, this, true, factory);
            }
            case HANDLE: {
                int handlePos = BinaryUtils.positionForHandle(this.in) - this.in.readInt();
                Object obj = this.getHandle(handlePos);
                if (obj == null) {
                    int retPos = this.in.position();
                    this.streamPosition(handlePos);
                    obj = this.readMap0(factory);
                    this.streamPosition(retPos);
                }
                return (Map)obj;
            }
        }
        return null;
    }

    private Flag checkFlag(byte expFlag) {
        byte flag = this.in.readByte();
        if (flag == expFlag) {
            return Flag.NORMAL;
        }
        if (flag == 101) {
            return Flag.NULL;
        }
        if (flag == 102) {
            return Flag.HANDLE;
        }
        int pos = BinaryUtils.positionForHandle(this.in);
        throw new BinaryObjectException("Unexpected field type [pos=" + pos + ", expected=" + this.fieldFlagName(expFlag) + ", actual=" + this.fieldFlagName(flag) + ']');
    }

    private Flag checkFlagNoHandles(byte expFlag) {
        byte flag = this.in.readByte();
        if (flag == expFlag) {
            return Flag.NORMAL;
        }
        if (flag == 101) {
            return Flag.NULL;
        }
        int pos = BinaryUtils.positionForHandle(this.in);
        throw new BinaryObjectException("Unexpected field type [pos=" + pos + ", expected=" + this.fieldFlagName(expFlag) + ", actual=" + this.fieldFlagName(flag) + ']');
    }

    private String fieldFlagName(byte flag) {
        String typeName = BinaryUtils.fieldTypeName(flag);
        return typeName == null ? String.valueOf(flag) : typeName;
    }

    @Override
    public BinaryRawReader rawReader() {
        if (!this.raw) {
            this.streamPositionRandom(this.rawOff);
            this.raw = true;
            return this;
        }
        throw new BinaryObjectException("Method \"rawReader\" can be called only once.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Object deserialize() throws BinaryObjectException {
        String newName = this.ctx.configuration().getIgniteInstanceName();
        String oldName = IgniteUtils.setCurrentIgniteName(newName);
        try {
            Object object = this.deserialize0();
            return object;
        }
        finally {
            IgniteUtils.restoreOldIgniteName(oldName, newName);
        }
    }

    @Nullable
    private Object deserialize0() throws BinaryObjectException {
        Object obj;
        byte flag = this.in.readByte();
        switch (flag) {
            case 101: {
                obj = null;
                break;
            }
            case 102: {
                int handlePos = this.start - this.in.readInt();
                obj = this.getHandle(handlePos);
                if (obj != null) break;
                int retPos = this.in.position();
                this.streamPosition(handlePos);
                obj = BinaryUtils.doReadObject(this.in, this.ctx, this.ldr, this);
                this.streamPosition(retPos);
                break;
            }
            case 103: {
                if (this.desc == null) {
                    this.desc = this.ctx.descriptorForTypeId(this.userType, this.typeId, this.ldr, true);
                }
                this.streamPosition(this.dataStart);
                if (this.desc == null) {
                    throw new BinaryInvalidTypeException("Unknown type ID: " + this.typeId);
                }
                obj = this.desc.read(this);
                this.streamPosition(this.footerStart + this.footerLen);
                break;
            }
            case 1: {
                obj = this.in.readByte();
                break;
            }
            case 2: {
                obj = this.in.readShort();
                break;
            }
            case 3: {
                obj = this.in.readInt();
                break;
            }
            case 4: {
                obj = this.in.readLong();
                break;
            }
            case 5: {
                obj = Float.valueOf(this.in.readFloat());
                break;
            }
            case 6: {
                obj = this.in.readDouble();
                break;
            }
            case 7: {
                obj = Character.valueOf(this.in.readChar());
                break;
            }
            case 8: {
                obj = this.in.readBoolean();
                break;
            }
            case 30: {
                obj = BinaryUtils.doReadDecimal(this.in);
                break;
            }
            case 9: {
                obj = BinaryUtils.doReadString(this.in);
                break;
            }
            case 10: {
                obj = BinaryUtils.doReadUuid(this.in);
                break;
            }
            case 11: {
                obj = BinaryUtils.doReadDate(this.in);
                break;
            }
            case 33: {
                obj = BinaryUtils.doReadTimestamp(this.in);
                break;
            }
            case 36: {
                obj = BinaryUtils.doReadTime(this.in);
                break;
            }
            case 12: {
                obj = BinaryUtils.doReadByteArray(this.in);
                break;
            }
            case 13: {
                obj = BinaryUtils.doReadShortArray(this.in);
                break;
            }
            case 14: {
                obj = BinaryUtils.doReadIntArray(this.in);
                break;
            }
            case 15: {
                obj = BinaryUtils.doReadLongArray(this.in);
                break;
            }
            case 16: {
                obj = BinaryUtils.doReadFloatArray(this.in);
                break;
            }
            case 17: {
                obj = BinaryUtils.doReadDoubleArray(this.in);
                break;
            }
            case 18: {
                obj = BinaryUtils.doReadCharArray(this.in);
                break;
            }
            case 19: {
                obj = BinaryUtils.doReadBooleanArray(this.in);
                break;
            }
            case 31: {
                obj = BinaryUtils.doReadDecimalArray(this.in);
                break;
            }
            case 20: {
                obj = BinaryUtils.doReadStringArray(this.in);
                break;
            }
            case 21: {
                obj = BinaryUtils.doReadUuidArray(this.in);
                break;
            }
            case 22: {
                obj = BinaryUtils.doReadDateArray(this.in);
                break;
            }
            case 34: {
                obj = BinaryUtils.doReadTimestampArray(this.in);
                break;
            }
            case 37: {
                obj = BinaryUtils.doReadTimeArray(this.in);
                break;
            }
            case 23: {
                obj = BinaryUtils.doReadObjectArray(this.in, this.ctx, this.ldr, this, true);
                break;
            }
            case 24: {
                obj = BinaryUtils.doReadCollection(this.in, this.ctx, this.ldr, this, true, null);
                break;
            }
            case 25: {
                obj = BinaryUtils.doReadMap(this.in, this.ctx, this.ldr, this, true, null);
                break;
            }
            case 27: {
                obj = BinaryUtils.doReadBinaryObject(this.in, this.ctx, false);
                ((BinaryObjectImpl)obj).context(this.ctx);
                if (GridBinaryMarshaller.KEEP_BINARIES.get().booleanValue()) break;
                obj = ((BinaryObject)obj).deserialize();
                break;
            }
            case 28: {
                obj = BinaryUtils.doReadEnum(this.in, BinaryUtils.doReadClass(this.in, this.ctx, this.ldr));
                break;
            }
            case 29: {
                obj = BinaryUtils.doReadEnumArray(this.in, this.ctx, this.ldr, BinaryUtils.doReadClass(this.in, this.ctx, this.ldr));
                break;
            }
            case 38: {
                obj = BinaryUtils.doReadBinaryEnum(this.in, this.ctx);
                if (GridBinaryMarshaller.KEEP_BINARIES.get().booleanValue()) break;
                obj = ((BinaryObject)obj).deserialize();
                break;
            }
            case 32: {
                obj = BinaryUtils.doReadClass(this.in, this.ctx, this.ldr);
                break;
            }
            case 35: {
                obj = BinaryUtils.doReadProxy(this.in, this.ctx, this.ldr, this);
                break;
            }
            case -2: {
                obj = BinaryUtils.doReadOptimized(this.in, this.ctx, this.ldr);
                break;
            }
            default: {
                throw new BinaryObjectException("Invalid flag value: " + flag);
            }
        }
        return obj;
    }

    @Nullable
    Object readField(int fieldId) throws BinaryObjectException {
        if (!this.findFieldById(fieldId)) {
            return null;
        }
        return new BinaryReaderExImpl(this.ctx, this.in, this.ldr, this.hnds, true).deserialize();
    }

    private int fieldId(String name) {
        assert (name != null);
        return this.mapper.fieldId(this.typeId, name);
    }

    public BinarySchema getOrCreateSchema() {
        BinarySchema schema = this.ctx.schemaRegistry(this.typeId).schema(this.schemaId);
        if (schema == null) {
            if (this.fieldIdLen != 4) {
                BinaryTypeImpl type = (BinaryTypeImpl)this.ctx.metadata(this.typeId, this.schemaId);
                if (type == null || type.metadata() == null) {
                    throw new BinaryObjectException("Cannot find metadata for object with compact footer: " + this.typeId);
                }
                for (BinarySchema typeSchema : type.metadata().schemas()) {
                    if (this.schemaId != typeSchema.schemaId()) continue;
                    schema = typeSchema;
                    break;
                }
                if (schema == null) {
                    throw new BinaryObjectException("Cannot find schema for object with compact footer [typeId=" + this.typeId + ", schemaId=" + this.schemaId + ']');
                }
            } else {
                schema = this.createSchema();
            }
            assert (schema != null);
            this.ctx.schemaRegistry(this.typeId).addSchema(this.schemaId, schema);
        }
        return schema;
    }

    private BinarySchema createSchema() {
        int searchPos;
        assert (this.fieldIdLen == 4);
        BinarySchema.Builder builder = BinarySchema.Builder.newBuilder();
        int searchEnd = searchPos + this.footerLen;
        for (searchPos = this.footerStart; searchPos < searchEnd; searchPos += 4 + this.fieldOffLen) {
            int fieldId = this.in.readIntPositioned(searchPos);
            builder.addField(fieldId);
        }
        return builder.build();
    }

    public boolean findFieldByName(String name) {
        if (this.raw) {
            throw new BinaryObjectException("Failed to read named field because reader is in raw mode.");
        }
        assert (this.dataStart != this.start);
        if (this.footerLen == 0) {
            return false;
        }
        if (this.userType) {
            int order;
            if (this.matching) {
                int expOrder = this.matchingOrder++;
                BinarySchema.Confirmation confirm = this.schema.confirmOrder(expOrder, name);
                switch (confirm) {
                    case CONFIRMED: {
                        if (expOrder == 0) {
                            this.streamPosition(this.dataStart);
                        }
                        return true;
                    }
                    case REJECTED: {
                        this.matching = false;
                        order = this.schema.order(this.fieldId(name));
                        break;
                    }
                    default: {
                        int realId;
                        assert (confirm == BinarySchema.Confirmation.CLARIFY);
                        int id = this.fieldId(name);
                        if (id == (realId = this.schema.fieldId(expOrder))) {
                            this.schema.clarifyFieldName(expOrder, name);
                            if (expOrder == 0) {
                                this.streamPosition(this.dataStart);
                            }
                            return true;
                        }
                        this.matching = false;
                        order = this.schema.order(id);
                        break;
                    }
                }
            } else {
                order = this.schema.order(this.fieldId(name));
            }
            return this.trySetUserFieldPosition(order);
        }
        return this.trySetSystemFieldPosition(this.fieldId(name));
    }

    private boolean findFieldById(int id) {
        assert (!this.raw);
        assert (this.dataStart != this.start);
        if (this.footerLen == 0) {
            return false;
        }
        if (this.userType) {
            int order;
            if (this.matching) {
                int expOrder;
                int realId;
                if ((realId = this.schema.fieldId(expOrder = this.matchingOrder++)) == id) {
                    if (expOrder == 0) {
                        this.streamPosition(this.dataStart);
                    }
                    return true;
                }
                this.matching = false;
                order = this.schema.order(id);
            } else {
                order = this.schema.order(id);
            }
            return this.trySetUserFieldPosition(order);
        }
        return this.trySetSystemFieldPosition(id);
    }

    private boolean trySetUserFieldPosition(int order) {
        if (order != -1) {
            int offsetPos = this.footerStart + order * (this.fieldIdLen + this.fieldOffLen) + this.fieldIdLen;
            int pos = this.start + BinaryUtils.fieldOffsetRelative(this.in, offsetPos, this.fieldOffLen);
            this.streamPosition(pos);
            return true;
        }
        return false;
    }

    private boolean trySetSystemFieldPosition(int id) {
        assert (this.fieldIdLen == 4);
        int searchPos = this.footerStart;
        int searchTail = searchPos + this.footerLen;
        while (searchPos < searchTail) {
            int id0 = this.in.readIntPositioned(searchPos);
            if (id0 == id) {
                int pos = this.start + BinaryUtils.fieldOffsetRelative(this.in, searchPos + 4, this.fieldOffLen);
                this.streamPosition(pos);
                return true;
            }
            searchPos += 4 + this.fieldOffLen;
        }
        return false;
    }

    private void streamPosition(int pos) {
        this.in.position(pos);
    }

    private void streamPositionRandom(int pos) {
        this.streamPosition(pos);
        this.matching = false;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public String readLine() throws IOException {
        int b;
        SB sb = new SB();
        block4: while ((b = this.read()) >= 0) {
            char c = (char)b;
            switch (c) {
                case '\n': {
                    return sb.toString();
                }
                case '\r': {
                    b = this.read();
                    if (b < 0 || b == 10) {
                        return sb.toString();
                    }
                    sb.a((char)b);
                    continue block4;
                }
            }
            sb.a(c);
        }
        return sb.toString();
    }

    @Override
    @NotNull
    public String readUTF() throws IOException {
        return this.readString();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        int cnt = this.in.read(b, off, len);
        if (cnt < len) {
            throw new EOFException();
        }
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int toSkip = Math.min(this.in.remaining(), n);
        this.streamPositionRandom(this.in.position() + toSkip);
        return toSkip;
    }

    @Override
    public int read() throws IOException {
        return this.readByte();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.in.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.skipBytes((int)n);
    }

    @Override
    public int available() throws IOException {
        return this.in.remaining();
    }

    @Override
    public void close() throws IOException {
    }

    public BinaryContext context() {
        return this.ctx;
    }

    private static enum Flag {
        NORMAL,
        HANDLE,
        NULL;

    }
}

