/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.compute.ComputeJobSibling;
import org.apache.ignite.compute.ComputeTaskSessionAttributeListener;
import org.apache.ignite.compute.ComputeTaskSessionScope;
import org.apache.ignite.internal.ComputeTaskInternalFuture;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTaskSessionImpl;
import org.apache.ignite.internal.GridTaskSessionInternal;
import org.apache.ignite.internal.util.future.IgniteFinishedFutureImpl;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class GridJobSessionImpl
implements GridTaskSessionInternal {
    private final GridTaskSessionImpl ses;
    private final IgniteUuid jobId;
    private final GridKernalContext ctx;

    public GridJobSessionImpl(GridKernalContext ctx, GridTaskSessionImpl ses, IgniteUuid jobId) {
        assert (ctx != null);
        assert (ses != null);
        assert (jobId != null);
        assert (ses.getJobId() == null);
        this.ctx = ctx;
        this.ses = ses;
        this.jobId = jobId;
    }

    @Override
    public GridTaskSessionInternal session() {
        return this.ses;
    }

    @Override
    public IgniteUuid getJobId() {
        return this.jobId;
    }

    @Override
    public void onClosed() {
        this.ses.onClosed();
    }

    @Override
    public boolean isClosed() {
        return this.ses.isClosed();
    }

    @Override
    public boolean isTaskNode() {
        return this.ses.isTaskNode();
    }

    @Override
    public String getCheckpointSpi() {
        return this.ses.getCheckpointSpi();
    }

    @Override
    public String getTaskName() {
        return this.ses.getTaskName();
    }

    public String getTaskClassName() {
        return this.ses.getTaskClassName();
    }

    @Override
    public UUID getTaskNodeId() {
        return this.ses.getTaskNodeId();
    }

    @Override
    public long getStartTime() {
        return this.ses.getStartTime();
    }

    @Override
    public long getEndTime() {
        return this.ses.getEndTime();
    }

    @Override
    public IgniteUuid getId() {
        return this.ses.getId();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.ses.getClassLoader();
    }

    @Override
    public Collection<ComputeJobSibling> refreshJobSiblings() {
        if (!this.isTaskNode()) {
            try {
                Collection<ComputeJobSibling> sibs = this.ctx.job().requestJobSiblings(this);
                this.ses.setJobSiblings(sibs);
                return sibs;
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
        if (!this.ses.isFullSupport()) {
            ComputeTaskInternalFuture fut = this.ctx.task().taskFuture(this.ses.getId());
            return fut.getTaskSession().getJobSiblings();
        }
        return this.ses.getJobSiblings();
    }

    @Override
    public Collection<ComputeJobSibling> getJobSiblings() {
        Collection<ComputeJobSibling> sibs = this.ses.getJobSiblings();
        if (sibs == null) {
            if (this.isTaskNode()) {
                assert (!this.ses.isFullSupport());
                ComputeTaskInternalFuture fut = this.ctx.task().taskFuture(this.ses.getId());
                return fut.getTaskSession().getJobSiblings();
            }
            try {
                sibs = this.ctx.job().requestJobSiblings(this);
                this.ses.setJobSiblings(sibs);
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
        return sibs;
    }

    @Override
    public ComputeJobSibling getJobSibling(IgniteUuid jobId) {
        for (ComputeJobSibling sib : this.getJobSiblings()) {
            if (!sib.getJobId().equals(jobId)) continue;
            return sib;
        }
        return null;
    }

    @Override
    public void setAttribute(Object key, @Nullable Object val) {
        this.setAttributes(Collections.singletonMap(key, val));
    }

    @Override
    public <K, V> V getAttribute(K key) {
        return this.ses.getAttribute(key);
    }

    @Override
    public void setAttributes(Map<?, ?> attrs) {
        this.ses.setAttributes(attrs);
        if (!this.isTaskNode()) {
            try {
                this.ctx.job().setAttributes(this, attrs);
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }
    }

    @Override
    public Map<?, ?> getAttributes() {
        return this.ses.getAttributes();
    }

    @Override
    public void addAttributeListener(ComputeTaskSessionAttributeListener lsnr, boolean rewind) {
        this.ses.addAttributeListener(lsnr, rewind);
    }

    @Override
    public boolean removeAttributeListener(ComputeTaskSessionAttributeListener lsnr) {
        return this.ses.removeAttributeListener(lsnr);
    }

    @Override
    public <K, V> V waitForAttribute(K key, long timeout) throws InterruptedException {
        return this.ses.waitForAttribute(key, timeout);
    }

    @Override
    public <K, V> boolean waitForAttribute(K key, @Nullable V val, long timeout) throws InterruptedException {
        return this.ses.waitForAttribute((Object)key, (Object)val, timeout);
    }

    @Override
    public Map<?, ?> waitForAttributes(Collection<?> keys, long timeout) throws InterruptedException {
        return this.ses.waitForAttributes(keys, timeout);
    }

    @Override
    public boolean waitForAttributes(Map<?, ?> attrs, long timeout) throws InterruptedException {
        return this.ses.waitForAttributes(attrs, timeout);
    }

    @Override
    public void saveCheckpoint(String key, Object state) {
        this.saveCheckpoint(key, state, ComputeTaskSessionScope.SESSION_SCOPE, 0L);
    }

    @Override
    public void saveCheckpoint(String key, Object state, ComputeTaskSessionScope scope, long timeout) {
        this.saveCheckpoint(key, state, scope, timeout, true);
    }

    @Override
    public void saveCheckpoint(String key, Object state, ComputeTaskSessionScope scope, long timeout, boolean overwrite) {
        this.ses.saveCheckpoint0(this, key, state, scope, timeout, overwrite);
    }

    @Override
    public <T> T loadCheckpoint(String key) {
        return this.ses.loadCheckpoint0(this, key);
    }

    @Override
    public boolean removeCheckpoint(String key) {
        return this.ses.removeCheckpoint0(this, key);
    }

    @Override
    public Collection<UUID> getTopology() {
        return this.ses.getTopology();
    }

    @Override
    public boolean isFullSupport() {
        return this.ses.isFullSupport();
    }

    @Override
    public UUID subjectId() {
        return this.ses.subjectId();
    }

    @Override
    public IgniteFuture<?> mapFuture() {
        return new IgniteFinishedFutureImpl(null);
    }

    public String toString() {
        return S.toString(GridJobSessionImpl.class, this);
    }
}

