/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.example;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.backup.example.HFileArchiveTableMonitor;
import org.apache.hadoop.hbase.backup.example.ZKTableArchiveClient;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class TableHFileArchiveTracker
extends ZooKeeperListener {
    private static final Log LOG = LogFactory.getLog(TableHFileArchiveTracker.class);
    public static final String HFILE_ARCHIVE_ZNODE_PARENT = "hfilearchive";
    private HFileArchiveTableMonitor monitor;
    private String archiveHFileZNode;
    private boolean stopped = false;

    private TableHFileArchiveTracker(ZooKeeperWatcher watcher, HFileArchiveTableMonitor monitor) {
        super(watcher);
        watcher.registerListener((ZooKeeperListener)this);
        this.monitor = monitor;
        this.archiveHFileZNode = ZKTableArchiveClient.getArchiveZNode(watcher.getConfiguration(), watcher);
    }

    public void start() throws KeeperException {
        LOG.debug((Object)"Starting hfile archive tracker...");
        this.checkEnabledAndUpdate();
        LOG.debug((Object)"Finished starting hfile archive tracker!");
    }

    public void nodeCreated(String path) {
        if (!path.startsWith(this.archiveHFileZNode)) {
            return;
        }
        LOG.debug((Object)("Archive node: " + path + " created"));
        String table = path.substring(this.archiveHFileZNode.length());
        if (table.length() == 0) {
            this.checkEnabledAndUpdate();
            return;
        }
        try {
            this.addAndReWatchTable(path);
        }
        catch (KeeperException e) {
            LOG.warn((Object)("Couldn't read zookeeper data for table for path:" + path + ", not preserving a table."), (Throwable)e);
        }
    }

    public void nodeChildrenChanged(String path) {
        if (!path.startsWith(this.archiveHFileZNode)) {
            return;
        }
        LOG.debug((Object)("Archive node: " + path + " children changed."));
        try {
            this.updateWatchedTables();
        }
        catch (KeeperException e) {
            LOG.error((Object)"Failed to update tables to archive", (Throwable)e);
        }
    }

    private void addAndReWatchTable(String tableZnode) throws KeeperException {
        this.getMonitor().addTable(ZKUtil.getNodeName((String)tableZnode));
        if (!ZKUtil.watchAndCheckExists((ZooKeeperWatcher)this.watcher, (String)tableZnode)) {
            this.safeStopTrackingTable(tableZnode);
        }
    }

    private void safeStopTrackingTable(String tableZnode) throws KeeperException {
        this.getMonitor().removeTable(ZKUtil.getNodeName((String)tableZnode));
        if (ZKUtil.checkExists((ZooKeeperWatcher)this.watcher, (String)tableZnode) >= 0) {
            this.addAndReWatchTable(tableZnode);
        }
    }

    public void nodeDeleted(String path) {
        if (!path.startsWith(this.archiveHFileZNode)) {
            return;
        }
        LOG.debug((Object)("Archive node: " + path + " deleted"));
        String table = path.substring(this.archiveHFileZNode.length());
        if (table.length() == 0) {
            this.clearTables();
            this.checkEnabledAndUpdate();
            return;
        }
        this.getMonitor().removeTable(ZKUtil.getNodeName((String)path));
    }

    private void checkEnabledAndUpdate() {
        try {
            if (ZKUtil.watchAndCheckExists((ZooKeeperWatcher)this.watcher, (String)this.archiveHFileZNode)) {
                LOG.debug((Object)(this.archiveHFileZNode + " znode does exist, checking for tables to archive"));
                this.updateWatchedTables();
            } else {
                LOG.debug((Object)"Archiving not currently enabled, waiting");
            }
        }
        catch (KeeperException e) {
            LOG.warn((Object)"Failed to watch for archiving znode", (Throwable)e);
        }
    }

    private void updateWatchedTables() throws KeeperException {
        LOG.debug((Object)"Updating watches on tables to archive.");
        List tables = ZKUtil.listChildrenAndWatchThem((ZooKeeperWatcher)this.watcher, (String)this.archiveHFileZNode);
        LOG.debug((Object)("Starting archive for tables:" + tables));
        if (tables != null && tables.size() > 0) {
            this.getMonitor().setArchiveTables(tables);
        } else {
            LOG.debug((Object)"No tables to archive.");
            this.clearTables();
        }
    }

    private void clearTables() {
        this.getMonitor().clearArchive();
    }

    public boolean keepHFiles(String tableName) {
        return this.getMonitor().shouldArchiveTable(tableName);
    }

    public final HFileArchiveTableMonitor getMonitor() {
        return this.monitor;
    }

    public static TableHFileArchiveTracker create(Configuration conf) throws ZooKeeperConnectionException, IOException {
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(conf, "hfileArchiveCleaner", null);
        return TableHFileArchiveTracker.create(zkw, new HFileArchiveTableMonitor());
    }

    private static TableHFileArchiveTracker create(ZooKeeperWatcher zkw, HFileArchiveTableMonitor monitor) {
        return new TableHFileArchiveTracker(zkw, monitor);
    }

    public ZooKeeperWatcher getZooKeeperWatcher() {
        return this.watcher;
    }

    public void stop() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        this.watcher.close();
    }
}

