/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.util.compute_engine.util;

import java.net.URL;
import org.zillion.util.log.LogUtil;

public class Constant {
    private static String Config_path = null;

    public static String GetPath() {
        return Config_path;
    }

    public static void debug(String message) {
        LogUtil.debug((String)message);
    }

    public static void info(String message) {
        LogUtil.info((String)message);
    }

    public static void warn(String message) {
        LogUtil.warn((String)message);
    }

    public static void error(String message) {
        LogUtil.error((String)message);
    }

    public static void fatal(String message) {
        LogUtil.fatal((String)message);
    }

    public static void debug(Exception e) {
        LogUtil.debug((String)Constant.GetExceptionStackTrace(e));
    }

    public static void info(Exception e) {
        LogUtil.info((String)Constant.GetExceptionStackTrace(e));
    }

    public static void warn(Exception e) {
        LogUtil.warn((String)Constant.GetExceptionStackTrace(e));
    }

    public static void error(Exception e) {
        LogUtil.error((String)Constant.GetExceptionStackTrace(e));
    }

    public static void fatal(Exception e) {
        LogUtil.fatal((String)Constant.GetExceptionStackTrace(e));
    }

    private static String GetExceptionStackTrace(Exception e) {
        StringBuffer sb = new StringBuffer();
        sb.append("Exception: ");
        sb.append("\n");
        sb.append(e.getClass().getName() + ": " + e.getMessage());
        sb.append("\n");
        StackTraceElement[] elements = e.getStackTrace();
        for (int i = 0; i < elements.length; ++i) {
            StackTraceElement element = elements[i];
            sb.append("\t" + element.getClassName() + "." + element.getMethodName() + "(" + element.getFileName() + ":" + element.getLineNumber() + ")");
            sb.append("\n");
        }
        Throwable cause = e.getCause();
        if (cause != null) {
            sb.append("Caused by: " + cause.getClass().getName() + ": " + cause.getMessage());
            sb.append("\n");
            StackTraceElement[] elements2 = cause.getStackTrace();
            for (int i = 0; i < elements2.length; ++i) {
                StackTraceElement element = elements2[i];
                sb.append("\t" + element.getClassName() + "." + element.getMethodName() + "(" + element.getFileName() + ":" + element.getLineNumber() + ")");
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    static {
        URL urlDatabase = Constant.class.getResource("/log4j.properties");
        if (urlDatabase == null) {
            String filepathLog4j = System.getProperty("user.dir") + "/log4j.properties";
            Config_path = filepathLog4j.substring(0, filepathLog4j.length() - "/log4j.properties".length());
        } else {
            String filepathLog4j = urlDatabase.getPath();
            Config_path = filepathLog4j.substring(0, filepathLog4j.length() - "/log4j.properties".length());
        }
    }
}

