/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.util.compute_engine.fjd;

import com.alibaba.fastjson.JSONObject;
import com.sagacloud.extend.dao_data.ImplDao_fjd_0_loss_rate;
import com.sagacloud.extend.dao_data.ImplDao_fjd_0_rate;
import com.sagacloud.util.compute_engine.core.CoreComputeUtil;
import com.sagacloud.util.compute_engine.core.CoreInput;
import com.sagacloud.util.compute_engine.core.CoreOutput;
import com.sagacloud.util.compute_engine.core.Dao_dataManager;
import com.sagacloud.util.compute_engine.core.IDao_log;
import com.sagacloud.util.compute_engine.fjd.ImplDao_log;
import com.sagacloud.util.compute_engine.util.ConstantCE;
import com.sagacloud.util.compute_engine.util.DateUtil;
import com.sagacloud.util.compute_engine.util.DoubleTimeObject;
import com.sagacloud.util.compute_engine.util.DoubleTimeObject_loss_rate;
import com.sagacloud.util.compute_engine.util.DoubleTimeObject_rate;
import com.sagacloud.util.compute_engine.util.Parser_time_period;
import com.sagacloud.util.compute_engine.util.QueryUtil;
import com.sagacloud.util.compute_engine.util.TimeSpan;
import com.sagacloud.util.split.ArrangeUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Compute_fjd_0 {
    static int seek_period_count = 2;

    public static Map<String, List<TimeSpan>> Compute(String object_sign, String instance_name, List<CoreInput> inputList, List<CoreOutput> outputList, long compute_round, Map<String, List<TimeSpan>> inputTimeSpanMap, Map<String, List<TimeSpan>> outputdetailListMap, Date compute_time_from, Date compute_time_to, IDao_log dao_log) throws Exception {
        HashMap<String, CoreInput> inputMap = new HashMap<String, CoreInput>();
        for (CoreInput input : inputList) {
            inputMap.put(input.input_sign, input);
        }
        for (int i = 0; i < outputList.size(); ++i) {
            CoreOutput output = outputList.get(i);
            CoreInput input = (CoreInput)inputMap.get("ori_" + output.output_sign.substring("fjd_0_".length()));
            if (input.source_output_sign.startsWith("Acc_")) {
                Compute_fjd_0.Compute_Acc_Inst("Acc", object_sign, instance_name, inputMap, output, compute_round, inputTimeSpanMap, outputdetailListMap, dao_log);
            } else if (input.source_output_sign.startsWith("Inst_")) {
                Compute_fjd_0.Compute_Acc_Inst("Inst", object_sign, instance_name, inputMap, output, compute_round, inputTimeSpanMap, outputdetailListMap, dao_log);
            } else if (input.source_output_sign.startsWith("InAc_")) {
                Compute_fjd_0.Compute_InAc(object_sign, instance_name, inputMap, output, compute_round, inputTimeSpanMap, outputdetailListMap, dao_log);
            } else {
                Compute_fjd_0.Compute_EnumV(object_sign, instance_name, inputMap, output, compute_round, inputTimeSpanMap, outputdetailListMap, dao_log);
            }
            if (!ConstantCE.fjd_0_loss_rate_enable) continue;
            String dao_type = "fjd_0_loss_rate";
            ImplDao_fjd_0_loss_rate dao = (ImplDao_fjd_0_loss_rate)Dao_dataManager.Instance().Get(dao_type);
            String time_period = output.time_period;
            long interval = DateUtil.Instance().get_about(time_period);
            ArrayList<TimeSpan> timeSpanList = new ArrayList<TimeSpan>();
            if (inputTimeSpanMap.containsKey(input.input_sign)) {
                timeSpanList.addAll((Collection)inputTimeSpanMap.get(input.input_sign));
            }
            boolean exist = false;
            for (TimeSpan timeSpan : timeSpanList) {
                if (timeSpan.timefrom.getTime() > compute_time_from.getTime() - interval || timeSpan.timeto.getTime() < compute_time_to.getTime()) continue;
                exist = true;
                break;
            }
            if (!exist) {
                timeSpanList.add(new TimeSpan(compute_time_from, compute_time_to));
            }
            for (TimeSpan timeSpan : timeSpanList) {
                Date tmpNext;
                Date tmpDate;
                int tmp_index;
                ArrayList<DoubleTimeObject_loss_rate> loss_rateList;
                List<Object> dataList;
                Date day_ceiling = DateUtil.Instance().get_ceiling(timeSpan.timefrom, "1d");
                Date day_floor = DateUtil.Instance().get_floor(timeSpan.timeto, "1d");
                Date month_ceiling = DateUtil.Instance().get_ceiling(timeSpan.timefrom, "1m");
                Date month_floor = DateUtil.Instance().get_floor(timeSpan.timeto, "1m");
                Date day_from = DateUtil.Instance().GetDate_offset(day_ceiling, "1d", -1);
                Date day_to = DateUtil.Instance().GetDate_offset(day_floor, "1d", -1);
                Date month_from = DateUtil.Instance().GetDate_offset(month_ceiling, "1m", -1);
                Date month_to = DateUtil.Instance().GetDate_offset(month_floor, "1m", -1);
                if (day_to.getTime() >= day_from.getTime()) {
                    dataList = Dao_dataManager.Instance().Get(output.dao_type).GetDataListGteLte(output.dao_key, time_period, day_from, DateUtil.Instance().GetDate_offset(day_to, "1d", 1), false);
                    loss_rateList = new ArrayList<DoubleTimeObject_loss_rate>();
                    tmp_index = 0;
                    tmpDate = day_from;
                    while (tmpDate.compareTo(day_to) <= 0) {
                        tmpNext = DateUtil.Instance().GetDate_offset(tmpDate, "1d", 1);
                        int tmpCount = 0;
                        for (int index = tmp_index; index < dataList.size(); ++index) {
                            DoubleTimeObject data = (DoubleTimeObject)dataList.get(index);
                            tmp_index = index;
                            if (data.data_time.getTime() >= tmpNext.getTime()) break;
                            if (data.data_time.getTime() < tmpDate.getTime()) continue;
                            ++tmpCount;
                        }
                        DoubleTimeObject_loss_rate loss_rate = new DoubleTimeObject_loss_rate();
                        loss_rate.operate_time = tmpDate;
                        loss_rate.valid_count = tmpCount;
                        loss_rate.valid_minutes = (long)tmpCount * interval / 60000L;
                        loss_rate.valid_rate = 1.0 * (double)(loss_rate.valid_minutes * 60000L) / (double)(tmpNext.getTime() - tmpDate.getTime());
                        loss_rateList.add(loss_rate);
                        tmpDate = tmpNext;
                    }
                    dao.DeleteDataListGteLte(output.dao_key, "1d", day_from, day_to);
                    ConstantCE.SleepBetweenDeleteAndInsert();
                    dao.InsertDataListGteLte_rate(true, output.dao_key, "1d", loss_rateList);
                }
                if (month_to.getTime() < month_from.getTime()) continue;
                dataList = dao.GetDataListGteLte_rate(output.dao_key, "1d", month_from, DateUtil.Instance().GetDate_offset(month_to, "1m", 1), false);
                loss_rateList = new ArrayList();
                tmp_index = 0;
                tmpDate = month_from;
                while (tmpDate.compareTo(month_to) <= 0) {
                    tmpNext = DateUtil.Instance().GetDate_offset(tmpDate, "1m", 1);
                    long valid_count = 0L;
                    long valid_minutes = 0L;
                    for (int index = tmp_index; index < dataList.size(); ++index) {
                        DoubleTimeObject_loss_rate data = (DoubleTimeObject_loss_rate)dataList.get(index);
                        tmp_index = index;
                        if (data.operate_time.getTime() >= tmpNext.getTime()) break;
                        if (data.operate_time.getTime() < tmpDate.getTime()) continue;
                        valid_count += data.valid_count;
                        valid_minutes += data.valid_minutes;
                    }
                    DoubleTimeObject_loss_rate loss_rate = new DoubleTimeObject_loss_rate();
                    loss_rate.operate_time = tmpDate;
                    loss_rate.valid_count = valid_count;
                    loss_rate.valid_minutes = valid_minutes;
                    loss_rate.valid_rate = 1.0 * (double)(loss_rate.valid_minutes * 60000L) / (double)(tmpNext.getTime() - tmpDate.getTime());
                    loss_rateList.add(loss_rate);
                    tmpDate = tmpNext;
                }
                dao.DeleteDataListGteLte(output.dao_key, "1m", month_from, month_to);
                ConstantCE.SleepBetweenDeleteAndInsert();
                dao.InsertDataListGteLte_rate(true, output.dao_key, "1m", loss_rateList);
            }
        }
        return inputTimeSpanMap;
    }

    private static void Compute_Acc_Inst(String data_type, String object_sign, String instance_name, Map<String, CoreInput> inputMap, CoreOutput output, long compute_round, Map<String, List<TimeSpan>> inputTimeSpanMap, Map<String, List<TimeSpan>> outputdetailListMap, IDao_log dao_log) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        if (outputdetailListMap.containsKey(output.output_sign)) {
            return;
        }
        int index_ = output.output_sign.lastIndexOf("_");
        String meter = output.output_sign.substring("fjd_0_".length(), index_);
        long funcid = Long.parseLong(output.output_sign.substring(index_ + 1));
        CoreInput input = inputMap.get("ori_" + output.output_sign.substring("fjd_0_".length()));
        String time_period = output.time_period;
        long interval = DateUtil.Instance().get_about(time_period);
        List<TimeSpan> timeSpanList = inputTimeSpanMap.get(input.input_sign);
        if (!inputTimeSpanMap.containsKey(input.input_sign)) {
            return;
        }
        ArrayList<TimeSpan> timeSpanListOut = new ArrayList<TimeSpan>();
        ArrayList<DoubleTimeObject> outputDataList_all = new ArrayList<DoubleTimeObject>();
        DoubleTimeObject pointLastData = null;
        for (TimeSpan timeSpan : timeSpanList) {
            Date timefrom = DateUtil.Instance().GetDate_offset(timeSpan.timefrom, time_period, -1);
            Date timeto = timeSpan.timeto;
            List<DoubleTimeObject> inputDataList = Dao_dataManager.Instance().Get(input.dao_type).GetDataListGteLte(input.dao_key, null, DateUtil.Instance().GetDate_offset(timefrom, time_period, -seek_period_count), DateUtil.Instance().GetDate_offset(timeto, time_period, seek_period_count), true);
            long millisecondsInterval = DateUtil.Instance().get_about(time_period);
            ArrayList<DoubleTimeObject> badDataList = new ArrayList<DoubleTimeObject>();
            List<DoubleTimeObject> outputDataList = ArrangeUtil.Instance().ComputeInterval(funcid, data_type, inputDataList, badDataList, timefrom, timeto, millisecondsInterval);
            if (outputDataList.size() > 0) {
                pointLastData = outputDataList.get(outputDataList.size() - 1);
            }
            if (badDataList.size() > 0) {
                Dao_dataManager.Instance().Get("ori_flag").InsertDataListGteLte(output.dao_key, time_period, badDataList);
            }
            List<DoubleTimeObject> existDataList = Dao_dataManager.Instance().Get(output.dao_type).GetDataListGteLte(output.dao_key, time_period, timefrom, timefrom, true);
            DoubleTimeObject last_new = null;
            DoubleTimeObject last_old = null;
            if (outputDataList.size() > 0 && outputDataList.get((int)0).data_time.getTime() == timefrom.getTime()) {
                last_new = outputDataList.get(0);
            }
            if (existDataList.size() == 1) {
                last_old = existDataList.get(0);
            }
            TimeSpan timeSpanOut = last_new == null && last_old == null || last_new != null && last_old != null && Math.abs(last_new.data_value - last_old.data_value) < 0.001 ? new TimeSpan(timeSpan.timefrom, timeto) : new TimeSpan(timefrom, timeto);
            outputDataList_all.addAll(outputDataList);
            timeSpanListOut.add(timeSpanOut);
            Dao_dataManager.Instance().Get(output.dao_type).DeleteDataListGteLte(output.dao_key, time_period, timeSpanOut.timefrom, timeSpanOut.timeto);
            ConstantCE.SleepBetweenDeleteAndInsert();
            Dao_dataManager.Instance().Get(output.dao_type).InsertDataListGteLte(output.dao_key, time_period, outputDataList);
        }
        if (output.data_class.equals("near")) {
            CoreComputeUtil.Stat_near(output.dao_type, output.dao_key, timeSpanListOut, time_period, outputDataList_all);
        }
        for (TimeSpan timeSpan : timeSpanListOut) {
            ImplDao_log ImplDao_log2 = (ImplDao_log)dao_log;
            JSONObject InsertObject = new JSONObject();
            InsertObject.put("building", (Object)object_sign);
            InsertObject.put("compute_round", (Object)compute_round);
            InsertObject.put("meter", (Object)meter);
            InsertObject.put("funcid", (Object)funcid);
            InsertObject.put("valid_time_from", (Object)sdf.format(timeSpan.timefrom));
            InsertObject.put("valid_time_to", (Object)sdf.format(timeSpan.timeto));
            InsertObject.put("operate_time_to", (Object)sdf.format(new Date()));
            QueryUtil.insert(ImplDao_log2.agent, ImplDao_log2.database_name, "fjd_0_computedetail", InsertObject);
            if (pointLastData == null) continue;
            JSONObject CriteriaInner = new JSONObject();
            CriteriaInner.put("building", (Object)object_sign);
            CriteriaInner.put("meter", (Object)meter);
            CriteriaInner.put("funcid", (Object)funcid);
            JSONObject Set2 = new JSONObject();
            Set2.put("next_data_time", (Object)sdf.format(new Date(pointLastData.data_time.getTime() + interval)));
            QueryUtil.update(ImplDao_log2.agent, ImplDao_log2.database_name, "fjd_0_metercomputetime", CriteriaInner, Set2);
        }
    }

    private static void Compute_InAc(String object_sign, String instance_name, Map<String, CoreInput> inputMap, CoreOutput output, long compute_round, Map<String, List<TimeSpan>> inputTimeSpanMap, Map<String, List<TimeSpan>> outputdetailListMap, IDao_log dao_log) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        if (outputdetailListMap.containsKey(output.output_sign)) {
            return;
        }
        int index_ = output.output_sign.lastIndexOf("_");
        String meter = output.output_sign.substring("fjd_0_".length(), index_);
        long funcid = Long.parseLong(output.output_sign.substring(index_ + 1));
        CoreInput input = inputMap.get("ori_" + output.output_sign.substring("fjd_0_".length()));
        String time_period = output.time_period;
        long interval = DateUtil.Instance().get_about(time_period);
        List<TimeSpan> timeSpanList = inputTimeSpanMap.get(input.input_sign);
        if (!inputTimeSpanMap.containsKey(input.input_sign)) {
            return;
        }
        ArrayList<List<DoubleTimeObject>> inputDataListList = new ArrayList<List<DoubleTimeObject>>();
        for (TimeSpan timeSpan : timeSpanList) {
            List<DoubleTimeObject> inputDataList = Dao_dataManager.Instance().Get(input.dao_type).GetDataListGteLte(input.dao_key, null, DateUtil.Instance().GetDate_offset(timeSpan.timefrom, time_period, -2), DateUtil.Instance().GetDate_offset(timeSpan.timeto, time_period, 1), true);
            inputDataListList.add(inputDataList);
        }
        ArrayList<DoubleTimeObject> outputDataList_all = new ArrayList<DoubleTimeObject>();
        for (int i = 0; i < timeSpanList.size(); ++i) {
            TimeSpan timeSpan = timeSpanList.get(i);
            List inputDataList = (List)inputDataListList.get(i);
            int index_tmp = 0;
            ArrayList<DoubleTimeObject> outputDataList = new ArrayList<DoubleTimeObject>();
            Date tmpDate = timeSpan.timefrom;
            while (tmpDate.getTime() <= timeSpan.timeto.getTime()) {
                Date tmpDateNext = DateUtil.Instance().GetDate_offset(tmpDate, time_period, 1);
                int index_before = -1;
                int index_data = index_tmp;
                while (index_data < inputDataList.size()) {
                    DoubleTimeObject data = (DoubleTimeObject)inputDataList.get(index_data);
                    if (data.data_time.getTime() <= tmpDate.getTime()) {
                        index_before = index_data;
                    } else if (data.data_time.getTime() >= tmpDateNext.getTime()) break;
                    index_tmp = index_data++;
                }
                if (index_before != -1) {
                    DoubleTimeObject data_before = (DoubleTimeObject)inputDataList.get(index_before);
                    if (tmpDate.getTime() - data_before.data_time.getTime() < interval) {
                        DoubleTimeObject outputData = new DoubleTimeObject();
                        outputData.data_time = tmpDate;
                        outputData.data_value = data_before.data_value;
                        outputDataList.add(outputData);
                    }
                }
                tmpDate = tmpDateNext;
            }
            outputDataList_all.addAll(outputDataList);
            Dao_dataManager.Instance().Get(output.dao_type).DeleteDataListGteLte(output.dao_key, time_period, timeSpan.timefrom, timeSpan.timeto);
            ConstantCE.SleepBetweenDeleteAndInsert();
            Dao_dataManager.Instance().Get(output.dao_type).InsertDataListGteLte(output.dao_key, time_period, outputDataList);
        }
        for (TimeSpan timeSpan : timeSpanList) {
            ImplDao_log ImplDao_log2 = (ImplDao_log)dao_log;
            JSONObject InsertObject = new JSONObject();
            InsertObject.put("building", (Object)object_sign);
            InsertObject.put("compute_round", (Object)compute_round);
            InsertObject.put("meter", (Object)meter);
            InsertObject.put("funcid", (Object)funcid);
            InsertObject.put("valid_time_from", (Object)sdf.format(timeSpan.timefrom));
            InsertObject.put("valid_time_to", (Object)sdf.format(timeSpan.timeto));
            InsertObject.put("operate_time_to", (Object)sdf.format(new Date()));
            QueryUtil.insert(ImplDao_log2.agent, ImplDao_log2.database_name, "fjd_0_computedetail", InsertObject);
            TimeSpan timeSpan_last = timeSpanList.get(timeSpanList.size() - 1);
            JSONObject CriteriaInner = new JSONObject();
            CriteriaInner.put("building", (Object)object_sign);
            CriteriaInner.put("meter", (Object)meter);
            CriteriaInner.put("funcid", (Object)funcid);
            JSONObject Set2 = new JSONObject();
            Set2.put("next_data_time", (Object)sdf.format(new Date(timeSpan_last.timeto.getTime() + interval)));
            QueryUtil.update(ImplDao_log2.agent, ImplDao_log2.database_name, "fjd_0_metercomputetime", CriteriaInner, Set2);
        }
    }

    private static void Compute_EnumV(String object_sign, String instance_name, Map<String, CoreInput> inputMap, CoreOutput output, long compute_round, Map<String, List<TimeSpan>> inputTimeSpanMap, Map<String, List<TimeSpan>> outputdetailListMap, IDao_log dao_log) throws Exception {
        List inputDataList;
        TimeSpan timeSpan3;
        int i;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        if (outputdetailListMap.containsKey(output.output_sign)) {
            return;
        }
        int index_ = output.output_sign.lastIndexOf("_");
        String meter = output.output_sign.substring("fjd_0_".length(), index_);
        long funcid = Long.parseLong(output.output_sign.substring(index_ + 1));
        CoreInput input = inputMap.get("ori_" + output.output_sign.substring("fjd_0_".length()));
        String time_period = output.time_period;
        long interval = DateUtil.Instance().get_about(time_period);
        List<TimeSpan> timeSpanList = inputTimeSpanMap.get(input.input_sign);
        if (!inputTimeSpanMap.containsKey(input.input_sign)) {
            return;
        }
        ArrayList<List<DoubleTimeObject>> inputDataListList = new ArrayList<List<DoubleTimeObject>>();
        for (TimeSpan timeSpan2 : timeSpanList) {
            List<DoubleTimeObject> inputDataList2 = Dao_dataManager.Instance().Get(input.dao_type).GetDataListGteLte(input.dao_key, null, DateUtil.Instance().GetDate_offset(timeSpan2.timefrom, time_period, -2), DateUtil.Instance().GetDate_offset(timeSpan2.timeto, time_period, 1), true);
            inputDataListList.add(inputDataList2);
        }
        ArrayList<DoubleTimeObject> outputDataList_all = new ArrayList<DoubleTimeObject>();
        for (i = 0; i < timeSpanList.size(); ++i) {
            timeSpan3 = timeSpanList.get(i);
            inputDataList = (List)inputDataListList.get(i);
            int index_tmp = 0;
            ArrayList<DoubleTimeObject> outputDataList = new ArrayList<DoubleTimeObject>();
            Date tmpDate = timeSpan3.timefrom;
            while (tmpDate.getTime() <= timeSpan3.timeto.getTime()) {
                Date tmpDateNext = DateUtil.Instance().GetDate_offset(tmpDate, time_period, 1);
                int index_before = -1;
                int index_data = index_tmp;
                while (index_data < inputDataList.size()) {
                    DoubleTimeObject data = (DoubleTimeObject)inputDataList.get(index_data);
                    if (data.data_time.getTime() <= tmpDate.getTime()) {
                        index_before = index_data;
                    } else if (data.data_time.getTime() >= tmpDateNext.getTime()) break;
                    index_tmp = index_data++;
                }
                if (index_before != -1) {
                    DoubleTimeObject data_before = (DoubleTimeObject)inputDataList.get(index_before);
                    DoubleTimeObject outputData = new DoubleTimeObject();
                    outputData.data_time = tmpDate;
                    outputData.data_value = data_before.data_value;
                    outputDataList.add(outputData);
                }
                tmpDate = tmpDateNext;
            }
            outputDataList_all.addAll(outputDataList);
            Dao_dataManager.Instance().Get(output.dao_type).DeleteDataListGteLte(output.dao_key, time_period, timeSpan3.timefrom, timeSpan3.timeto);
            ConstantCE.SleepBetweenDeleteAndInsert();
            Dao_dataManager.Instance().Get(output.dao_type).InsertDataListGteLte(output.dao_key, time_period, outputDataList);
        }
        if (output.data_class.equals("near")) {
            CoreComputeUtil.Stat_near(output.dao_type, output.dao_key, timeSpanList, time_period, outputDataList_all);
        }
        for (i = 0; i < timeSpanList.size(); ++i) {
            timeSpan3 = timeSpanList.get(i);
            inputDataList = (List)inputDataListList.get(i);
            Date timeSpan_timefrom_ = DateUtil.Instance().GetDate_offset(timeSpan3.timefrom, time_period, -1);
            Date timeSpan_timeto_ = DateUtil.Instance().GetDate_offset(timeSpan3.timeto, time_period, -1);
            int index_tmp = 0;
            ArrayList<DoubleTimeObject_rate> outputDataList = new ArrayList<DoubleTimeObject_rate>();
            Date tmpDate = timeSpan_timefrom_;
            while (tmpDate.getTime() <= timeSpan_timeto_.getTime()) {
                DoubleTimeObject data;
                Date tmpDateNext = DateUtil.Instance().GetDate_offset(tmpDate, time_period, 1);
                int index_before = -1;
                int index_in = -1;
                int index_data = index_tmp;
                while (index_data < inputDataList.size()) {
                    data = (DoubleTimeObject)inputDataList.get(index_data);
                    if (data.data_time.getTime() <= tmpDate.getTime()) {
                        index_before = index_data;
                    } else {
                        if (data.data_time.getTime() >= tmpDateNext.getTime()) break;
                        index_in = index_data;
                    }
                    index_tmp = index_data++;
                }
                if (index_before != -1 || index_in != -1) {
                    if (index_before != -1 && index_in == -1) {
                        DoubleTimeObject data_before = (DoubleTimeObject)inputDataList.get(index_before);
                        DoubleTimeObject_rate rate = new DoubleTimeObject_rate();
                        rate.data_time = tmpDate;
                        rate.data_flag = 0L;
                        rate.status_value = data_before.data_value;
                        rate.status_ratio = 1.0;
                        outputDataList.add(rate);
                    } else {
                        HashMap<Double, Long> value2millisecond = new HashMap<Double, Long>();
                        if (index_before != -1) {
                            data = (DoubleTimeObject)inputDataList.get(index_before);
                            if (index_in == -1) {
                                value2millisecond.put(data.data_value, interval);
                            } else {
                                DoubleTimeObject data_in_first = (DoubleTimeObject)inputDataList.get(index_before + 1);
                                value2millisecond.put(data.data_value, data_in_first.data_time.getTime() - tmpDate.getTime());
                            }
                        }
                        for (int index_data2 = index_before + 1; index_data2 <= index_in; ++index_data2) {
                            DoubleTimeObject data2 = (DoubleTimeObject)inputDataList.get(index_data2);
                            Date endDate = index_data2 == index_in ? tmpDateNext : ((DoubleTimeObject)inputDataList.get((int)(index_data2 + 1))).data_time;
                            Long mill = endDate.getTime() - data2.data_time.getTime();
                            if (value2millisecond.containsKey(data2.data_value)) {
                                Long mill_exist = (Long)value2millisecond.remove(data2.data_value);
                                mill = mill + mill_exist;
                            }
                            value2millisecond.put(data2.data_value, mill);
                        }
                        for (Double key : value2millisecond.keySet()) {
                            Long mill = (Long)value2millisecond.get(key);
                            DoubleTimeObject_rate rate = new DoubleTimeObject_rate();
                            rate.data_time = tmpDate;
                            rate.data_flag = 0L;
                            rate.status_value = key;
                            rate.status_ratio = 1.0 * (double)mill.longValue() / (double)interval;
                            outputDataList.add(rate);
                        }
                    }
                }
                tmpDate = tmpDateNext;
            }
            String dao_type = "fjd_0_rate";
            ImplDao_fjd_0_rate dao = (ImplDao_fjd_0_rate)Dao_dataManager.Instance().Get(dao_type);
            dao.DeleteDataListGteLte_rate(output.dao_key, time_period, timeSpan3.timefrom, timeSpan3.timeto);
            ConstantCE.SleepBetweenDeleteAndInsert();
            dao.InsertDataListGteLte_rate(output.dao_key, time_period, outputDataList);
        }
        String dao_type = "fjd_0_rate";
        ImplDao_fjd_0_rate dao = (ImplDao_fjd_0_rate)Dao_dataManager.Instance().Get(dao_type);
        Compute_fjd_0.Stat_rate(dao, output.dao_key, timeSpanList, time_period);
        for (TimeSpan timeSpan3 : timeSpanList) {
            ImplDao_log ImplDao_log2 = (ImplDao_log)dao_log;
            JSONObject InsertObject = new JSONObject();
            InsertObject.put("building", (Object)object_sign);
            InsertObject.put("compute_round", (Object)compute_round);
            InsertObject.put("meter", (Object)meter);
            InsertObject.put("funcid", (Object)funcid);
            InsertObject.put("valid_time_from", (Object)sdf.format(timeSpan3.timefrom));
            InsertObject.put("valid_time_to", (Object)sdf.format(timeSpan3.timeto));
            InsertObject.put("operate_time_to", (Object)sdf.format(new Date()));
            QueryUtil.insert(ImplDao_log2.agent, ImplDao_log2.database_name, "fjd_0_computedetail", InsertObject);
            TimeSpan timeSpan_last = timeSpanList.get(timeSpanList.size() - 1);
            JSONObject CriteriaInner = new JSONObject();
            CriteriaInner.put("building", (Object)object_sign);
            CriteriaInner.put("meter", (Object)meter);
            CriteriaInner.put("funcid", (Object)funcid);
            JSONObject Set2 = new JSONObject();
            Set2.put("next_data_time", (Object)sdf.format(new Date(timeSpan_last.timeto.getTime() + interval)));
            QueryUtil.update(ImplDao_log2.agent, ImplDao_log2.database_name, "fjd_0_metercomputetime", CriteriaInner, Set2);
        }
    }

    private static void Stat_rate(ImplDao_fjd_0_rate dao, JSONObject dao_key, List<TimeSpan> timeSpanList, String time_period) throws Exception {
        if (timeSpanList.size() == 0) {
            return;
        }
        long interval = DateUtil.Instance().get_about(time_period);
        List<String> biggerList = Parser_time_period.getBigger(ConstantCE.Stat_time_period_fjd_rate, time_period);
        for (int i = biggerList.size() - 1; i >= 0; --i) {
            String bigger = biggerList.get(i);
            if (!bigger.endsWith("min")) continue;
            biggerList.remove(i);
        }
        ArrayList<ArrayList<TimeSpan>> biggerTimeSpanList = new ArrayList<ArrayList<TimeSpan>>();
        for (String bigger : biggerList) {
            ArrayList<TimeSpan> bts = new ArrayList<TimeSpan>();
            DateUtil.Instance().ConvertAndMergeTo(timeSpanList, bigger, "consumption", bts);
            biggerTimeSpanList.add(bts);
        }
        List biggestTimeSpanList = (List)biggerTimeSpanList.get(biggerTimeSpanList.size() - 1);
        String biggest = biggerList.get(biggerList.size() - 1);
        Date stat_from = ((TimeSpan)biggestTimeSpanList.get((int)0)).timefrom;
        Date stat_to = DateUtil.Instance().GetDate_offset(((TimeSpan)biggestTimeSpanList.get((int)(biggestTimeSpanList.size() - 1))).timeto, biggest, 1);
        List<DoubleTimeObject_rate> dataList = dao.GetDataListGteLte_rate(dao_key, time_period, stat_from, stat_to, false);
        for (int index = 0; index < biggerList.size(); ++index) {
            String bigger = biggerList.get(index);
            long interval_bigger = DateUtil.Instance().get_about(bigger);
            List bts = (List)biggerTimeSpanList.get(index);
            for (TimeSpan biggerTimeSpan : bts) {
                ArrayList<DoubleTimeObject_rate> outputDataList = new ArrayList<DoubleTimeObject_rate>();
                int tmp_data_index = 0;
                Date tmpDate = biggerTimeSpan.timefrom;
                while (tmpDate.getTime() <= biggerTimeSpan.timeto.getTime()) {
                    Date tmpDateNext = DateUtil.Instance().GetDate_offset(tmpDate, bigger, 1);
                    HashMap valueListMap = new HashMap();
                    for (int index_data = tmp_data_index; index_data < dataList.size(); ++index_data) {
                        tmp_data_index = index_data;
                        DoubleTimeObject_rate data = dataList.get(index_data);
                        if (data.data_time.getTime() < tmpDate.getTime()) continue;
                        if (data.data_time.getTime() >= tmpDateNext.getTime()) break;
                        if (!valueListMap.containsKey(data.status_value)) {
                            valueListMap.put(data.status_value, new ArrayList());
                        }
                        ((List)valueListMap.get(data.status_value)).add(data);
                    }
                    for (Double key : valueListMap.keySet()) {
                        List dataListInner = (List)valueListMap.get(key);
                        double millseconds_total = 0.0;
                        for (DoubleTimeObject_rate rate : dataListInner) {
                            millseconds_total += rate.status_ratio * (double)interval;
                        }
                        DoubleTimeObject_rate rate = new DoubleTimeObject_rate();
                        rate.data_time = tmpDate;
                        rate.data_flag = 0L;
                        rate.status_value = key;
                        rate.status_ratio = 1.0 * millseconds_total / (double)interval_bigger;
                        outputDataList.add(rate);
                    }
                    tmpDate = tmpDateNext;
                }
                dao.DeleteDataListGteLte_rate(dao_key, bigger, biggerTimeSpan.timefrom, biggerTimeSpan.timeto);
                ConstantCE.SleepBetweenDeleteAndInsert();
                dao.InsertDataListGteLte_rate(dao_key, bigger, outputDataList);
            }
        }
    }
}

