/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.io.IOException;
import org.apache.ignite.internal.util.GridConcurrentHashSet;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.LockObtainFailedException;

public class GridLuceneLockFactory
extends LockFactory {
    private final GridConcurrentHashSet<String> locks = new GridConcurrentHashSet();

    public Lock obtainLock(Directory dir, String lockName) throws IOException {
        if (this.locks.add((Object)lockName)) {
            return new LockImpl(lockName);
        }
        throw new LockObtainFailedException("lock instance already obtained: (dir=" + dir + ", lockName=" + lockName + ")");
    }

    private class LockImpl
    extends Lock {
        private final String lockName;
        private volatile boolean closed;

        private LockImpl(String lockName) {
            this.lockName = lockName;
        }

        public void ensureValid() throws IOException {
            if (this.closed) {
                throw new AlreadyClosedException("Lock instance already released: " + (Object)((Object)this));
            }
            if (!GridLuceneLockFactory.this.locks.contains((Object)this.lockName)) {
                throw new AlreadyClosedException("Lock instance was invalidated from map: " + (Object)((Object)this));
            }
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                if (!GridLuceneLockFactory.this.locks.remove((Object)this.lockName)) {
                    throw new AlreadyClosedException("Lock was already released: " + (Object)((Object)this));
                }
            }
            finally {
                this.closed = true;
            }
        }

        public String toString() {
            return super.toString() + ": " + this.lockName;
        }
    }
}

