/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.ignite.internal.visor.VisorDataTransferObjectInput;
import org.apache.ignite.internal.visor.VisorDataTransferObjectOutput;
import org.jetbrains.annotations.Nullable;

public abstract class VisorDataTransferObject
implements Externalizable {
    private static final long serialVersionUID = 6920203681702514010L;
    private static final int MAGIC = 1119809280;
    protected static final byte V1 = 1;
    protected static final byte V2 = 2;
    protected static final byte V3 = 3;

    @Nullable
    protected static <T> List<T> toList(Collection<T> col) {
        if (col != null) {
            return new ArrayList<T>(col);
        }
        return null;
    }

    @Nullable
    protected static <T> Set<T> toSet(Collection<T> col) {
        if (col != null) {
            return new LinkedHashSet<T>(col);
        }
        return null;
    }

    public byte getProtocolVersion() {
        return 1;
    }

    protected abstract void writeExternalData(ObjectOutput var1) throws IOException;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int hdr = 1119809280 + this.getProtocolVersion();
        out.writeInt(hdr);
        try (VisorDataTransferObjectOutput dtout = new VisorDataTransferObjectOutput(out);){
            this.writeExternalData(dtout);
        }
    }

    protected abstract void readExternalData(byte var1, ObjectInput var2) throws IOException, ClassNotFoundException;

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int hdr = in.readInt();
        if ((hdr & 0x42BEEF00) != 1119809280) {
            throw new IOException("Unexpected VisorDataTransferObject header [actual=" + Integer.toHexString(hdr) + ", expected=" + Integer.toHexString(1119809280) + "]");
        }
        byte ver = (byte)(hdr & 0xFF);
        try (VisorDataTransferObjectInput dtin = new VisorDataTransferObjectInput(in);){
            this.readExternalData(ver, dtin);
        }
    }
}

