/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.lang.gridfunc;

import java.util.Collection;
import java.util.Iterator;
import org.apache.ignite.internal.util.GridSerializableCollection;
import org.apache.ignite.internal.util.GridSerializableIterator;
import org.apache.ignite.internal.util.lang.GridFunc;
import org.jetbrains.annotations.NotNull;

public class ReadOnlyCollectionView2X<T>
extends GridSerializableCollection<T> {
    private static final long serialVersionUID = 0L;
    private final Collection<T> c1;
    private final Collection<T> c2;

    public ReadOnlyCollectionView2X(Collection<T> c1, Collection<T> c2) {
        this.c1 = c1;
        this.c2 = c2;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new GridSerializableIterator<T>(){
            private Iterator<T> it1;
            private Iterator<T> it2;
            {
                this.it1 = ReadOnlyCollectionView2X.this.c1.iterator();
                this.it2 = ReadOnlyCollectionView2X.this.c2.iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.it1 != null) {
                    if (!this.it1.hasNext()) {
                        this.it1 = null;
                    } else {
                        return true;
                    }
                }
                return this.it2.hasNext();
            }

            @Override
            public T next() {
                return this.it1 != null ? this.it1.next() : this.it2.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean contains(Object o) {
        return this.c1.contains(o) || this.c2.contains(o);
    }

    @Override
    public int size() {
        return this.c1.size() + this.c2.size();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Collection && GridFunc.eqNotOrdered(this, (Collection)obj);
    }
}

