/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import org.apache.ignite.internal.processors.cache.query.GridCacheQueryType;
import org.apache.ignite.internal.processors.query.GridQueryCancel;

public class GridRunningQueryInfo {
    private final long id;
    private final String qry;
    private final GridCacheQueryType qryType;
    private final String schemaName;
    private final long startTime;
    private final GridQueryCancel cancel;
    private final boolean loc;

    public GridRunningQueryInfo(Long id, String qry, GridCacheQueryType qryType, String schemaName, long startTime, GridQueryCancel cancel, boolean loc) {
        this.id = id;
        this.qry = qry;
        this.qryType = qryType;
        this.schemaName = schemaName;
        this.startTime = startTime;
        this.cancel = cancel;
        this.loc = loc;
    }

    public Long id() {
        return this.id;
    }

    public String query() {
        return this.qry;
    }

    public GridCacheQueryType queryType() {
        return this.qryType;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public long startTime() {
        return this.startTime;
    }

    public boolean longQuery(long curTime, long duration) {
        return curTime - this.startTime > duration;
    }

    public void cancel() {
        if (this.cancel != null) {
            this.cancel.cancel();
        }
    }

    public boolean cancelable() {
        return this.cancel != null;
    }

    public boolean local() {
        return this.loc;
    }
}

