/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import org.apache.ignite.DataRegionMetrics;
import org.apache.ignite.DataStorageMetrics;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.DataPageEvictionMode;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.mem.DirectMemoryProvider;
import org.apache.ignite.internal.mem.DirectMemoryRegion;
import org.apache.ignite.internal.mem.file.MappedFileMemoryProvider;
import org.apache.ignite.internal.mem.unsafe.UnsafeMemoryProvider;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.impl.PageMemoryNoStoreImpl;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.GridCacheSharedManagerAdapter;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointFuture;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointLockStateChecker;
import org.apache.ignite.internal.processors.cache.persistence.DataRegion;
import org.apache.ignite.internal.processors.cache.persistence.DataRegionMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.DataRegionMetricsMXBeanImpl;
import org.apache.ignite.internal.processors.cache.persistence.DataRegionMetricsSnapshot;
import org.apache.ignite.internal.processors.cache.persistence.evict.FairFifoPageEvictionTracker;
import org.apache.ignite.internal.processors.cache.persistence.evict.NoOpPageEvictionTracker;
import org.apache.ignite.internal.processors.cache.persistence.evict.PageEvictionTracker;
import org.apache.ignite.internal.processors.cache.persistence.evict.Random2LruPageEvictionTracker;
import org.apache.ignite.internal.processors.cache.persistence.evict.RandomLruPageEvictionTracker;
import org.apache.ignite.internal.processors.cache.persistence.filename.PdsFolderSettings;
import org.apache.ignite.internal.processors.cache.persistence.freelist.CacheFreeListImpl;
import org.apache.ignite.internal.processors.cache.persistence.freelist.FreeList;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetaStorage;
import org.apache.ignite.internal.processors.cache.persistence.tree.reuse.ReuseList;
import org.apache.ignite.internal.processors.cluster.IgniteChangeGlobalStateSupport;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteOutClosure;
import org.apache.ignite.mxbean.DataRegionMetricsMXBean;
import org.jetbrains.annotations.Nullable;

public class IgniteCacheDatabaseSharedManager
extends GridCacheSharedManagerAdapter
implements IgniteChangeGlobalStateSupport,
CheckpointLockStateChecker {
    public static final String SYSTEM_DATA_REGION_NAME = "sysMemPlc";
    private static final long MIN_PAGE_MEMORY_SIZE = 0xA00000L;
    private static final long MAX_PAGE_MEMORY_INIT_SIZE_32_BIT = 0x80000000L;
    protected volatile Map<String, DataRegion> dataRegionMap;
    private volatile boolean dataRegionsInitialized;
    protected Map<String, DataRegionMetrics> memMetricsMap;
    protected DataRegion dfltDataRegion;
    protected Map<String, CacheFreeListImpl> freeListMap;
    private CacheFreeListImpl dfltFreeList;
    private int pageSize;

    @Override
    protected void start0() throws IgniteCheckedException {
        if (this.cctx.kernalContext().clientNode() && this.cctx.kernalContext().config().getDataStorageConfiguration() == null) {
            return;
        }
        DataStorageConfiguration memCfg = this.cctx.kernalContext().config().getDataStorageConfiguration();
        assert (memCfg != null);
        this.validateConfiguration(memCfg);
        this.pageSize = memCfg.getPageSize();
        this.initDataRegions(memCfg);
    }

    private void registerMetricsMBeans() {
        if (U.IGNITE_MBEANS_DISABLED) {
            return;
        }
        IgniteConfiguration cfg = this.cctx.gridConfig();
        for (DataRegionMetrics memMetrics : this.memMetricsMap.values()) {
            DataRegionConfiguration memPlcCfg = this.dataRegionMap.get(memMetrics.getName()).config();
            this.registerMetricsMBean((DataRegionMetricsImpl)memMetrics, memPlcCfg, cfg);
        }
    }

    private void registerMetricsMBean(DataRegionMetricsImpl memMetrics, DataRegionConfiguration dataRegionCfg, IgniteConfiguration cfg) {
        assert (!U.IGNITE_MBEANS_DISABLED);
        try {
            U.registerMBean(cfg.getMBeanServer(), cfg.getIgniteInstanceName(), "DataRegionMetrics", dataRegionCfg.getName(), new DataRegionMetricsMXBeanImpl(memMetrics, dataRegionCfg), DataRegionMetricsMXBean.class);
        }
        catch (Throwable e) {
            U.error(this.log, "Failed to register MBean for DataRegionMetrics with name: '" + memMetrics.getName() + "'", e);
        }
    }

    protected void initPageMemoryDataStructures(DataStorageConfiguration dbCfg) throws IgniteCheckedException {
        this.freeListMap = U.newHashMap(this.dataRegionMap.size());
        String dfltMemPlcName = dbCfg.getDefaultDataRegionConfiguration().getName();
        for (DataRegion memPlc : this.dataRegionMap.values()) {
            DataRegionConfiguration memPlcCfg = memPlc.config();
            DataRegionMetricsImpl memMetrics = (DataRegionMetricsImpl)this.memMetricsMap.get(memPlcCfg.getName());
            boolean persistenceEnabled = memPlcCfg.isPersistenceEnabled();
            CacheFreeListImpl freeList = new CacheFreeListImpl(0, this.cctx.igniteInstanceName(), memMetrics, memPlc, null, persistenceEnabled ? this.cctx.wal() : null, 0L, true);
            this.freeListMap.put(memPlcCfg.getName(), freeList);
        }
        this.dfltFreeList = this.freeListMap.get(dfltMemPlcName);
    }

    public int pageSize() {
        return this.pageSize;
    }

    private void startMemoryPolicies() {
        for (DataRegion memPlc : this.dataRegionMap.values()) {
            memPlc.pageMemory().start();
            memPlc.evictionTracker().start();
        }
    }

    protected void initDataRegions(DataStorageConfiguration memCfg) throws IgniteCheckedException {
        if (this.dataRegionsInitialized) {
            return;
        }
        DataRegionConfiguration[] dataRegionCfgs = memCfg.getDataRegionConfigurations();
        int dataRegions = dataRegionCfgs == null ? 0 : dataRegionCfgs.length;
        this.dataRegionMap = U.newHashMap(3 + dataRegions);
        this.memMetricsMap = U.newHashMap(3 + dataRegions);
        if (dataRegionCfgs != null) {
            for (DataRegionConfiguration dataRegionCfg : dataRegionCfgs) {
                this.addDataRegion(memCfg, dataRegionCfg, dataRegionCfg.isPersistenceEnabled());
            }
        }
        this.addDataRegion(memCfg, memCfg.getDefaultDataRegionConfiguration(), memCfg.getDefaultDataRegionConfiguration().isPersistenceEnabled());
        this.addDataRegion(memCfg, this.createSystemDataRegion(memCfg.getSystemRegionInitialSize(), memCfg.getSystemRegionMaxSize(), CU.isPersistenceEnabled(memCfg)), CU.isPersistenceEnabled(memCfg));
        this.dataRegionsInitialized = true;
    }

    protected void addDataRegion(DataStorageConfiguration dataStorageCfg, DataRegionConfiguration dataRegionCfg, boolean trackable) throws IgniteCheckedException {
        String dataRegionName = dataRegionCfg.getName();
        String dfltMemPlcName = dataStorageCfg.getDefaultDataRegionConfiguration().getName();
        if (dfltMemPlcName == null) {
            dfltMemPlcName = "default";
        }
        DataRegionMetricsImpl memMetrics = new DataRegionMetricsImpl(dataRegionCfg, this.freeSpaceProvider(dataRegionCfg));
        DataRegion memPlc = this.initMemory(dataStorageCfg, dataRegionCfg, memMetrics, trackable);
        this.dataRegionMap.put(dataRegionName, memPlc);
        this.memMetricsMap.put(dataRegionName, memMetrics);
        if (dataRegionName.equals(dfltMemPlcName)) {
            this.dfltDataRegion = memPlc;
        } else if (dataRegionName.equals("default")) {
            U.warn(this.log, "Data Region with name 'default' isn't used as a default. Please check Memory Policies configuration.");
        }
    }

    protected IgniteOutClosure<Long> freeSpaceProvider(DataRegionConfiguration dataRegCfg) {
        final String dataRegName = dataRegCfg.getName();
        return new IgniteOutClosure<Long>(){
            private CacheFreeListImpl freeList;

            @Override
            public Long apply() {
                if (this.freeList == null) {
                    CacheFreeListImpl freeList0 = IgniteCacheDatabaseSharedManager.this.freeListMap.get(dataRegName);
                    if (freeList0 == null) {
                        return 0L;
                    }
                    this.freeList = freeList0;
                }
                return this.freeList.freeSpace();
            }
        };
    }

    private boolean hasCustomDefaultDataRegion(DataRegionConfiguration[] memPlcsCfgs) {
        for (DataRegionConfiguration memPlcsCfg : memPlcsCfgs) {
            if (!"default".equals(memPlcsCfg.getName())) continue;
            return true;
        }
        return false;
    }

    private DataRegionConfiguration createSystemDataRegion(long sysCacheInitSize, long sysCacheMaxSize, boolean persistenceEnabled) {
        DataRegionConfiguration res = new DataRegionConfiguration();
        res.setName(SYSTEM_DATA_REGION_NAME);
        res.setInitialSize(sysCacheInitSize);
        res.setMaxSize(sysCacheMaxSize);
        res.setPersistenceEnabled(persistenceEnabled);
        return res;
    }

    private void validateConfiguration(DataStorageConfiguration memCfg) throws IgniteCheckedException {
        this.checkPageSize(memCfg);
        DataRegionConfiguration[] regCfgs = memCfg.getDataRegionConfigurations();
        HashSet<String> regNames = regCfgs != null ? U.newHashSet(regCfgs.length) : new HashSet<String>(0);
        IgniteCacheDatabaseSharedManager.checkSystemDataRegionSizeConfiguration(memCfg.getSystemRegionInitialSize(), memCfg.getSystemRegionMaxSize());
        if (regCfgs != null) {
            for (DataRegionConfiguration regCfg : regCfgs) {
                this.checkDataRegionConfiguration(memCfg, regNames, regCfg);
            }
        }
        this.checkDataRegionConfiguration(memCfg, regNames, memCfg.getDefaultDataRegionConfiguration());
    }

    private void checkDataRegionConfiguration(DataStorageConfiguration memCfg, Set<String> regNames, DataRegionConfiguration regCfg) throws IgniteCheckedException {
        assert (regCfg != null);
        IgniteCacheDatabaseSharedManager.checkDataRegionName(regCfg.getName(), regNames);
        this.checkDataRegionSize(regCfg);
        IgniteCacheDatabaseSharedManager.checkMetricsProperties(regCfg);
        this.checkRegionEvictionProperties(regCfg, memCfg);
        this.checkRegionMemoryStorageType(regCfg);
    }

    protected void checkPageSize(DataStorageConfiguration memCfg) {
        if (memCfg.getPageSize() == 0) {
            memCfg.setPageSize(4096);
        }
    }

    private static void checkMetricsProperties(DataRegionConfiguration regCfg) throws IgniteCheckedException {
        if (regCfg.getMetricsRateTimeInterval() <= 0L) {
            throw new IgniteCheckedException("Rate time interval must be greater than zero (use DataRegionConfiguration.rateTimeInterval property to adjust the interval) [name=" + regCfg.getName() + ", rateTimeInterval=" + regCfg.getMetricsRateTimeInterval() + "]");
        }
        if (regCfg.getMetricsSubIntervalCount() <= 0) {
            throw new IgniteCheckedException("Sub intervals must be greater than zero (use DataRegionConfiguration.subIntervals property to adjust the sub intervals) [name=" + regCfg.getName() + ", subIntervals=" + regCfg.getMetricsSubIntervalCount() + "]");
        }
        if (regCfg.getMetricsRateTimeInterval() < 1000L) {
            throw new IgniteCheckedException("Rate time interval must be longer that 1 second (1_000 milliseconds) (use DataRegionConfiguration.rateTimeInterval property to adjust the interval) [name=" + regCfg.getName() + ", rateTimeInterval=" + regCfg.getMetricsRateTimeInterval() + "]");
        }
    }

    private static void checkSystemDataRegionSizeConfiguration(long sysCacheInitSize, long sysCacheMaxSize) throws IgniteCheckedException {
        if (sysCacheInitSize < 0xA00000L) {
            throw new IgniteCheckedException("Initial size for system cache must have size more than 10MB (use DataStorageConfiguration.systemCacheInitialSize property to set correct size in bytes) [size=" + U.readableSize(sysCacheInitSize, true) + ']');
        }
        if (U.jvm32Bit() && sysCacheInitSize > 0x80000000L) {
            throw new IgniteCheckedException("Initial size for system cache exceeds 2GB on 32-bit JVM (use DataRegionConfiguration.systemCacheInitialSize property to set correct size in bytes or use 64-bit JVM) [size=" + U.readableSize(sysCacheInitSize, true) + ']');
        }
        if (sysCacheMaxSize < sysCacheInitSize) {
            throw new IgniteCheckedException("MaxSize of system cache must not be smaller than initialSize [initSize=" + U.readableSize(sysCacheInitSize, true) + ", maxSize=" + U.readableSize(sysCacheMaxSize, true) + "]. " + "Use DataStorageConfiguration.systemCacheInitialSize/DataStorageConfiguration.systemCacheMaxSize " + "properties to set correct sizes in bytes.");
        }
    }

    private void checkDataRegionSize(DataRegionConfiguration regCfg) throws IgniteCheckedException {
        if (regCfg.getInitialSize() < 0xA00000L || regCfg.getMaxSize() < 0xA00000L) {
            throw new IgniteCheckedException("DataRegion must have size more than 10MB (use DataRegionConfiguration.initialSize and .maxSize properties to set correct size in bytes) [name=" + regCfg.getName() + ", initialSize=" + U.readableSize(regCfg.getInitialSize(), true) + ", maxSize=" + U.readableSize(regCfg.getMaxSize(), true) + "]");
        }
        if (regCfg.getMaxSize() < regCfg.getInitialSize()) {
            if (regCfg.getInitialSize() != Math.min(DataStorageConfiguration.DFLT_DATA_REGION_MAX_SIZE, 0x10000000L)) {
                throw new IgniteCheckedException("DataRegion maxSize must not be smaller than initialSize[name=" + regCfg.getName() + ", initialSize=" + U.readableSize(regCfg.getInitialSize(), true) + ", maxSize=" + U.readableSize(regCfg.getMaxSize(), true) + "]");
            }
            regCfg.setInitialSize(regCfg.getMaxSize());
            LT.warn(this.log, "DataRegion maxSize=" + U.readableSize(regCfg.getMaxSize(), true) + " is smaller than defaultInitialSize=" + U.readableSize(0x10000000L, true) + ", setting initialSize to " + U.readableSize(regCfg.getMaxSize(), true));
        }
        if (U.jvm32Bit() && regCfg.getInitialSize() > 0x80000000L) {
            throw new IgniteCheckedException("DataRegion initialSize exceeds 2GB on 32-bit JVM (use DataRegionConfiguration.initialSize property to set correct size in bytes or use 64-bit JVM) [name=" + regCfg.getName() + ", size=" + U.readableSize(regCfg.getInitialSize(), true) + "]");
        }
    }

    private void checkRegionMemoryStorageType(DataRegionConfiguration regCfg) throws IgniteCheckedException {
        if (regCfg.isPersistenceEnabled() && regCfg.getSwapPath() != null) {
            throw new IgniteCheckedException("DataRegionConfiguration must not have both persistence storage and swap space enabled at the same time (Use DataRegionConfiguration.setSwapPath(null)  to disable the swap space usage or DataRegionConfiguration.setPersistenceEnabled(false) to disable the persistence) [name=" + regCfg.getName() + ", swapPath=" + regCfg.getSwapPath() + ", persistenceEnabled=" + regCfg.isPersistenceEnabled() + "]");
        }
    }

    protected void checkRegionEvictionProperties(DataRegionConfiguration regCfg, DataStorageConfiguration dbCfg) throws IgniteCheckedException {
        if (regCfg.getPageEvictionMode() == DataPageEvictionMode.DISABLED) {
            return;
        }
        if (regCfg.getEvictionThreshold() < 0.5 || regCfg.getEvictionThreshold() > 0.999) {
            throw new IgniteCheckedException("Page eviction threshold must be between 0.5 and 0.999: " + regCfg.getName());
        }
        if (regCfg.getEmptyPagesPoolSize() <= 10) {
            throw new IgniteCheckedException("Evicted pages pool size should be greater than 10: " + regCfg.getName());
        }
        long maxPoolSize = regCfg.getMaxSize() / (long)dbCfg.getPageSize() / 10L;
        if ((long)regCfg.getEmptyPagesPoolSize() >= maxPoolSize) {
            throw new IgniteCheckedException("Evicted pages pool size should be lesser than " + maxPoolSize + ": " + regCfg.getName());
        }
    }

    private static void checkDataRegionName(String regName, Collection<String> observedNames) throws IgniteCheckedException {
        if (regName == null || regName.isEmpty()) {
            throw new IgniteCheckedException("User-defined DataRegionConfiguration must have non-null and non-empty name.");
        }
        if (observedNames.contains(regName)) {
            throw new IgniteCheckedException("Two MemoryPolicies have the same name: " + regName);
        }
        if (SYSTEM_DATA_REGION_NAME.equals(regName)) {
            throw new IgniteCheckedException("'sysMemPlc' policy name is reserved for internal use.");
        }
        observedNames.add(regName);
    }

    public void dumpStatistics(IgniteLogger log) {
        if (this.freeListMap != null) {
            for (CacheFreeListImpl freeList : this.freeListMap.values()) {
                freeList.dumpStatistics(log);
            }
        }
    }

    public Collection<DataRegion> dataRegions() {
        return this.dataRegionMap != null ? this.dataRegionMap.values() : null;
    }

    public Collection<DataRegionMetrics> memoryMetrics() {
        if (!F.isEmpty(this.memMetricsMap)) {
            ArrayList<DataRegionMetrics> res = new ArrayList<DataRegionMetrics>(this.memMetricsMap.size());
            for (DataRegionMetrics metrics : this.memMetricsMap.values()) {
                res.add(new DataRegionMetricsSnapshot(metrics));
            }
            return res;
        }
        return Collections.emptyList();
    }

    public DataStorageMetrics persistentStoreMetrics() {
        return null;
    }

    public void readCheckpointAndRestoreMemory(List<DynamicCacheDescriptor> cachesToStart) throws IgniteCheckedException {
    }

    @Nullable
    public DataRegionMetrics memoryMetrics(String memPlcName) {
        if (!F.isEmpty(this.memMetricsMap)) {
            DataRegionMetrics memMetrics = this.memMetricsMap.get(memPlcName);
            return memMetrics == null ? null : new DataRegionMetricsSnapshot(memMetrics);
        }
        return null;
    }

    public DataRegion dataRegion(String memPlcName) throws IgniteCheckedException {
        if (memPlcName == null) {
            return this.dfltDataRegion;
        }
        if (this.dataRegionMap == null) {
            return null;
        }
        DataRegion plc = this.dataRegionMap.get(memPlcName);
        if (plc == null) {
            throw new IgniteCheckedException("Requested DataRegion is not configured: " + memPlcName);
        }
        return plc;
    }

    public FreeList freeList(String memPlcName) {
        if (memPlcName == null) {
            return this.dfltFreeList;
        }
        return this.freeListMap != null ? (FreeList)this.freeListMap.get(memPlcName) : null;
    }

    public ReuseList reuseList(String memPlcName) {
        if (memPlcName == null) {
            return this.dfltFreeList;
        }
        return this.freeListMap != null ? (ReuseList)this.freeListMap.get(memPlcName) : null;
    }

    @Override
    protected void stop0(boolean cancel) {
        if (this.dataRegionMap != null) {
            for (DataRegion memPlc : this.dataRegionMap.values()) {
                memPlc.pageMemory().stop();
                memPlc.evictionTracker().stop();
                this.unregisterMBean(memPlc.memoryMetrics().getName());
            }
            this.dataRegionMap.clear();
            this.dataRegionMap = null;
            this.dataRegionsInitialized = false;
        }
    }

    private void unregisterMBean(String name) {
        if (U.IGNITE_MBEANS_DISABLED) {
            return;
        }
        IgniteConfiguration cfg = this.cctx.gridConfig();
        try {
            cfg.getMBeanServer().unregisterMBean(U.makeMBeanName(cfg.getIgniteInstanceName(), "DataRegionMetrics", name));
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (Throwable e) {
            U.error(this.log, "Failed to unregister MBean for memory metrics: " + name, e);
        }
    }

    @Override
    public boolean checkpointLockIsHeldByThread() {
        return true;
    }

    public void lock() throws IgniteCheckedException {
    }

    public void unLock() {
    }

    public void checkpointReadLock() {
    }

    public void checkpointReadUnlock() {
    }

    @Nullable
    public IgniteInternalFuture wakeupForCheckpoint(String reason) {
        return null;
    }

    @Nullable
    public CheckpointFuture forceCheckpoint(String reason) {
        return null;
    }

    public void waitForCheckpoint(String reason) throws IgniteCheckedException {
    }

    public void beforeExchange(GridDhtPartitionsExchangeFuture discoEvt) throws IgniteCheckedException {
    }

    public void rebuildIndexesIfNeeded(GridDhtPartitionsExchangeFuture fut) {
    }

    public void prepareCachesStop() {
    }

    public void onCacheGroupsStopped(Collection<IgniteBiTuple<CacheGroupContext, Boolean>> stoppedGrps) {
    }

    @Nullable
    public IgniteInternalFuture indexRebuildFuture(int cacheId) {
        return null;
    }

    public Map<Integer, Map<Integer, Long>> reserveHistoryForExchange() {
        return Collections.emptyMap();
    }

    public void releaseHistoryForExchange() {
    }

    public boolean reserveHistoryForPreloading(int grpId, int partId, long cntr) {
        return false;
    }

    public void releaseHistoryForPreloading() {
    }

    public void ensureFreeSpace(DataRegion memPlc) throws IgniteCheckedException {
        if (memPlc == null) {
            return;
        }
        DataRegionConfiguration plcCfg = memPlc.config();
        if (plcCfg.getPageEvictionMode() == DataPageEvictionMode.DISABLED || plcCfg.isPersistenceEnabled()) {
            return;
        }
        long memorySize = plcCfg.getMaxSize();
        PageMemory pageMem = memPlc.pageMemory();
        int sysPageSize = pageMem.systemPageSize();
        CacheFreeListImpl freeListImpl = this.freeListMap.get(plcCfg.getName());
        while (true) {
            boolean shouldEvict;
            long allocatedPagesCnt = pageMem.loadedPages();
            int emptyDataPagesCnt = freeListImpl.emptyDataPages();
            boolean bl = shouldEvict = (double)allocatedPagesCnt > (double)(memorySize / (long)sysPageSize) * plcCfg.getEvictionThreshold() && emptyDataPagesCnt < plcCfg.getEmptyPagesPoolSize();
            if (!shouldEvict) break;
            memPlc.evictionTracker().evictDataPage();
            memPlc.memoryMetrics().updateEvictionRate();
        }
    }

    private DataRegion initMemory(DataStorageConfiguration memCfg, DataRegionConfiguration plcCfg, DataRegionMetricsImpl memMetrics, boolean trackable) throws IgniteCheckedException {
        File allocPath = this.buildAllocPath(plcCfg);
        DirectMemoryProvider memProvider = allocPath == null ? new UnsafeMemoryProvider(this.log) : new MappedFileMemoryProvider(this.log, allocPath);
        PageMemory pageMem = this.createPageMemory(memProvider, memCfg, plcCfg, memMetrics, trackable);
        return new DataRegion(pageMem, plcCfg, memMetrics, this.createPageEvictionTracker(plcCfg, pageMem));
    }

    protected PageEvictionTracker createPageEvictionTracker(DataRegionConfiguration plc, PageMemory pageMem) {
        if (plc.getPageEvictionMode() == DataPageEvictionMode.DISABLED || plc.isPersistenceEnabled()) {
            return new NoOpPageEvictionTracker();
        }
        assert (pageMem instanceof PageMemoryNoStoreImpl) : pageMem.getClass();
        PageMemoryNoStoreImpl pageMem0 = (PageMemoryNoStoreImpl)pageMem;
        if (Boolean.getBoolean("override.fair.fifo.page.eviction.tracker")) {
            return new FairFifoPageEvictionTracker(pageMem0, plc, this.cctx);
        }
        switch (plc.getPageEvictionMode()) {
            case RANDOM_LRU: {
                return new RandomLruPageEvictionTracker((PageMemory)pageMem0, plc, this.cctx);
            }
            case RANDOM_2_LRU: {
                return new Random2LruPageEvictionTracker(pageMem0, plc, this.cctx);
            }
        }
        return new NoOpPageEvictionTracker();
    }

    @Nullable
    protected File buildAllocPath(DataRegionConfiguration plc) throws IgniteCheckedException {
        String path = plc.getSwapPath();
        if (path == null) {
            return null;
        }
        PdsFolderSettings folderSettings = this.cctx.kernalContext().pdsFolderResolver().resolveFolders();
        String folderName = folderSettings.isCompatible() ? String.valueOf(folderSettings.consistentId()).replaceAll("[:,\\.]", "_") : folderSettings.folderName();
        return this.buildPath(path, folderName);
    }

    protected PageMemory createPageMemory(DirectMemoryProvider memProvider, DataStorageConfiguration memCfg, DataRegionConfiguration memPlcCfg, DataRegionMetricsImpl memMetrics, boolean trackable) {
        memMetrics.persistenceEnabled(false);
        PageMemoryNoStoreImpl pageMem = new PageMemoryNoStoreImpl(this.log, this.wrapMetricsMemoryProvider(memProvider, memMetrics), this.cctx, memCfg.getPageSize(), memPlcCfg, memMetrics, false);
        memMetrics.pageMemory(pageMem);
        return pageMem;
    }

    protected DirectMemoryProvider wrapMetricsMemoryProvider(final DirectMemoryProvider memoryProvider0, final DataRegionMetricsImpl memMetrics) {
        return new DirectMemoryProvider(){
            private final DirectMemoryProvider memProvider;
            {
                this.memProvider = memoryProvider0;
            }

            @Override
            public void initialize(long[] chunkSizes) {
                this.memProvider.initialize(chunkSizes);
            }

            @Override
            public void shutdown() {
                this.memProvider.shutdown();
            }

            @Override
            public DirectMemoryRegion nextRegion() {
                DirectMemoryRegion nextMemoryRegion = this.memProvider.nextRegion();
                if (nextMemoryRegion == null) {
                    return null;
                }
                memMetrics.updateOffHeapSize(nextMemoryRegion.size());
                return nextMemoryRegion;
            }
        };
    }

    protected File buildPath(String path, String consId) throws IgniteCheckedException {
        String igniteHomeStr = U.getIgniteHome();
        File workDir = igniteHomeStr == null ? new File(path) : U.resolveWorkDirectory(igniteHomeStr, path, false);
        return new File(workDir, consId);
    }

    @Override
    public void onActivate(GridKernalContext kctx) throws IgniteCheckedException {
        if (this.cctx.kernalContext().clientNode() && this.cctx.kernalContext().config().getDataStorageConfiguration() == null) {
            return;
        }
        DataStorageConfiguration memCfg = this.cctx.kernalContext().config().getDataStorageConfiguration();
        assert (memCfg != null);
        this.initDataRegions(memCfg);
        this.registerMetricsMBeans();
        this.startMemoryPolicies();
        this.initPageMemoryDataStructures(memCfg);
    }

    @Override
    public void onDeActivate(GridKernalContext kctx) {
        this.stop0(false);
    }

    public String systemDateRegionName() {
        return SYSTEM_DATA_REGION_NAME;
    }

    protected void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public MetaStorage metaStorage() {
        return null;
    }

    public boolean walEnabled(int grpId, boolean local) {
        return false;
    }

    public void walEnabled(int grpId, boolean enabled, boolean local) {
    }
}

