/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.google.common.net.InetAddresses;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ServerName
implements Comparable<ServerName>,
Serializable {
    private static final long serialVersionUID = 1367463982557264981L;
    private static final short VERSION = 0;
    static final byte[] VERSION_BYTES = Bytes.toBytes((short)0);
    public static final int NON_STARTCODE = -1;
    public static final String SERVERNAME_SEPARATOR = ",";
    public static final Pattern SERVERNAME_PATTERN = Pattern.compile("[^,]+,[\\d]+,[\\d]+$");
    public static final String UNKNOWN_SERVERNAME = "#unknown#";
    private final String servername;
    private final String hostnameOnly;
    private final int port;
    private final long startcode;
    private byte[] bytes;
    public static final List<ServerName> EMPTY_SERVER_LIST = new ArrayList<ServerName>(0);

    private ServerName(String hostname, int port, long startcode) {
        this.hostnameOnly = hostname;
        this.port = port;
        this.startcode = startcode;
        this.servername = ServerName.getServerName(this.hostnameOnly, port, startcode);
    }

    static String getHostNameMinusDomain(String hostname) {
        if (InetAddresses.isInetAddress((String)hostname)) {
            return hostname;
        }
        String[] parts = hostname.split("\\.");
        if (parts == null || parts.length == 0) {
            return hostname;
        }
        return parts[0];
    }

    private ServerName(String serverName) {
        this(ServerName.parseHostname(serverName), ServerName.parsePort(serverName), ServerName.parseStartcode(serverName));
    }

    private ServerName(String hostAndPort, long startCode) {
        this(Addressing.parseHostname((String)hostAndPort), Addressing.parsePort((String)hostAndPort), startCode);
    }

    public static String parseHostname(String serverName) {
        if (serverName == null || serverName.length() <= 0) {
            throw new IllegalArgumentException("Passed hostname is null or empty");
        }
        if (!Character.isLetterOrDigit(serverName.charAt(0))) {
            throw new IllegalArgumentException("Bad passed hostname, serverName=" + serverName);
        }
        int index = serverName.indexOf(SERVERNAME_SEPARATOR);
        return serverName.substring(0, index);
    }

    public static int parsePort(String serverName) {
        String[] split = serverName.split(SERVERNAME_SEPARATOR);
        return Integer.parseInt(split[1]);
    }

    public static long parseStartcode(String serverName) {
        int index = serverName.lastIndexOf(SERVERNAME_SEPARATOR);
        return Long.parseLong(serverName.substring(index + 1));
    }

    public static ServerName valueOf(String hostname, int port, long startcode) {
        return new ServerName(hostname, port, startcode);
    }

    public static ServerName valueOf(String serverName) {
        return new ServerName(serverName);
    }

    public static ServerName valueOf(String hostAndPort, long startCode) {
        return new ServerName(hostAndPort, startCode);
    }

    public String toString() {
        return this.getServerName();
    }

    public String toShortString() {
        return Addressing.createHostAndPortStr((String)ServerName.getHostNameMinusDomain(this.hostnameOnly), (int)this.port);
    }

    public synchronized byte[] getVersionedBytes() {
        if (this.bytes == null) {
            this.bytes = Bytes.add((byte[])VERSION_BYTES, (byte[])Bytes.toBytes((String)this.getServerName()));
        }
        return this.bytes;
    }

    public String getServerName() {
        return this.servername;
    }

    public String getHostname() {
        return this.hostnameOnly;
    }

    public int getPort() {
        return this.port;
    }

    public long getStartcode() {
        return this.startcode;
    }

    static String getServerName(String hostName, int port, long startcode) {
        StringBuilder name = new StringBuilder(hostName.length() + 1 + 5 + 1 + 13);
        name.append(hostName.toLowerCase());
        name.append(SERVERNAME_SEPARATOR);
        name.append(port);
        name.append(SERVERNAME_SEPARATOR);
        name.append(startcode);
        return name.toString();
    }

    public static String getServerName(String hostAndPort, long startcode) {
        int index = hostAndPort.indexOf(":");
        if (index <= 0) {
            throw new IllegalArgumentException("Expected <hostname> ':' <port>");
        }
        return ServerName.getServerName(hostAndPort.substring(0, index), Integer.parseInt(hostAndPort.substring(index + 1)), startcode);
    }

    public String getHostAndPort() {
        return Addressing.createHostAndPortStr((String)this.hostnameOnly, (int)this.port);
    }

    public static long getServerStartcodeFromServerName(String serverName) {
        int index = serverName.lastIndexOf(SERVERNAME_SEPARATOR);
        return Long.parseLong(serverName.substring(index + 1));
    }

    public static String getServerNameLessStartCode(String inServerName) {
        int index;
        if (inServerName != null && inServerName.length() > 0 && (index = inServerName.lastIndexOf(SERVERNAME_SEPARATOR)) > 0) {
            return inServerName.substring(0, index);
        }
        return inServerName;
    }

    @Override
    public int compareTo(ServerName other) {
        int compare = this.getHostname().compareToIgnoreCase(other.getHostname());
        if (compare != 0) {
            return compare;
        }
        compare = this.getPort() - other.getPort();
        if (compare != 0) {
            return compare;
        }
        return Long.compare(this.getStartcode(), other.getStartcode());
    }

    public int hashCode() {
        return this.getServerName().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof ServerName)) {
            return false;
        }
        return this.compareTo((ServerName)o) == 0;
    }

    public static boolean isSameHostnameAndPort(ServerName left, ServerName right) {
        if (left == null) {
            return false;
        }
        if (right == null) {
            return false;
        }
        return left.getHostname().compareToIgnoreCase(right.getHostname()) == 0 && left.getPort() == right.getPort();
    }

    public static ServerName parseVersionedServerName(byte[] versionedBytes) {
        short version = Bytes.toShort((byte[])versionedBytes);
        if (version == 0) {
            int length = versionedBytes.length - 2;
            return ServerName.valueOf(Bytes.toString((byte[])versionedBytes, (int)2, (int)length));
        }
        return ServerName.valueOf(Bytes.toString((byte[])versionedBytes), -1L);
    }

    public static ServerName parseServerName(String str) {
        return SERVERNAME_PATTERN.matcher(str).matches() ? ServerName.valueOf(str) : ServerName.valueOf(str, -1L);
    }

    public static boolean isFullServerName(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        return SERVERNAME_PATTERN.matcher(str).matches();
    }

    public static ServerName parseFrom(byte[] data) throws DeserializationException {
        if (data == null || data.length <= 0) {
            return null;
        }
        if (ProtobufUtil.isPBMagicPrefix(data)) {
            int prefixLen = ProtobufUtil.lengthOfPBMagic();
            try {
                ZooKeeperProtos.Master rss = (ZooKeeperProtos.Master)ZooKeeperProtos.Master.PARSER.parseFrom(data, prefixLen, data.length - prefixLen);
                HBaseProtos.ServerName sn = rss.getMaster();
                return ServerName.valueOf(sn.getHostName(), sn.getPort(), sn.getStartCode());
            }
            catch (InvalidProtocolBufferException e) {
                throw new DeserializationException(e);
            }
        }
        String str = Bytes.toString((byte[])data);
        int index = str.indexOf(SERVERNAME_SEPARATOR);
        if (index != -1) {
            return ServerName.parseVersionedServerName(data);
        }
        String hostname = Addressing.parseHostname((String)str);
        int port = Addressing.parsePort((String)str);
        return ServerName.valueOf(hostname, port, -1L);
    }
}

