/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.mxbean;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.mxbean.MXBeanDescription;
import org.apache.ignite.mxbean.MXBeanParametersDescriptions;
import org.apache.ignite.mxbean.MXBeanParametersNames;

public class IgniteStandardMXBean
extends StandardMBean {
    private static final Map<String, Class<?>> primCls = new HashMap();

    public <T> IgniteStandardMXBean(T implementation, Class<T> mbeanInterface) throws NotCompliantMBeanException {
        super(implementation, mbeanInterface);
    }

    @Override
    protected String getDescription(MBeanAttributeInfo info) {
        String str = super.getDescription(info);
        String methodName = (info.isIs() ? "is" : "get") + info.getName();
        try {
            MXBeanDescription desc;
            Method mtd = this.findMethod(this.getMBeanInterface(), methodName, new Class[0]);
            if (mtd != null && (desc = mtd.getAnnotation(MXBeanDescription.class)) != null) {
                str = desc.value();
                assert (str != null) : "Failed to find method: " + mtd;
                assert (str.trim().length() > 0) : "Method description cannot be empty: " + mtd;
                assert (Character.isUpperCase(str.charAt(0))) : "Description must start with upper case: " + str;
                assert (str.charAt(str.length() - 1) == '.') : "Description must end with period: " + str;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return str;
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        String str = super.getDescription(info);
        MXBeanDescription desc = U.getAnnotation(this.getMBeanInterface(), MXBeanDescription.class);
        if (desc != null) {
            str = desc.value();
            assert (str != null);
            assert (str.trim().length() > 0);
            assert (Character.isUpperCase(str.charAt(0))) : str;
            assert (str.charAt(str.length() - 1) == '.') : str;
        }
        return str;
    }

    @Override
    protected String getDescription(MBeanOperationInfo info) {
        String str = super.getDescription(info);
        try {
            Method m = this.getMethod(info);
            MXBeanDescription desc = m.getAnnotation(MXBeanDescription.class);
            if (desc != null) {
                str = desc.value();
                assert (str != null);
                assert (str.trim().length() > 0);
                assert (Character.isUpperCase(str.charAt(0))) : str;
                assert (str.charAt(str.length() - 1) == '.') : str;
            }
        }
        catch (ClassNotFoundException | SecurityException exception) {
            // empty catch block
        }
        return str;
    }

    @Override
    protected String getDescription(MBeanOperationInfo op, MBeanParameterInfo param, int seq) {
        String str = super.getDescription(op, param, seq);
        try {
            Method m = this.getMethod(op);
            MXBeanParametersDescriptions decsAnn = m.getAnnotation(MXBeanParametersDescriptions.class);
            if (decsAnn != null) {
                assert (decsAnn.value() != null);
                assert (seq < decsAnn.value().length);
                str = decsAnn.value()[seq];
                assert (str != null);
                assert (str.trim().length() > 0);
                assert (Character.isUpperCase(str.charAt(0))) : str;
                assert (str.charAt(str.length() - 1) == '.') : str;
            }
        }
        catch (ClassNotFoundException | SecurityException exception) {
            // empty catch block
        }
        return str;
    }

    @Override
    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int seq) {
        String str = super.getParameterName(op, param, seq);
        try {
            Method m = this.getMethod(op);
            MXBeanParametersNames namesAnn = m.getAnnotation(MXBeanParametersNames.class);
            if (namesAnn != null) {
                assert (namesAnn.value() != null);
                assert (seq < namesAnn.value().length);
                str = namesAnn.value()[seq];
                assert (str != null);
                assert (str.trim().length() > 0);
            }
        }
        catch (ClassNotFoundException | SecurityException exception) {
            // empty catch block
        }
        return str;
    }

    private Method getMethod(MBeanOperationInfo op) throws ClassNotFoundException, SecurityException {
        String methodName = op.getName();
        MBeanParameterInfo[] signature = op.getSignature();
        Class[] params = new Class[signature.length];
        for (int i = 0; i < signature.length; ++i) {
            Class<?> type = primCls.get(signature[i].getType().toLowerCase());
            if (type == null) {
                type = Class.forName(signature[i].getType());
            }
            params[i] = type;
        }
        return this.findMethod(this.getMBeanInterface(), methodName, params);
    }

    private Method findMethod(Class itf, String methodName, Class[] params) {
        Class<?>[] superItfs;
        assert (itf.isInterface());
        Method res = null;
        try {
            res = itf.getDeclaredMethod(methodName, params);
            if (res != null) {
                return res;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        for (Class<?> superItf : superItfs = itf.getInterfaces()) {
            res = this.findMethod(superItf, methodName, params);
            if (res == null) continue;
            return res;
        }
        return res;
    }

    static {
        primCls.put(Boolean.TYPE.toString().toLowerCase(), Boolean.TYPE);
        primCls.put(Character.TYPE.toString().toLowerCase(), Character.TYPE);
        primCls.put(Byte.TYPE.toString().toLowerCase(), Byte.TYPE);
        primCls.put(Short.TYPE.toString().toLowerCase(), Short.TYPE);
        primCls.put(Integer.TYPE.toString().toLowerCase(), Integer.TYPE);
        primCls.put(Long.TYPE.toString().toLowerCase(), Long.TYPE);
        primCls.put(Float.TYPE.toString().toLowerCase(), Float.TYPE);
        primCls.put(Double.TYPE.toString().toLowerCase(), Double.TYPE);
    }
}

