/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.thin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.client.ClientException;
import org.apache.ignite.internal.client.thin.QueryPager;
import org.jetbrains.annotations.NotNull;

class ClientQueryCursor<T>
implements QueryCursor<T> {
    private final QueryPager<T> pager;

    ClientQueryCursor(QueryPager<T> pager) {
        this.pager = pager;
    }

    @Override
    public List<T> getAll() {
        ArrayList<T> res = new ArrayList<T>();
        for (T ent : this) {
            res.add(ent);
        }
        return res;
    }

    @Override
    public void close() {
        try {
            this.pager.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private Iterator<T> currPageIt = null;

            @Override
            public boolean hasNext() {
                return ClientQueryCursor.this.pager.hasNext() || this.currPageIt != null && this.currPageIt.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.currPageIt == null || !this.currPageIt.hasNext() && ClientQueryCursor.this.pager.hasNext()) {
                    try {
                        Collection currPage = ClientQueryCursor.this.pager.next();
                        this.currPageIt = currPage.iterator();
                    }
                    catch (ClientException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new ClientException("Failed to retrieve query results", e);
                    }
                }
                return this.currPageIt.next();
            }
        };
    }

    QueryPager<T> getPager() {
        return this.pager;
    }
}

