/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.query.GridQueryProperty;
import org.apache.ignite.internal.processors.query.GridQueryTypeDescriptor;
import org.apache.ignite.internal.processors.query.h2.H2TableDescriptor;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2KeyRowOnheap;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2KeyValueRowOnheap;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2ValueCacheObject;
import org.h2.message.DbException;
import org.h2.result.SearchRow;
import org.h2.result.SimpleRow;
import org.h2.util.LocalDateTimeUtils;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;

public class GridH2RowDescriptor {
    private final IgniteH2Indexing idx;
    private final H2TableDescriptor tbl;
    private final GridQueryTypeDescriptor type;
    private volatile String[] fields;
    private volatile int[] fieldTypes;
    private final int keyType;
    private final int valType;
    private volatile GridQueryProperty[] props;
    private volatile int keyAliasColId;
    private volatile int valAliasColId;

    public GridH2RowDescriptor(IgniteH2Indexing idx, H2TableDescriptor tbl, GridQueryTypeDescriptor type) {
        assert (type != null);
        this.idx = idx;
        this.tbl = tbl;
        this.type = type;
        this.keyType = DataType.getTypeFromClass((Class)type.keyClass());
        this.valType = DataType.getTypeFromClass((Class)type.valueClass());
        this.refreshMetadataFromTypeDescriptor();
    }

    public final void refreshMetadataFromTypeDescriptor() {
        int i;
        LinkedHashMap allFields = new LinkedHashMap();
        allFields.putAll(this.type.fields());
        this.fields = allFields.keySet().toArray(new String[allFields.size()]);
        this.fieldTypes = new int[this.fields.length];
        Class[] classes = allFields.values().toArray(new Class[this.fields.length]);
        for (i = 0; i < this.fieldTypes.length; ++i) {
            this.fieldTypes[i] = DataType.getTypeFromClass((Class)classes[i]);
        }
        this.props = new GridQueryProperty[this.fields.length];
        for (i = 0; i < this.fields.length; ++i) {
            GridQueryProperty p = this.type.property(this.fields[i]);
            assert (p != null) : this.fields[i];
            this.props[i] = p;
        }
        List<String> fieldsList = Arrays.asList(this.fields);
        this.keyAliasColId = this.type.keyFieldName() != null ? 3 + fieldsList.indexOf(this.type.keyFieldAlias()) : -1;
        this.valAliasColId = this.type.valueFieldName() != null ? 3 + fieldsList.indexOf(this.type.valueFieldAlias()) : -1;
    }

    public IgniteH2Indexing indexing() {
        return this.idx;
    }

    public GridQueryTypeDescriptor type() {
        return this.type;
    }

    public GridCacheContext<?, ?> context() {
        return this.tbl.cache();
    }

    public Value wrap(Object obj, int type) throws IgniteCheckedException {
        assert (obj != null);
        if (obj instanceof CacheObject) {
            CacheObject co = (CacheObject)obj;
            if (type == 19) {
                return new GridH2ValueCacheObject(co, this.idx.objectContext());
            }
            obj = co.value(this.idx.objectContext(), false);
        }
        switch (type) {
            case 1: {
                return ValueBoolean.get((boolean)((Boolean)obj));
            }
            case 2: {
                return ValueByte.get((byte)((Byte)obj));
            }
            case 3: {
                return ValueShort.get((short)((Short)obj));
            }
            case 4: {
                return ValueInt.get((int)((Integer)obj));
            }
            case 8: {
                return ValueFloat.get((float)((Float)obj).floatValue());
            }
            case 5: {
                return ValueLong.get((long)((Long)obj));
            }
            case 7: {
                return ValueDouble.get((double)((Double)obj));
            }
            case 20: {
                UUID uuid = (UUID)obj;
                return ValueUuid.get((long)uuid.getMostSignificantBits(), (long)uuid.getLeastSignificantBits());
            }
            case 10: {
                if (LocalDateTimeUtils.isLocalDate(obj.getClass())) {
                    return LocalDateTimeUtils.localDateToDateValue((Object)obj);
                }
                return ValueDate.get((Date)((Date)obj));
            }
            case 9: {
                if (LocalDateTimeUtils.isLocalTime(obj.getClass())) {
                    return LocalDateTimeUtils.localTimeToTimeValue((Object)obj);
                }
                return ValueTime.get((Time)((Time)obj));
            }
            case 11: {
                if (obj instanceof java.util.Date && !(obj instanceof Timestamp)) {
                    obj = new Timestamp(((java.util.Date)obj).getTime());
                }
                if (LocalDateTimeUtils.isLocalDateTime(obj.getClass())) {
                    return LocalDateTimeUtils.localDateTimeToValue((Object)obj);
                }
                return ValueTimestamp.get((Timestamp)((Timestamp)obj));
            }
            case 6: {
                return ValueDecimal.get((BigDecimal)((BigDecimal)obj));
            }
            case 13: {
                return ValueString.get((String)obj.toString());
            }
            case 12: {
                return ValueBytes.get((byte[])((byte[])obj));
            }
            case 19: {
                return ValueJavaObject.getNoCopy((Object)obj, null, null);
            }
            case 17: {
                Object[] arr = (Object[])obj;
                Value[] valArr = new Value[arr.length];
                for (int i = 0; i < arr.length; ++i) {
                    Object o = arr[i];
                    valArr[i] = o == null ? ValueNull.INSTANCE : this.wrap(o, DataType.getTypeFromClass(o.getClass()));
                }
                return ValueArray.get((Value[])valArr);
            }
            case 22: {
                return ValueGeometry.getFromGeometry((Object)obj);
            }
        }
        throw new IgniteCheckedException("Failed to wrap value[type=" + type + ", value=" + obj + "]");
    }

    public GridH2Row createRow(CacheDataRow dataRow) throws IgniteCheckedException {
        GridH2Row row;
        try {
            row = dataRow.value() == null ? new GridH2KeyRowOnheap(dataRow, this.wrap(dataRow.key(), this.keyType)) : new GridH2KeyValueRowOnheap(this, dataRow, this.keyType, this.valType);
        }
        catch (ClassCastException e) {
            throw new IgniteCheckedException("Failed to convert key to SQL type. Please make sure that you always store each value type with the same key type or configure key type as common super class for all actual keys for this value type.", (Throwable)e);
        }
        return row;
    }

    public int valueType() {
        return this.valType;
    }

    public int fieldsCount() {
        return this.fields.length;
    }

    public int fieldType(int col) {
        return this.fieldTypes[col];
    }

    public Object columnValue(Object key, Object val, int col) {
        try {
            return this.props[col].value(key, val);
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    public void setColumnValue(Object key, Object val, Object colVal, int col) {
        try {
            this.props[col].setValue(key, val, colVal);
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    public boolean isColumnKeyProperty(int col) {
        return this.props[col].key();
    }

    public boolean isKeyColumn(int colId) {
        assert (colId >= 0);
        return colId == 0 || colId == this.keyAliasColId;
    }

    public boolean isKeyAliasColumn(int colId) {
        assert (colId >= 0);
        return colId == this.keyAliasColId;
    }

    public boolean isValueColumn(int colId) {
        assert (colId >= 0);
        return colId == 1 || colId == this.valAliasColId;
    }

    public boolean isValueAliasColumn(int colId) {
        assert (colId >= 0);
        return colId == this.valAliasColId;
    }

    public boolean isKeyValueOrVersionColumn(int colId) {
        assert (colId >= 0);
        if (colId < 3) {
            return true;
        }
        if (colId == this.keyAliasColId) {
            return true;
        }
        return colId == this.valAliasColId;
    }

    public boolean checkKeyIndexCondition(int[] masks, int mask) {
        assert (masks != null);
        assert (masks.length > 0);
        if (this.keyAliasColId < 0) {
            return (masks[0] & mask) != 0;
        }
        return (masks[0] & mask) != 0 || (masks[this.keyAliasColId] & mask) != 0;
    }

    public SearchRow prepareProxyIndexRow(SearchRow row) {
        if (row == null) {
            return null;
        }
        Value[] data = new Value[row.getColumnCount()];
        for (int idx = 0; idx < data.length; ++idx) {
            data[idx] = row.getValue(idx);
        }
        this.copyAliasColumnData(data, 0, this.keyAliasColId);
        this.copyAliasColumnData(data, 1, this.valAliasColId);
        return new SimpleRow(data);
    }

    private void copyAliasColumnData(Value[] data, int colId, int aliasColId) {
        if (aliasColId <= 0) {
            return;
        }
        if (data[aliasColId] == null && data[colId] != null) {
            data[aliasColId] = data[colId];
        }
        if (data[colId] == null && data[aliasColId] != null) {
            data[colId] = data[aliasColId];
        }
    }

    public int getAlternativeColumnId(int colId) {
        if (this.keyAliasColId > 0) {
            if (colId == 0) {
                return this.keyAliasColId;
            }
            if (colId == this.keyAliasColId) {
                return 0;
            }
        }
        if (this.valAliasColId > 0) {
            if (colId == 1) {
                return this.valAliasColId;
            }
            if (colId == this.valAliasColId) {
                return 1;
            }
        }
        return colId;
    }
}

