/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.debug;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.management.MonitorInfo;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorDataTransferObjectInput;
import org.apache.ignite.internal.visor.VisorDataTransferObjectOutput;
import org.apache.ignite.internal.visor.debug.VisorThreadLockInfo;

public class VisorThreadMonitorInfo
extends VisorThreadLockInfo {
    private static final long serialVersionUID = 0L;
    private int stackDepth;
    private StackTraceElement stackFrame;

    public VisorThreadMonitorInfo() {
    }

    public VisorThreadMonitorInfo(MonitorInfo mi) {
        super(mi);
        this.stackDepth = mi.getLockedStackDepth();
        this.stackFrame = mi.getLockedStackFrame();
    }

    public int getStackDepth() {
        return this.stackDepth;
    }

    public StackTraceElement getStackFrame() {
        return this.stackFrame;
    }

    @Override
    public byte getProtocolVersion() {
        return 1;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        try (VisorDataTransferObjectOutput dtout = new VisorDataTransferObjectOutput(out);){
            dtout.writeByte(super.getProtocolVersion());
            super.writeExternalData(dtout);
        }
        out.writeInt(this.stackDepth);
        out.writeObject(this.stackFrame);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        try (VisorDataTransferObjectInput dtin = new VisorDataTransferObjectInput(in);){
            super.readExternalData(dtin.readByte(), dtin);
        }
        this.stackDepth = in.readInt();
        this.stackFrame = (StackTraceElement)in.readObject();
    }

    @Override
    public String toString() {
        return S.toString(VisorThreadMonitorInfo.class, this);
    }
}

