/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.tostring;

import java.io.Externalizable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.util.tostring.GridToStringClassDescriptor;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringFieldDescriptor;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.tostring.GridToStringOrder;
import org.apache.ignite.internal.util.tostring.GridToStringThreadLocal;
import org.apache.ignite.internal.util.tostring.SBLengthLimit;
import org.apache.ignite.internal.util.tostring.SBLimitedLength;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridToStringBuilder {
    private static final Map<String, GridToStringClassDescriptor> classCache = new HashMap<String, GridToStringClassDescriptor>();
    private static final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    public static final boolean INCLUDE_SENSITIVE = IgniteSystemProperties.getBoolean("IGNITE_TO_STRING_INCLUDE_SENSITIVE", true);
    private static final int COLLECTION_LIMIT = IgniteSystemProperties.getInteger("IGNITE_TO_STRING_COLLECTION_LIMIT", 100);
    private static ThreadLocal<Queue<GridToStringThreadLocal>> threadCache = new ThreadLocal<Queue<GridToStringThreadLocal>>(){

        @Override
        protected Queue<GridToStringThreadLocal> initialValue() {
            LinkedList<GridToStringThreadLocal> queue = new LinkedList<GridToStringThreadLocal>();
            queue.offer(new GridToStringThreadLocal());
            return queue;
        }
    };
    private static ThreadLocal<SBLengthLimit> threadCurLen = new ThreadLocal<SBLengthLimit>(){

        @Override
        protected SBLengthLimit initialValue() {
            return new SBLengthLimit();
        }
    };

    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, String name1, Object val1, String name2, Object val2, String name3, Object val3, String name4, Object val4) {
        return GridToStringBuilder.toString(cls, obj, name0, val0, false, name1, val1, false, name2, val2, false, name3, val3, false, name4, val4, false);
    }

    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, String name1, Object val1, String name2, Object val2, String name3, Object val3, String name4, Object val4, String name5, Object val5) {
        return GridToStringBuilder.toString(cls, obj, name0, val0, false, name1, val1, false, name2, val2, false, name3, val3, false, name4, val4, false, name5, val5, false);
    }

    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, String name1, Object val1, String name2, Object val2, String name3, Object val3, String name4, Object val4, String name5, Object val5, String name6, Object val6) {
        return GridToStringBuilder.toString(cls, obj, name0, val0, false, name1, val1, false, name2, val2, false, name3, val3, false, name4, val4, false, name5, val5, false, name6, val6, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, boolean sens0, String name1, Object val1, boolean sens1, String name2, Object val2, boolean sens2, String name3, Object val3, boolean sens3, String name4, Object val4, boolean sens4) {
        assert (cls != null);
        assert (obj != null);
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        assert (name4 != null);
        Queue<GridToStringThreadLocal> queue = threadCache.get();
        assert (queue != null);
        GridToStringThreadLocal tmp = queue.isEmpty() ? new GridToStringThreadLocal() : queue.remove();
        Object[] addNames = tmp.getAdditionalNames();
        Object[] addVals = tmp.getAdditionalValues();
        boolean[] addSens = tmp.getAdditionalSensitives();
        addNames[0] = name0;
        addVals[0] = val0;
        addSens[0] = sens0;
        addNames[1] = name1;
        addVals[1] = val1;
        addSens[1] = sens1;
        addNames[2] = name2;
        addVals[2] = val2;
        addSens[2] = sens2;
        addNames[3] = name3;
        addVals[3] = val3;
        addSens[3] = sens3;
        addNames[4] = name4;
        addVals[4] = val4;
        addSens[4] = sens4;
        SBLengthLimit lenLim = threadCurLen.get();
        boolean newStr = false;
        try {
            newStr = lenLim.length() == 0;
            String string = GridToStringBuilder.toStringImpl(cls, tmp.getStringBuilder(lenLim), obj, addNames, addVals, addSens, 5);
            return string;
        }
        finally {
            queue.offer(tmp);
            if (newStr) {
                lenLim.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, boolean sens0, String name1, Object val1, boolean sens1, String name2, Object val2, boolean sens2, String name3, Object val3, boolean sens3, String name4, Object val4, boolean sens4, String name5, Object val5, boolean sens5) {
        assert (cls != null);
        assert (obj != null);
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        assert (name4 != null);
        assert (name5 != null);
        Queue<GridToStringThreadLocal> queue = threadCache.get();
        assert (queue != null);
        GridToStringThreadLocal tmp = queue.isEmpty() ? new GridToStringThreadLocal() : queue.remove();
        Object[] addNames = tmp.getAdditionalNames();
        Object[] addVals = tmp.getAdditionalValues();
        boolean[] addSens = tmp.getAdditionalSensitives();
        addNames[0] = name0;
        addVals[0] = val0;
        addSens[0] = sens0;
        addNames[1] = name1;
        addVals[1] = val1;
        addSens[1] = sens1;
        addNames[2] = name2;
        addVals[2] = val2;
        addSens[2] = sens2;
        addNames[3] = name3;
        addVals[3] = val3;
        addSens[3] = sens3;
        addNames[4] = name4;
        addVals[4] = val4;
        addSens[4] = sens4;
        addNames[5] = name5;
        addVals[5] = val5;
        addSens[5] = sens5;
        SBLengthLimit lenLim = threadCurLen.get();
        boolean newStr = false;
        try {
            newStr = lenLim.length() == 0;
            String string = GridToStringBuilder.toStringImpl(cls, tmp.getStringBuilder(lenLim), obj, addNames, addVals, addSens, 6);
            return string;
        }
        finally {
            queue.offer(tmp);
            if (newStr) {
                lenLim.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, boolean sens0, String name1, Object val1, boolean sens1, String name2, Object val2, boolean sens2, String name3, Object val3, boolean sens3, String name4, Object val4, boolean sens4, String name5, Object val5, boolean sens5, String name6, Object val6, boolean sens6) {
        assert (cls != null);
        assert (obj != null);
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        assert (name4 != null);
        assert (name5 != null);
        assert (name6 != null);
        Queue<GridToStringThreadLocal> queue = threadCache.get();
        assert (queue != null);
        GridToStringThreadLocal tmp = queue.isEmpty() ? new GridToStringThreadLocal() : queue.remove();
        Object[] addNames = tmp.getAdditionalNames();
        Object[] addVals = tmp.getAdditionalValues();
        boolean[] addSens = tmp.getAdditionalSensitives();
        addNames[0] = name0;
        addVals[0] = val0;
        addSens[0] = sens0;
        addNames[1] = name1;
        addVals[1] = val1;
        addSens[1] = sens1;
        addNames[2] = name2;
        addVals[2] = val2;
        addSens[2] = sens2;
        addNames[3] = name3;
        addVals[3] = val3;
        addSens[3] = sens3;
        addNames[4] = name4;
        addVals[4] = val4;
        addSens[4] = sens4;
        addNames[5] = name5;
        addVals[5] = val5;
        addSens[5] = sens5;
        addNames[6] = name6;
        addVals[6] = val6;
        addSens[6] = sens6;
        SBLengthLimit lenLim = threadCurLen.get();
        boolean newStr = false;
        try {
            newStr = lenLim.length() == 0;
            String string = GridToStringBuilder.toStringImpl(cls, tmp.getStringBuilder(lenLim), obj, addNames, addVals, addSens, 7);
            return string;
        }
        finally {
            queue.offer(tmp);
            if (newStr) {
                lenLim.reset();
            }
        }
    }

    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, String name1, Object val1, String name2, Object val2, String name3, Object val3) {
        return GridToStringBuilder.toString(cls, obj, name0, val0, false, name1, val1, false, name2, val2, false, name3, val3, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, boolean sens0, String name1, Object val1, boolean sens1, String name2, Object val2, boolean sens2, String name3, Object val3, boolean sens3) {
        assert (cls != null);
        assert (obj != null);
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        Queue<GridToStringThreadLocal> queue = threadCache.get();
        assert (queue != null);
        GridToStringThreadLocal tmp = queue.isEmpty() ? new GridToStringThreadLocal() : queue.remove();
        Object[] addNames = tmp.getAdditionalNames();
        Object[] addVals = tmp.getAdditionalValues();
        boolean[] addSens = tmp.getAdditionalSensitives();
        addNames[0] = name0;
        addVals[0] = val0;
        addSens[0] = sens0;
        addNames[1] = name1;
        addVals[1] = val1;
        addSens[1] = sens1;
        addNames[2] = name2;
        addVals[2] = val2;
        addSens[2] = sens2;
        addNames[3] = name3;
        addVals[3] = val3;
        addSens[3] = sens3;
        SBLengthLimit lenLim = threadCurLen.get();
        boolean newStr = false;
        try {
            newStr = lenLim.length() == 0;
            String string = GridToStringBuilder.toStringImpl(cls, tmp.getStringBuilder(lenLim), obj, addNames, addVals, addSens, 4);
            return string;
        }
        finally {
            queue.offer(tmp);
            if (newStr) {
                lenLim.reset();
            }
        }
    }

    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, String name1, Object val1, String name2, Object val2) {
        return GridToStringBuilder.toString(cls, obj, name0, val0, false, name1, val1, false, name2, val2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, boolean sens0, String name1, Object val1, boolean sens1, String name2, Object val2, boolean sens2) {
        assert (cls != null);
        assert (obj != null);
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        Queue<GridToStringThreadLocal> queue = threadCache.get();
        assert (queue != null);
        GridToStringThreadLocal tmp = queue.isEmpty() ? new GridToStringThreadLocal() : queue.remove();
        Object[] addNames = tmp.getAdditionalNames();
        Object[] addVals = tmp.getAdditionalValues();
        boolean[] addSens = tmp.getAdditionalSensitives();
        addNames[0] = name0;
        addVals[0] = val0;
        addSens[0] = sens0;
        addNames[1] = name1;
        addVals[1] = val1;
        addSens[1] = sens1;
        addNames[2] = name2;
        addVals[2] = val2;
        addSens[2] = sens2;
        SBLengthLimit lenLim = threadCurLen.get();
        boolean newStr = false;
        try {
            newStr = lenLim.length() == 0;
            String string = GridToStringBuilder.toStringImpl(cls, tmp.getStringBuilder(lenLim), obj, addNames, addVals, addSens, 3);
            return string;
        }
        finally {
            queue.offer(tmp);
            if (newStr) {
                lenLim.reset();
            }
        }
    }

    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, String name1, Object val1) {
        return GridToStringBuilder.toString(cls, obj, name0, val0, false, name1, val1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj, String name0, Object val0, boolean sens0, String name1, Object val1, boolean sens1) {
        assert (cls != null);
        assert (obj != null);
        assert (name0 != null);
        assert (name1 != null);
        Queue<GridToStringThreadLocal> queue = threadCache.get();
        assert (queue != null);
        GridToStringThreadLocal tmp = queue.isEmpty() ? new GridToStringThreadLocal() : queue.remove();
        Object[] addNames = tmp.getAdditionalNames();
        Object[] addVals = tmp.getAdditionalValues();
        boolean[] addSens = tmp.getAdditionalSensitives();
        addNames[0] = name0;
        addVals[0] = val0;
        addSens[0] = sens0;
        addNames[1] = name1;
        addVals[1] = val1;
        addSens[1] = sens1;
        SBLengthLimit lenLim = threadCurLen.get();
        boolean newStr = false;
        try {
            newStr = lenLim.length() == 0;
            String string = GridToStringBuilder.toStringImpl(cls, tmp.getStringBuilder(lenLim), obj, addNames, addVals, addSens, 2);
            return string;
        }
        finally {
            queue.offer(tmp);
            if (newStr) {
                lenLim.reset();
            }
        }
    }

    public static <T> String toString(Class<T> cls, T obj, String name, @Nullable Object val) {
        return GridToStringBuilder.toString(cls, obj, name, val, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj, String name, @Nullable Object val, boolean sens) {
        assert (cls != null);
        assert (obj != null);
        assert (name != null);
        Queue<GridToStringThreadLocal> queue = threadCache.get();
        assert (queue != null);
        GridToStringThreadLocal tmp = queue.isEmpty() ? new GridToStringThreadLocal() : queue.remove();
        Object[] addNames = tmp.getAdditionalNames();
        Object[] addVals = tmp.getAdditionalValues();
        boolean[] addSens = tmp.getAdditionalSensitives();
        addNames[0] = name;
        addVals[0] = val;
        addSens[0] = sens;
        SBLengthLimit lenLim = threadCurLen.get();
        boolean newStr = false;
        try {
            newStr = lenLim.length() == 0;
            String string = GridToStringBuilder.toStringImpl(cls, tmp.getStringBuilder(lenLim), obj, addNames, addVals, addSens, 1);
            return string;
        }
        finally {
            queue.offer(tmp);
            if (newStr) {
                lenLim.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Class<T> cls, T obj) {
        assert (cls != null);
        assert (obj != null);
        Queue<GridToStringThreadLocal> queue = threadCache.get();
        assert (queue != null);
        GridToStringThreadLocal tmp = queue.isEmpty() ? new GridToStringThreadLocal() : queue.remove();
        SBLengthLimit lenLim = threadCurLen.get();
        boolean newStr = false;
        try {
            newStr = lenLim.length() == 0;
            String string = GridToStringBuilder.toStringImpl(cls, tmp.getStringBuilder(lenLim), obj, tmp.getAdditionalNames(), tmp.getAdditionalValues(), null, 0);
            return string;
        }
        finally {
            queue.offer(tmp);
            if (newStr) {
                lenLim.reset();
            }
        }
    }

    public static <T> String toString(Class<T> cls, T obj, String parent) {
        return parent != null ? GridToStringBuilder.toString(cls, obj, "super", parent) : GridToStringBuilder.toString(cls, obj);
    }

    private static void toString(SBLimitedLength buf, Object val) {
        if (val == null) {
            buf.a("null");
        } else {
            GridToStringBuilder.toString(buf, val.getClass(), val);
        }
    }

    private static void toString(SBLimitedLength buf, Class<?> valClass, Object val) {
        if (valClass.isArray()) {
            buf.a(GridToStringBuilder.arrayToString(valClass, val));
        } else {
            int overflow = 0;
            char bracket = ' ';
            if (val instanceof Collection && ((Collection)val).size() > COLLECTION_LIMIT) {
                overflow = ((Collection)val).size() - COLLECTION_LIMIT;
                bracket = ']';
                val = F.retain((Collection)val, true, COLLECTION_LIMIT);
            } else if (val instanceof Map && ((Map)val).size() > COLLECTION_LIMIT) {
                HashMap tmp = U.newHashMap(COLLECTION_LIMIT);
                overflow = ((Map)val).size() - COLLECTION_LIMIT;
                bracket = '}';
                int cntr = 0;
                Iterator iterator = ((Map)val).entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry e = o = iterator.next();
                    tmp.put(e.getKey(), e.getValue());
                    if (++cntr < COLLECTION_LIMIT) continue;
                    break;
                }
                val = tmp;
            }
            buf.a(val);
            if (overflow > 0) {
                buf.d(buf.length() - 1);
                buf.a("... and ").a(overflow).a(" more").a(bracket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> String toStringImpl(Class<T> cls, SBLimitedLength buf, T obj, Object[] addNames, Object[] addVals, @Nullable boolean[] addSens, int addLen) {
        assert (cls != null);
        assert (buf != null);
        assert (obj != null);
        assert (addNames != null);
        assert (addVals != null);
        assert (addNames.length == addVals.length);
        assert (addLen <= addNames.length);
        try {
            GridToStringClassDescriptor cd = GridToStringBuilder.getClassDescriptor(cls);
            assert (cd != null);
            buf.setLength(0);
            buf.a(cd.getSimpleClassName()).a(" [");
            boolean first = true;
            for (GridToStringFieldDescriptor fd : cd.getFields()) {
                if (!first) {
                    buf.a(", ");
                } else {
                    first = false;
                }
                String name = fd.getName();
                Field field = cls.getDeclaredField(name);
                field.setAccessible(true);
                buf.a(name).a('=');
                Class<?> fieldType = field.getType();
                GridToStringBuilder.toString(buf, fieldType, field.get(obj));
            }
            GridToStringBuilder.appendVals(buf, first, addNames, addVals, addSens, addLen);
            buf.a(']');
            return buf.toString();
        }
        catch (Exception e) {
            rwLock.writeLock().lock();
            try {
                classCache.remove(cls.getName() + System.identityHashCode(cls.getClassLoader()));
            }
            finally {
                rwLock.writeLock().unlock();
            }
            throw new IgniteException(e);
        }
    }

    public static String toString(String str, String name, @Nullable Object val) {
        return GridToStringBuilder.toString(str, name, val, false);
    }

    public static <T> String arrayToString(Class arrType, Object arr) {
        String res;
        if (arr == null) {
            return "null";
        }
        int more = 0;
        if (arrType.equals(byte[].class)) {
            byte[] byteArr = (byte[])arr;
            if (byteArr.length > COLLECTION_LIMIT) {
                more = byteArr.length - COLLECTION_LIMIT;
                byteArr = Arrays.copyOf(byteArr, COLLECTION_LIMIT);
            }
            res = Arrays.toString(byteArr);
        } else if (arrType.equals(boolean[].class)) {
            boolean[] boolArr = (boolean[])arr;
            if (boolArr.length > COLLECTION_LIMIT) {
                more = boolArr.length - COLLECTION_LIMIT;
                boolArr = Arrays.copyOf(boolArr, COLLECTION_LIMIT);
            }
            res = Arrays.toString(boolArr);
        } else if (arrType.equals(short[].class)) {
            short[] shortArr = (short[])arr;
            if (shortArr.length > COLLECTION_LIMIT) {
                more = shortArr.length - COLLECTION_LIMIT;
                shortArr = Arrays.copyOf(shortArr, COLLECTION_LIMIT);
            }
            res = Arrays.toString(shortArr);
        } else if (arrType.equals(int[].class)) {
            int[] intArr = (int[])arr;
            if (intArr.length > COLLECTION_LIMIT) {
                more = intArr.length - COLLECTION_LIMIT;
                intArr = Arrays.copyOf(intArr, COLLECTION_LIMIT);
            }
            res = Arrays.toString(intArr);
        } else if (arrType.equals(long[].class)) {
            long[] longArr = (long[])arr;
            if (longArr.length > COLLECTION_LIMIT) {
                more = longArr.length - COLLECTION_LIMIT;
                longArr = Arrays.copyOf(longArr, COLLECTION_LIMIT);
            }
            res = Arrays.toString(longArr);
        } else if (arrType.equals(float[].class)) {
            float[] floatArr = (float[])arr;
            if (floatArr.length > COLLECTION_LIMIT) {
                more = floatArr.length - COLLECTION_LIMIT;
                floatArr = Arrays.copyOf(floatArr, COLLECTION_LIMIT);
            }
            res = Arrays.toString(floatArr);
        } else if (arrType.equals(double[].class)) {
            double[] doubleArr = (double[])arr;
            if (doubleArr.length > COLLECTION_LIMIT) {
                more = doubleArr.length - COLLECTION_LIMIT;
                doubleArr = Arrays.copyOf(doubleArr, COLLECTION_LIMIT);
            }
            res = Arrays.toString(doubleArr);
        } else if (arrType.equals(char[].class)) {
            char[] charArr = (char[])arr;
            if (charArr.length > COLLECTION_LIMIT) {
                more = charArr.length - COLLECTION_LIMIT;
                charArr = Arrays.copyOf(charArr, COLLECTION_LIMIT);
            }
            res = Arrays.toString(charArr);
        } else {
            Object[] objArr = (Object[])arr;
            if (objArr.length > COLLECTION_LIMIT) {
                more = objArr.length - COLLECTION_LIMIT;
                objArr = Arrays.copyOf(objArr, COLLECTION_LIMIT);
            }
            res = Arrays.toString(objArr);
        }
        if (more > 0) {
            StringBuilder resSB = new StringBuilder(res);
            resSB.deleteCharAt(resSB.length() - 1);
            resSB.append("... and ").append(more).append(" more]");
            res = resSB.toString();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, String name, @Nullable Object val, boolean sens) {
        assert (name != null);
        Queue<GridToStringThreadLocal> queue = threadCache.get();
        assert (queue != null);
        GridToStringThreadLocal tmp = queue.isEmpty() ? new GridToStringThreadLocal() : queue.remove();
        Object[] propNames = tmp.getAdditionalNames();
        Object[] propVals = tmp.getAdditionalValues();
        boolean[] propSens = tmp.getAdditionalSensitives();
        propNames[0] = name;
        propVals[0] = val;
        propSens[0] = sens;
        SBLengthLimit lenLim = threadCurLen.get();
        boolean newStr = false;
        try {
            newStr = lenLim.length() == 0;
            String string = GridToStringBuilder.toStringImpl(str, tmp.getStringBuilder(lenLim), propNames, propVals, propSens, 1);
            return string;
        }
        finally {
            queue.offer(tmp);
            if (newStr) {
                lenLim.reset();
            }
        }
    }

    public static String toString(String str, String name0, @Nullable Object val0, String name1, @Nullable Object val1) {
        return GridToStringBuilder.toString(str, name0, val0, false, name1, val1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, String name0, @Nullable Object val0, boolean sens0, String name1, @Nullable Object val1, boolean sens1) {
        assert (name0 != null);
        assert (name1 != null);
        Queue<GridToStringThreadLocal> queue = threadCache.get();
        assert (queue != null);
        GridToStringThreadLocal tmp = queue.isEmpty() ? new GridToStringThreadLocal() : queue.remove();
        Object[] propNames = tmp.getAdditionalNames();
        Object[] propVals = tmp.getAdditionalValues();
        boolean[] propSens = tmp.getAdditionalSensitives();
        propNames[0] = name0;
        propVals[0] = val0;
        propSens[0] = sens0;
        propNames[1] = name1;
        propVals[1] = val1;
        propSens[1] = sens1;
        SBLengthLimit lenLim = threadCurLen.get();
        boolean newStr = false;
        try {
            newStr = lenLim.length() == 0;
            String string = GridToStringBuilder.toStringImpl(str, tmp.getStringBuilder(lenLim), propNames, propVals, propSens, 2);
            return string;
        }
        finally {
            queue.offer(tmp);
            if (newStr) {
                lenLim.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, String name0, @Nullable Object val0, boolean sens0, String name1, @Nullable Object val1, boolean sens1, String name2, @Nullable Object val2, boolean sens2) {
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        Queue<GridToStringThreadLocal> queue = threadCache.get();
        assert (queue != null);
        GridToStringThreadLocal tmp = queue.isEmpty() ? new GridToStringThreadLocal() : queue.remove();
        Object[] propNames = tmp.getAdditionalNames();
        Object[] propVals = tmp.getAdditionalValues();
        boolean[] propSens = tmp.getAdditionalSensitives();
        propNames[0] = name0;
        propVals[0] = val0;
        propSens[0] = sens0;
        propNames[1] = name1;
        propVals[1] = val1;
        propSens[1] = sens1;
        propNames[2] = name2;
        propVals[2] = val2;
        propSens[2] = sens2;
        SBLengthLimit lenLim = threadCurLen.get();
        boolean newStr = false;
        try {
            newStr = lenLim.length() == 0;
            String string = GridToStringBuilder.toStringImpl(str, tmp.getStringBuilder(lenLim), propNames, propVals, propSens, 3);
            return string;
        }
        finally {
            queue.offer(tmp);
            if (newStr) {
                lenLim.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, String name0, @Nullable Object val0, boolean sens0, String name1, @Nullable Object val1, boolean sens1, String name2, @Nullable Object val2, boolean sens2, String name3, @Nullable Object val3, boolean sens3) {
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        Queue<GridToStringThreadLocal> queue = threadCache.get();
        assert (queue != null);
        GridToStringThreadLocal tmp = queue.isEmpty() ? new GridToStringThreadLocal() : queue.remove();
        Object[] propNames = tmp.getAdditionalNames();
        Object[] propVals = tmp.getAdditionalValues();
        boolean[] propSens = tmp.getAdditionalSensitives();
        propNames[0] = name0;
        propVals[0] = val0;
        propSens[0] = sens0;
        propNames[1] = name1;
        propVals[1] = val1;
        propSens[1] = sens1;
        propNames[2] = name2;
        propVals[2] = val2;
        propSens[2] = sens2;
        propNames[3] = name3;
        propVals[3] = val3;
        propSens[3] = sens3;
        SBLengthLimit lenLim = threadCurLen.get();
        boolean newStr = false;
        try {
            newStr = lenLim.length() == 0;
            String string = GridToStringBuilder.toStringImpl(str, tmp.getStringBuilder(lenLim), propNames, propVals, propSens, 4);
            return string;
        }
        finally {
            queue.offer(tmp);
            if (newStr) {
                lenLim.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, String name0, @Nullable Object val0, boolean sens0, String name1, @Nullable Object val1, boolean sens1, String name2, @Nullable Object val2, boolean sens2, String name3, @Nullable Object val3, boolean sens3, String name4, @Nullable Object val4, boolean sens4) {
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        assert (name4 != null);
        Queue<GridToStringThreadLocal> queue = threadCache.get();
        assert (queue != null);
        GridToStringThreadLocal tmp = queue.isEmpty() ? new GridToStringThreadLocal() : queue.remove();
        Object[] propNames = tmp.getAdditionalNames();
        Object[] propVals = tmp.getAdditionalValues();
        boolean[] propSens = tmp.getAdditionalSensitives();
        propNames[0] = name0;
        propVals[0] = val0;
        propSens[0] = sens0;
        propNames[1] = name1;
        propVals[1] = val1;
        propSens[1] = sens1;
        propNames[2] = name2;
        propVals[2] = val2;
        propSens[2] = sens2;
        propNames[3] = name3;
        propVals[3] = val3;
        propSens[3] = sens3;
        propNames[4] = name4;
        propVals[4] = val4;
        propSens[4] = sens4;
        SBLengthLimit lenLim = threadCurLen.get();
        boolean newStr = false;
        try {
            newStr = lenLim.length() == 0;
            String string = GridToStringBuilder.toStringImpl(str, tmp.getStringBuilder(lenLim), propNames, propVals, propSens, 5);
            return string;
        }
        finally {
            queue.offer(tmp);
            if (newStr) {
                lenLim.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, String name0, @Nullable Object val0, boolean sens0, String name1, @Nullable Object val1, boolean sens1, String name2, @Nullable Object val2, boolean sens2, String name3, @Nullable Object val3, boolean sens3, String name4, @Nullable Object val4, boolean sens4, String name5, @Nullable Object val5, boolean sens5) {
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        assert (name4 != null);
        assert (name5 != null);
        Queue<GridToStringThreadLocal> queue = threadCache.get();
        assert (queue != null);
        GridToStringThreadLocal tmp = queue.isEmpty() ? new GridToStringThreadLocal() : queue.remove();
        Object[] propNames = tmp.getAdditionalNames();
        Object[] propVals = tmp.getAdditionalValues();
        boolean[] propSens = tmp.getAdditionalSensitives();
        propNames[0] = name0;
        propVals[0] = val0;
        propSens[0] = sens0;
        propNames[1] = name1;
        propVals[1] = val1;
        propSens[1] = sens1;
        propNames[2] = name2;
        propVals[2] = val2;
        propSens[2] = sens2;
        propNames[3] = name3;
        propVals[3] = val3;
        propSens[3] = sens3;
        propNames[4] = name4;
        propVals[4] = val4;
        propSens[4] = sens4;
        propNames[5] = name5;
        propVals[5] = val5;
        propSens[5] = sens5;
        SBLengthLimit lenLim = threadCurLen.get();
        boolean newStr = false;
        try {
            newStr = lenLim.length() == 0;
            String string = GridToStringBuilder.toStringImpl(str, tmp.getStringBuilder(lenLim), propNames, propVals, propSens, 6);
            return string;
        }
        finally {
            queue.offer(tmp);
            if (newStr) {
                lenLim.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(String str, String name0, @Nullable Object val0, boolean sens0, String name1, @Nullable Object val1, boolean sens1, String name2, @Nullable Object val2, boolean sens2, String name3, @Nullable Object val3, boolean sens3, String name4, @Nullable Object val4, boolean sens4, String name5, @Nullable Object val5, boolean sens5, String name6, @Nullable Object val6, boolean sens6) {
        assert (name0 != null);
        assert (name1 != null);
        assert (name2 != null);
        assert (name3 != null);
        assert (name4 != null);
        assert (name5 != null);
        assert (name6 != null);
        Queue<GridToStringThreadLocal> queue = threadCache.get();
        assert (queue != null);
        GridToStringThreadLocal tmp = queue.isEmpty() ? new GridToStringThreadLocal() : queue.remove();
        Object[] propNames = tmp.getAdditionalNames();
        Object[] propVals = tmp.getAdditionalValues();
        boolean[] propSens = tmp.getAdditionalSensitives();
        propNames[0] = name0;
        propVals[0] = val0;
        propSens[0] = sens0;
        propNames[1] = name1;
        propVals[1] = val1;
        propSens[1] = sens1;
        propNames[2] = name2;
        propVals[2] = val2;
        propSens[2] = sens2;
        propNames[3] = name3;
        propVals[3] = val3;
        propSens[3] = sens3;
        propNames[4] = name4;
        propVals[4] = val4;
        propSens[4] = sens4;
        propNames[5] = name5;
        propVals[5] = val5;
        propSens[5] = sens5;
        propNames[6] = name6;
        propVals[6] = val6;
        propSens[6] = sens6;
        SBLengthLimit lenLim = threadCurLen.get();
        boolean newStr = false;
        try {
            newStr = lenLim.length() == 0;
            String string = GridToStringBuilder.toStringImpl(str, tmp.getStringBuilder(lenLim), propNames, propVals, propSens, 7);
            return string;
        }
        finally {
            queue.offer(tmp);
            if (newStr) {
                lenLim.reset();
            }
        }
    }

    private static String toStringImpl(String str, SBLimitedLength buf, Object[] propNames, Object[] propVals, boolean[] propSens, int propCnt) {
        buf.setLength(0);
        if (str != null) {
            buf.a(str).a(" ");
        }
        buf.a("[");
        GridToStringBuilder.appendVals(buf, true, propNames, propVals, propSens, propCnt);
        buf.a(']');
        return buf.toString();
    }

    private static void appendVals(SBLimitedLength buf, boolean first, Object[] addNames, Object[] addVals, boolean[] addSens, int addLen) {
        if (addLen > 0) {
            for (int i = 0; i < addLen; ++i) {
                GridToStringInclude incAnn;
                Object addVal = addVals[i];
                if (addVal != null && (addSens != null && addSens[i] && !INCLUDE_SENSITIVE || (incAnn = addVal.getClass().getAnnotation(GridToStringInclude.class)) != null && incAnn.sensitive() && !INCLUDE_SENSITIVE)) continue;
                if (!first) {
                    buf.a(", ");
                } else {
                    first = false;
                }
                buf.a(addNames[i]).a('=');
                GridToStringBuilder.toString(buf, addVal);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> GridToStringClassDescriptor getClassDescriptor(Class<T> cls) {
        GridToStringClassDescriptor cd;
        assert (cls != null);
        String key = cls.getName() + System.identityHashCode(cls.getClassLoader());
        rwLock.readLock().lock();
        try {
            cd = classCache.get(key);
        }
        finally {
            rwLock.readLock().unlock();
        }
        if (cd == null) {
            cd = new GridToStringClassDescriptor(cls);
            for (Field f : cls.getDeclaredFields()) {
                boolean add = false;
                Class<?> type = f.getType();
                GridToStringInclude incFld = f.getAnnotation(GridToStringInclude.class);
                GridToStringInclude incType = type.getAnnotation(GridToStringInclude.class);
                if (incFld != null || incType != null) {
                    boolean notSens = !(incFld != null && incFld.sensitive() || incType != null && incType.sensitive());
                    add = notSens || INCLUDE_SENSITIVE;
                } else if (!(f.isAnnotationPresent(GridToStringExclude.class) || f.getType().isAnnotationPresent(GridToStringExclude.class) || !Modifier.isPrivate(f.getModifiers()) || Modifier.isStatic(f.getModifiers()) || Object.class == type || Serializable.class == type || Externalizable.class == type || type.isArray() || EventListener.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type) || InputStream.class.isAssignableFrom(type) || OutputStream.class.isAssignableFrom(type) || Thread.class.isAssignableFrom(type) || Runnable.class.isAssignableFrom(type) || Lock.class.isAssignableFrom(type) || ReadWriteLock.class.isAssignableFrom(type) || Condition.class.isAssignableFrom(type))) {
                    add = true;
                }
                if (!add) continue;
                GridToStringFieldDescriptor fd = new GridToStringFieldDescriptor(f.getName());
                GridToStringOrder annOrder = f.getAnnotation(GridToStringOrder.class);
                if (annOrder != null) {
                    fd.setOrder(annOrder.value());
                }
                cd.addField(fd);
            }
            cd.sortFields();
            rwLock.writeLock().lock();
            try {
                classCache.put(key, cd);
            }
            finally {
                rwLock.writeLock().unlock();
            }
        }
        return cd;
    }

    public static String compact(@NotNull Collection<Integer> col) {
        int left;
        if (col.isEmpty()) {
            return "[]";
        }
        SB sb = new SB();
        sb.a('[');
        ArrayList<Integer> l = new ArrayList<Integer>(col);
        Collections.sort(l);
        int right = left = ((Integer)l.get(0)).intValue();
        for (int i = 1; i < l.size(); ++i) {
            int val = (Integer)l.get(i);
            if (right == val || right + 1 == val) {
                right = val;
                continue;
            }
            if (left == right) {
                sb.a(left);
            } else {
                sb.a(left).a('-').a(right);
            }
            sb.a(',').a(' ');
            left = right = val;
        }
        if (left == right) {
            sb.a(left);
        } else {
            sb.a(left).a('-').a(right);
        }
        sb.a(']');
        return sb.toString();
    }
}

