/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.jetbrains.annotations.Nullable;

public class GridLogThrottle {
    public static final int DFLT_THROTTLE_TIMEOUT = 300000;
    private static int throttleTimeout = 300000;
    private static final ConcurrentMap<IgniteBiTuple<Class<? extends Throwable>, String>, Long> errors = new ConcurrentHashMap<IgniteBiTuple<Class<? extends Throwable>, String>, Long>();

    public static void throttleTimeout(int timeout) {
        throttleTimeout = timeout;
    }

    public static long throttleTimeout() {
        return throttleTimeout;
    }

    public static void error(@Nullable IgniteLogger log, @Nullable Throwable e, String msg) {
        assert (!F.isEmpty(msg));
        GridLogThrottle.log(log, e, msg, null, LogLevel.ERROR, false, false);
    }

    public static void error(@Nullable IgniteLogger log, @Nullable Throwable e, String msg, boolean byMsg) {
        assert (!F.isEmpty(msg));
        GridLogThrottle.log(log, e, msg, null, LogLevel.ERROR, false, byMsg);
    }

    public static void warn(@Nullable IgniteLogger log, String msg) {
        assert (!F.isEmpty(msg));
        GridLogThrottle.log(log, null, msg, null, LogLevel.WARN, false, false);
    }

    public static void warn(@Nullable IgniteLogger log, @Nullable Throwable e, String msg, boolean quite, boolean byMsg) {
        assert (!F.isEmpty(msg));
        GridLogThrottle.log(log, e, msg, null, LogLevel.WARN, quite, byMsg);
    }

    public static void warn(@Nullable IgniteLogger log, String msg, boolean quiet) {
        assert (!F.isEmpty(msg));
        GridLogThrottle.log(log, null, msg, null, LogLevel.WARN, quiet, false);
    }

    public static void warn(@Nullable IgniteLogger log, String longMsg, @Nullable String shortMsg) {
        assert (!F.isEmpty(longMsg));
        GridLogThrottle.log(log, null, longMsg, shortMsg, LogLevel.WARN, false, false);
    }

    public static void info(@Nullable IgniteLogger log, String msg, boolean quiet) {
        assert (!F.isEmpty(msg));
        GridLogThrottle.log(log, null, msg, null, LogLevel.INFO, quiet, false);
    }

    public static void info(@Nullable IgniteLogger log, String msg) {
        assert (!F.isEmpty(msg));
        GridLogThrottle.info(log, msg, false);
    }

    public static void clear() {
        errors.clear();
    }

    private static void log(@Nullable IgniteLogger log, @Nullable Throwable e, String longMsg, @Nullable String shortMsg, LogLevel level, boolean quiet, boolean byMsg) {
        block2: {
            long curTs;
            Long loggedTs;
            assert (!F.isEmpty(longMsg));
            IgniteBiTuple<Object, String> tup = e != null && !byMsg ? F.t(e.getClass(), e.getMessage()) : F.t(null, longMsg);
            do {
                loggedTs = (Long)errors.get(tup);
                curTs = U.currentTimeMillis();
                if (loggedTs != null && loggedTs >= curTs - (long)throttleTimeout) break block2;
            } while (!GridLogThrottle.replace(tup, loggedTs, curTs));
            level.doLog(log, longMsg, shortMsg, e, quiet);
        }
    }

    private static boolean replace(IgniteBiTuple<Class<? extends Throwable>, String> t, @Nullable Long oldStamp, Long newStamp) {
        assert (newStamp != null);
        if (oldStamp == null) {
            Long old = errors.putIfAbsent(t, newStamp);
            return old == null;
        }
        return errors.replace(t, oldStamp, newStamp);
    }

    protected GridLogThrottle() {
    }

    private static enum LogLevel {
        ERROR{

            @Override
            public void doLog(IgniteLogger log, String longMsg, String shortMsg, Throwable e, boolean quiet) {
                if (e != null) {
                    U.error(log, longMsg, e);
                } else {
                    U.error(log, longMsg);
                }
            }
        }
        ,
        WARN{

            @Override
            public void doLog(IgniteLogger log, String longMsg, String shortMsg, Throwable e, boolean quiet) {
                if (quiet) {
                    U.quietAndWarn(log, longMsg, F.isEmpty(shortMsg) ? longMsg : shortMsg);
                } else {
                    U.warn(log, longMsg, F.isEmpty(shortMsg) ? longMsg : shortMsg);
                }
            }
        }
        ,
        INFO{

            @Override
            public void doLog(IgniteLogger log, String longMsg, String shortMsg, Throwable e, boolean quiet) {
                if (quiet) {
                    U.quietAndInfo(log, longMsg);
                } else if (log.isInfoEnabled()) {
                    log.info(longMsg);
                }
            }
        };


        public abstract void doLog(IgniteLogger var1, String var2, String var3, Throwable var4, boolean var5);
    }
}

