/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.Arrays;

public class GridHandleTable {
    private int size;
    private int threshold;
    private final float loadFactor;
    private int[] spine;
    private int[] next;
    private Object[] objs;
    private int[] spineEmpty;
    private int[] nextEmpty;

    public GridHandleTable(int initCap, float loadFactor) {
        this.loadFactor = loadFactor;
        this.spine = new int[initCap];
        this.next = new int[initCap];
        this.objs = new Object[initCap];
        this.spineEmpty = new int[initCap];
        this.nextEmpty = new int[initCap];
        Arrays.fill(this.spineEmpty, -1);
        Arrays.fill(this.nextEmpty, -1);
        this.threshold = (int)((float)initCap * loadFactor);
        this.clear();
    }

    public int lookup(Object obj) {
        int idx = this.hash(obj) % this.spine.length;
        if (this.size > 0) {
            int i = this.spine[idx];
            while (i >= 0) {
                if (this.objs[i] == obj) {
                    return i;
                }
                i = this.next[i];
            }
        }
        if (this.size >= this.next.length) {
            this.growEntries();
        }
        if (this.size >= this.threshold) {
            this.growSpine();
            idx = this.hash(obj) % this.spine.length;
        }
        this.insert(obj, this.size, idx);
        ++this.size;
        return -1;
    }

    public void clear() {
        System.arraycopy(this.spineEmpty, 0, this.spine, 0, this.spineEmpty.length);
        System.arraycopy(this.nextEmpty, 0, this.next, 0, this.nextEmpty.length);
        Arrays.fill(this.objs, null);
        this.size = 0;
    }

    public Object[] objects() {
        return this.objs;
    }

    private void insert(Object obj, int handle, int idx) {
        this.objs[handle] = obj;
        this.next[handle] = this.spine[idx];
        this.spine[idx] = handle;
    }

    private void growSpine() {
        int size = (this.spine.length << 1) + 1;
        this.spine = new int[size];
        this.spineEmpty = new int[size];
        this.threshold = (int)((float)this.spine.length * this.loadFactor);
        Arrays.fill(this.spineEmpty, -1);
        System.arraycopy(this.spineEmpty, 0, this.spine, 0, this.spineEmpty.length);
        for (int i = 0; i < this.size; ++i) {
            Object obj = this.objs[i];
            int idx = this.hash(obj) % this.spine.length;
            this.insert(this.objs[i], i, idx);
        }
    }

    private void growEntries() {
        int newLen = (this.next.length << 1) + 1;
        int[] newNext = new int[newLen];
        System.arraycopy(this.next, 0, newNext, 0, this.size);
        this.next = newNext;
        this.nextEmpty = new int[newLen];
        Arrays.fill(this.nextEmpty, -1);
        Object[] newObjs = new Object[newLen];
        System.arraycopy(this.objs, 0, newObjs, 0, this.size);
        this.objs = newObjs;
    }

    private int hash(Object obj) {
        return System.identityHashCode(obj) & Integer.MAX_VALUE;
    }
}

