/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cacheobject;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.KeyCacheObjectImpl;
import org.apache.ignite.internal.processors.cacheobject.IgniteCacheObjectProcessor;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.U;

public class UserKeyCacheObjectImpl
extends KeyCacheObjectImpl {
    private static final long serialVersionUID = 0L;

    public UserKeyCacheObjectImpl() {
    }

    UserKeyCacheObjectImpl(Object key, int part) {
        super(key, null, part);
    }

    UserKeyCacheObjectImpl(Object key, byte[] valBytes, int part) {
        super(key, valBytes, part);
    }

    @Override
    public KeyCacheObject copy(int part) {
        if (this.partition() == part) {
            return this;
        }
        return new UserKeyCacheObjectImpl(this.val, this.valBytes, part);
    }

    @Override
    public CacheObject prepareForCache(CacheObjectContext ctx) {
        try {
            IgniteCacheObjectProcessor proc = ctx.kernalContext().cacheObjects();
            if (!proc.immutable(this.val)) {
                boolean p2pEnabled;
                if (this.valBytes == null) {
                    this.valBytes = proc.marshal(ctx, this.val);
                }
                ClassLoader ldr = (p2pEnabled = ctx.kernalContext().config().isPeerClassLoadingEnabled()) ? IgniteUtils.detectClassLoader(IgniteUtils.detectClass(this.val)) : U.gridClassLoader();
                Object val = proc.unmarshal(ctx, this.valBytes, ldr);
                KeyCacheObjectImpl key = new KeyCacheObjectImpl(val, this.valBytes, this.partition());
                key.partition(this.partition());
                return key;
            }
            KeyCacheObjectImpl key = new KeyCacheObjectImpl(this.val, this.valBytes, this.partition());
            key.partition(this.partition());
            return key;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException("Failed to marshal object: " + this.val, e);
        }
    }
}

