/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.partstate;

import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.processors.cache.persistence.partstate.GroupPartitionId;
import org.apache.ignite.internal.processors.cache.persistence.partstate.PagesAllocationRange;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PartitionAllocationMap {
    @GridToStringInclude
    private final NavigableMap<GroupPartitionId, PagesAllocationRange> map = new TreeMap<GroupPartitionId, PagesAllocationRange>();
    @GridToStringInclude
    private final Set<GroupPartitionId> skippedParts = new HashSet<GroupPartitionId>();

    @Nullable
    public PagesAllocationRange get(GroupPartitionId key) {
        return (PagesAllocationRange)this.map.get(key);
    }

    @Nullable
    public PagesAllocationRange get(FullPageId fullPageId) {
        return (PagesAllocationRange)this.map.get(PartitionAllocationMap.createCachePartId(fullPageId));
    }

    @NotNull
    public static GroupPartitionId createCachePartId(@NotNull FullPageId fullId) {
        return new GroupPartitionId(fullId.groupId(), PageIdUtils.partId(fullId.pageId()));
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int size() {
        return this.map.size();
    }

    public Set<GroupPartitionId> keySet() {
        return this.map.keySet();
    }

    public Iterable<PagesAllocationRange> values() {
        return this.map.values();
    }

    public GroupPartitionId firstKey() {
        return (GroupPartitionId)this.map.firstKey();
    }

    public boolean forceSkipIndexPartition(int grpId) {
        GroupPartitionId idxId = new GroupPartitionId(grpId, 65535);
        this.map.remove(idxId);
        return this.skippedParts.add(idxId);
    }

    @Nullable
    public GroupPartitionId nextKey(@NotNull GroupPartitionId key) {
        return this.map.navigableKeySet().higher(key);
    }

    public Set<Map.Entry<GroupPartitionId, PagesAllocationRange>> entrySet() {
        return this.map.entrySet();
    }

    public boolean containsKey(GroupPartitionId key) {
        return this.map.containsKey(key);
    }

    public PagesAllocationRange put(GroupPartitionId key, PagesAllocationRange val) {
        return !this.skippedParts.contains(key) ? this.map.put(key, val) : null;
    }

    public String toString() {
        return S.toString(PartitionAllocationMap.class, this);
    }
}

