/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.extras;

import org.apache.ignite.internal.processors.cache.GridCacheMvcc;
import org.apache.ignite.internal.processors.cache.extras.GridCacheAttributesMvccObsoleteEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheAttributesMvccTtlEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheAttributesObsoleteTtlEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheEntryExtras;
import org.apache.ignite.internal.processors.cache.extras.GridCacheEntryExtrasAdapter;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class GridCacheAttributesMvccObsoleteTtlEntryExtras
extends GridCacheEntryExtrasAdapter {
    private GridCacheMvcc mvcc;
    private GridCacheVersion obsoleteVer;
    private long ttl;
    private long expireTime;

    GridCacheAttributesMvccObsoleteTtlEntryExtras(GridCacheMvcc mvcc, GridCacheVersion obsoleteVer, long ttl, long expireTime) {
        assert (mvcc != null);
        assert (obsoleteVer != null);
        assert (expireTime != 0L);
        this.mvcc = mvcc;
        this.obsoleteVer = obsoleteVer;
        this.ttl = ttl;
        this.expireTime = expireTime;
    }

    @Override
    public GridCacheMvcc mvcc() {
        return this.mvcc;
    }

    @Override
    public GridCacheEntryExtras mvcc(@Nullable GridCacheMvcc mvcc) {
        if (mvcc != null) {
            this.mvcc = mvcc;
            return this;
        }
        return new GridCacheAttributesObsoleteTtlEntryExtras(this.obsoleteVer, this.ttl, this.expireTime);
    }

    @Override
    public GridCacheVersion obsoleteVersion() {
        return this.obsoleteVer;
    }

    @Override
    public GridCacheEntryExtras obsoleteVersion(GridCacheVersion obsoleteVer) {
        if (obsoleteVer != null) {
            this.obsoleteVer = obsoleteVer;
            return this;
        }
        return new GridCacheAttributesMvccTtlEntryExtras(this.mvcc, this.ttl, this.expireTime);
    }

    @Override
    public long ttl() {
        return this.ttl;
    }

    @Override
    public long expireTime() {
        return this.expireTime;
    }

    @Override
    public GridCacheEntryExtras ttlAndExpireTime(long ttl, long expireTime) {
        if (expireTime != 0L) {
            this.ttl = ttl;
            this.expireTime = expireTime;
            return this;
        }
        return new GridCacheAttributesMvccObsoleteEntryExtras(this.mvcc, this.obsoleteVer);
    }

    @Override
    public int size() {
        return 32;
    }

    public String toString() {
        return S.toString(GridCacheAttributesMvccObsoleteTtlEntryExtras.class, this);
    }
}

