/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.lang.IgniteUuid;
import org.jetbrains.annotations.Nullable;

public class CacheStatisticsModeChangeMessage
implements DiscoveryCustomMessage {
    private static final long serialVersionUID = 0L;
    private static final byte INITIAL_MSG_MASK = 1;
    private static final byte ENABLED_MASK = 2;
    private final IgniteUuid id = IgniteUuid.randomUuid();
    private final UUID reqId;
    private final Collection<String> caches;
    private final byte flags;

    private CacheStatisticsModeChangeMessage(CacheStatisticsModeChangeMessage req) {
        this.reqId = req.reqId;
        this.caches = null;
        this.flags = req.enabled() ? (byte)2 : (byte)0;
    }

    public CacheStatisticsModeChangeMessage(UUID reqId, Collection<String> caches, boolean enabled) {
        this.reqId = reqId;
        this.caches = Collections.unmodifiableCollection(caches);
        int flags = 1;
        if (enabled) {
            flags = (byte)(flags | 2);
        }
        this.flags = (byte)flags;
    }

    @Override
    public IgniteUuid id() {
        return this.id;
    }

    @Override
    @Nullable
    public DiscoveryCustomMessage ackMessage() {
        return this.initial() ? new CacheStatisticsModeChangeMessage(this) : null;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean stopProcess() {
        return false;
    }

    @Override
    public DiscoCache createDiscoCache(GridDiscoveryManager mgr, AffinityTopologyVersion topVer, DiscoCache discoCache) {
        throw new UnsupportedOperationException();
    }

    public Collection<String> caches() {
        return Collections.unmodifiableCollection(this.caches);
    }

    public boolean initial() {
        return (this.flags & 1) != 0;
    }

    public boolean enabled() {
        return (this.flags & 2) != 0;
    }

    public UUID requestId() {
        return this.reqId;
    }

    public String toString() {
        return S.toString(CacheStatisticsModeChangeMessage.class, this);
    }
}

