/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.WalRecordCacheGroupAware;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageIO;
import org.apache.ignite.internal.util.GridUnsafe;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;

public class PageSnapshot
extends WALRecord
implements WalRecordCacheGroupAware {
    @GridToStringExclude
    private byte[] pageData;
    private FullPageId fullPageId;

    public PageSnapshot(FullPageId fullId, byte[] arr) {
        this.fullPageId = fullId;
        this.pageData = arr;
    }

    public PageSnapshot(FullPageId fullPageId, long ptr, int pageSize) {
        this.fullPageId = fullPageId;
        this.pageData = new byte[pageSize];
        GridUnsafe.copyMemory(null, ptr, this.pageData, GridUnsafe.BYTE_ARR_OFF, pageSize);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.PAGE_RECORD;
    }

    public byte[] pageData() {
        return this.pageData;
    }

    public FullPageId fullPageId() {
        return this.fullPageId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        ByteBuffer buf = ByteBuffer.allocateDirect(this.pageData.length);
        buf.order(ByteOrder.nativeOrder());
        buf.put(this.pageData);
        long addr = GridUnsafe.bufferAddress(buf);
        try {
            String string = "PageSnapshot [fullPageId = " + this.fullPageId() + ", page = [\n" + PageIO.printPage(addr, this.pageData.length) + "],\nsuper = [" + super.toString() + "]]";
            return string;
        }
        catch (IgniteCheckedException ignored) {
            String string = "Error during call'toString' of PageSnapshot [fullPageId=" + this.fullPageId() + ", pageData = " + Arrays.toString(this.pageData) + ", super=" + super.toString() + "]";
            return string;
        }
        finally {
            GridUnsafe.cleanDirectBuffer(buf);
        }
    }

    @Override
    public int groupId() {
        return this.fullPageId.groupId();
    }
}

