/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceImpl;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceSource;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

public class MetricsReplicationSourceSourceImpl
implements MetricsReplicationSourceSource {
    private final MetricsReplicationSourceImpl rms;
    private final String id;
    private final String keyPrefix;
    private final String sizeOfLogQueueKey;
    private final String ageOfLastShippedOpKey;
    private final String logReadInEditsKey;
    private final String logEditsFilteredKey;
    private final String shippedBatchesKey;
    private final String shippedOpsKey;
    private final String shippedKBsKey;
    private final String logReadInBytesKey;
    private final MutableGaugeLong ageOfLastShippedOpGauge;
    private final MutableGaugeLong sizeOfLogQueueGauge;
    private final MutableCounterLong logReadInEditsCounter;
    private final MutableCounterLong logEditsFilteredCounter;
    private final MutableCounterLong shippedBatchesCounter;
    private final MutableCounterLong shippedOpsCounter;
    private final MutableCounterLong shippedKBsCounter;
    private final MutableCounterLong logReadInBytesCounter;
    private final String unknownFileLengthKey;
    private final String uncleanlyClosedKey;
    private final String uncleanlySkippedBytesKey;
    private final String restartedKey;
    private final String repeatedBytesKey;
    private final String completedLogsKey;
    private final String completedRecoveryKey;
    private final MutableCounterLong unknownFileLengthForClosedWAL;
    private final MutableCounterLong uncleanlyClosedWAL;
    private final MutableCounterLong uncleanlyClosedSkippedBytes;
    private final MutableCounterLong restartWALReading;
    private final MutableCounterLong repeatedFileBytes;
    private final MutableCounterLong completedWAL;
    private final MutableCounterLong completedRecoveryQueue;

    public MetricsReplicationSourceSourceImpl(MetricsReplicationSourceImpl rms, String id) {
        this.rms = rms;
        this.id = id;
        this.keyPrefix = "source." + this.id + ".";
        this.ageOfLastShippedOpKey = "source." + id + ".ageOfLastShippedOp";
        this.ageOfLastShippedOpGauge = rms.getMetricsRegistry().getLongGauge(this.ageOfLastShippedOpKey, 0L);
        this.sizeOfLogQueueKey = "source." + id + ".sizeOfLogQueue";
        this.sizeOfLogQueueGauge = rms.getMetricsRegistry().getLongGauge(this.sizeOfLogQueueKey, 0L);
        this.shippedBatchesKey = "source." + this.id + ".shippedBatches";
        this.shippedBatchesCounter = rms.getMetricsRegistry().getLongCounter(this.shippedBatchesKey, 0L);
        this.shippedOpsKey = "source." + this.id + ".shippedOps";
        this.shippedOpsCounter = rms.getMetricsRegistry().getLongCounter(this.shippedOpsKey, 0L);
        this.shippedKBsKey = "source." + this.id + ".shippedKBs";
        this.shippedKBsCounter = rms.getMetricsRegistry().getLongCounter(this.shippedKBsKey, 0L);
        this.logReadInBytesKey = "source." + this.id + ".logReadInBytes";
        this.logReadInBytesCounter = rms.getMetricsRegistry().getLongCounter(this.logReadInBytesKey, 0L);
        this.logReadInEditsKey = "source." + id + ".logEditsRead";
        this.logReadInEditsCounter = rms.getMetricsRegistry().getLongCounter(this.logReadInEditsKey, 0L);
        this.logEditsFilteredKey = "source." + id + ".logEditsFiltered";
        this.logEditsFilteredCounter = rms.getMetricsRegistry().getLongCounter(this.logEditsFilteredKey, 0L);
        this.unknownFileLengthKey = this.keyPrefix + "closedLogsWithUnknownFileLength";
        this.unknownFileLengthForClosedWAL = rms.getMetricsRegistry().getLongCounter(this.unknownFileLengthKey, 0L);
        this.uncleanlyClosedKey = this.keyPrefix + "uncleanlyClosedLogs";
        this.uncleanlyClosedWAL = rms.getMetricsRegistry().getLongCounter(this.uncleanlyClosedKey, 0L);
        this.uncleanlySkippedBytesKey = this.keyPrefix + "ignoredUncleanlyClosedLogContentsInBytes";
        this.uncleanlyClosedSkippedBytes = rms.getMetricsRegistry().getLongCounter(this.uncleanlySkippedBytesKey, 0L);
        this.restartedKey = this.keyPrefix + "restartedLogReading";
        this.restartWALReading = rms.getMetricsRegistry().getLongCounter(this.restartedKey, 0L);
        this.repeatedBytesKey = this.keyPrefix + "repeatedLogFileBytes";
        this.repeatedFileBytes = rms.getMetricsRegistry().getLongCounter(this.repeatedBytesKey, 0L);
        this.completedLogsKey = this.keyPrefix + "completedLogs";
        this.completedWAL = rms.getMetricsRegistry().getLongCounter(this.completedLogsKey, 0L);
        this.completedRecoveryKey = this.keyPrefix + "completedRecoverQueues";
        this.completedRecoveryQueue = rms.getMetricsRegistry().getLongCounter(this.completedRecoveryKey, 0L);
    }

    public void setLastShippedAge(long age) {
        this.ageOfLastShippedOpGauge.set(age);
    }

    public void setSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.set((long)size);
    }

    public void incrSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.incr((long)size);
    }

    public void decrSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.decr((long)size);
    }

    public void incrLogReadInEdits(long size) {
        this.logReadInEditsCounter.incr(size);
    }

    public void incrLogEditsFiltered(long size) {
        this.logEditsFilteredCounter.incr(size);
    }

    public void incrBatchesShipped(int batches) {
        this.shippedBatchesCounter.incr((long)batches);
    }

    public void incrOpsShipped(long ops) {
        this.shippedOpsCounter.incr(ops);
    }

    public void incrShippedKBs(long size) {
        this.shippedKBsCounter.incr(size);
    }

    public void incrLogReadInBytes(long size) {
        this.logReadInBytesCounter.incr(size);
    }

    public void clear() {
        this.rms.removeMetric(this.ageOfLastShippedOpKey);
        this.rms.removeMetric(this.sizeOfLogQueueKey);
        this.rms.removeMetric(this.shippedBatchesKey);
        this.rms.removeMetric(this.shippedOpsKey);
        this.rms.removeMetric(this.shippedKBsKey);
        this.rms.removeMetric(this.logReadInBytesKey);
        this.rms.removeMetric(this.logReadInEditsKey);
        this.rms.removeMetric(this.logEditsFilteredKey);
        this.rms.removeMetric(this.unknownFileLengthKey);
        this.rms.removeMetric(this.uncleanlyClosedKey);
        this.rms.removeMetric(this.uncleanlySkippedBytesKey);
        this.rms.removeMetric(this.restartedKey);
        this.rms.removeMetric(this.repeatedBytesKey);
        this.rms.removeMetric(this.completedLogsKey);
        this.rms.removeMetric(this.completedRecoveryKey);
    }

    public long getLastShippedAge() {
        return this.ageOfLastShippedOpGauge.value();
    }

    public void incrUnknownFileLengthForClosedWAL() {
        this.unknownFileLengthForClosedWAL.incr(1L);
    }

    public void incrUncleanlyClosedWALs() {
        this.uncleanlyClosedWAL.incr(1L);
    }

    public void incrBytesSkippedInUncleanlyClosedWALs(long bytes) {
        this.uncleanlyClosedSkippedBytes.incr(bytes);
    }

    public void incrRestartedWALReading() {
        this.restartWALReading.incr(1L);
    }

    public void incrRepeatedFileBytes(long bytes) {
        this.repeatedFileBytes.incr(bytes);
    }

    public void incrCompletedWAL() {
        this.completedWAL.incr(1L);
    }

    public void incrCompletedRecoveryQueue() {
        this.completedRecoveryQueue.incr(1L);
    }
}

