/*
 * Decompiled with CFR 0.152.
 */
package org.h2.result;

import java.util.ArrayList;
import java.util.Arrays;
import org.h2.command.ddl.CreateTableData;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.result.ResultExternal;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class ResultTempTable
implements ResultExternal {
    private static final String COLUMN_NAME = "DATA";
    private final boolean distinct;
    private final SortOrder sort;
    private Index index;
    private Session session;
    private Table table;
    private Cursor resultCursor;
    private int rowCount;
    private int columnCount;
    private final ResultTempTable parent;
    private boolean closed;
    private int childCount;
    private boolean containsLob;

    ResultTempTable(Session session, Expression[] expressionArray, boolean bl, SortOrder sortOrder) {
        this.session = session;
        this.distinct = bl;
        this.sort = sortOrder;
        this.columnCount = expressionArray.length;
        Schema schema = session.getDatabase().getSchema("PUBLIC");
        CreateTableData createTableData = new CreateTableData();
        for (int i = 0; i < expressionArray.length; ++i) {
            int n = expressionArray[i].getType();
            Column column = new Column(COLUMN_NAME + i, n);
            if (n == 16 || n == 15) {
                this.containsLob = true;
            }
            createTableData.columns.add(column);
        }
        createTableData.id = session.getDatabase().allocateObjectId();
        createTableData.tableName = "TEMP_RESULT_SET_" + createTableData.id;
        createTableData.temporary = true;
        createTableData.persistIndexes = false;
        createTableData.persistData = true;
        createTableData.create = true;
        createTableData.session = session;
        this.table = schema.createTable(createTableData);
        if (sortOrder != null || bl) {
            this.createIndex();
        }
        this.parent = null;
    }

    private ResultTempTable(ResultTempTable resultTempTable) {
        this.parent = resultTempTable;
        this.columnCount = resultTempTable.columnCount;
        this.distinct = resultTempTable.distinct;
        this.session = resultTempTable.session;
        this.table = resultTempTable.table;
        this.index = resultTempTable.index;
        this.rowCount = resultTempTable.rowCount;
        this.sort = resultTempTable.sort;
        this.containsLob = resultTempTable.containsLob;
        this.reset();
    }

    private void createIndex() {
        Object object;
        int n;
        Object object2;
        IndexColumn[] indexColumnArray = null;
        if (this.sort != null && !this.distinct) {
            object2 = this.sort.getQueryColumnIndexes();
            indexColumnArray = new IndexColumn[((int[])object2).length];
            for (n = 0; n < ((int[])object2).length; ++n) {
                object = new IndexColumn();
                ((IndexColumn)object).column = this.table.getColumn(object2[n]);
                ((IndexColumn)object).sortType = this.sort.getSortTypes()[n];
                ((IndexColumn)object).columnName = COLUMN_NAME + n;
                indexColumnArray[n] = object;
            }
        } else {
            indexColumnArray = new IndexColumn[this.columnCount];
            for (int i = 0; i < this.columnCount; ++i) {
                IndexColumn indexColumn = new IndexColumn();
                indexColumn.column = this.table.getColumn(i);
                indexColumn.columnName = COLUMN_NAME + i;
                indexColumnArray[i] = indexColumn;
            }
        }
        object2 = this.table.getSchema().getUniqueIndexName(this.session, this.table, "INDEX_");
        n = this.session.getDatabase().allocateObjectId();
        object = IndexType.createNonUnique(true);
        this.index = this.table.addIndex(this.session, (String)object2, n, indexColumnArray, (IndexType)object, true, null);
    }

    @Override
    public synchronized ResultExternal createShallowCopy() {
        if (this.parent != null) {
            return this.parent.createShallowCopy();
        }
        if (this.closed) {
            return null;
        }
        ++this.childCount;
        return new ResultTempTable(this);
    }

    @Override
    public int removeRow(Value[] valueArray) {
        Row row = this.convertToRow(valueArray);
        Cursor cursor = this.find(row);
        if (cursor != null) {
            row = cursor.get();
            this.table.removeRow(this.session, row);
            --this.rowCount;
        }
        return this.rowCount;
    }

    @Override
    public boolean contains(Value[] valueArray) {
        return this.find(this.convertToRow(valueArray)) != null;
    }

    @Override
    public int addRow(Value[] valueArray) {
        Row row = this.convertToRow(valueArray);
        if (this.distinct) {
            Cursor cursor = this.find(row);
            if (cursor == null) {
                this.table.addRow(this.session, row);
                ++this.rowCount;
            }
        } else {
            this.table.addRow(this.session, row);
            ++this.rowCount;
        }
        return this.rowCount;
    }

    @Override
    public int addRows(ArrayList<Value[]> arrayList) {
        if (this.sort != null) {
            this.sort.sort(arrayList);
        }
        for (Value[] valueArray : arrayList) {
            this.addRow(valueArray);
        }
        return this.rowCount;
    }

    private synchronized void closeChild() {
        if (--this.childCount == 0 && this.closed) {
            this.dropTable();
        }
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.parent != null) {
            this.parent.closeChild();
        } else if (this.childCount == 0) {
            this.dropTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTable() {
        block21: {
            if (this.table == null) {
                return;
            }
            if (this.containsLob) {
                return;
            }
            try {
                Object object;
                Database database = this.session.getDatabase();
                Session session = this.session;
                synchronized (session) {
                    object = database;
                    synchronized (object) {
                        this.table.truncate(this.session);
                    }
                }
                if (database.isSysTableLocked()) break block21;
                session = database.getSystemSession();
                this.table.removeChildrenAndResources(session);
                if (this.index != null) {
                    this.session.removeLocalTempTableIndex(this.index);
                }
                object = this.session;
                synchronized (object) {
                    Session session2 = session;
                    synchronized (session2) {
                        Database database2 = database;
                        synchronized (database2) {
                            session.commit(false);
                        }
                    }
                }
            }
            finally {
                this.table = null;
            }
        }
    }

    @Override
    public void done() {
    }

    @Override
    public Value[] next() {
        Object object;
        if (this.resultCursor == null) {
            object = this.distinct || this.sort != null ? this.index : this.table.getScanIndex(this.session);
            this.resultCursor = this.session.getDatabase().getMvStore() != null ? (object.getRowCount(this.session) == 0L && this.rowCount > 0 ? object.find((Session)null, null, null) : object.find(this.session, null, null)) : object.find(this.session, null, null);
        }
        if (!this.resultCursor.next()) {
            return null;
        }
        object = this.resultCursor.get();
        return object.getValueList();
    }

    @Override
    public void reset() {
        this.resultCursor = null;
    }

    private Row convertToRow(Value[] valueArray) {
        if (valueArray.length < this.columnCount) {
            Value[] valueArray2 = Arrays.copyOf(valueArray, this.columnCount);
            for (int i = valueArray.length; i < this.columnCount; ++i) {
                valueArray2[i] = ValueNull.INSTANCE;
            }
            valueArray = valueArray2;
        }
        return this.session.createRow(valueArray, -1);
    }

    private Cursor find(Row row) {
        if (this.index == null) {
            this.createIndex();
        }
        Cursor cursor = this.index.find(this.session, (SearchRow)row, (SearchRow)row);
        while (cursor.next()) {
            SearchRow searchRow = cursor.getSearchRow();
            boolean bl = true;
            Database database = this.session.getDatabase();
            for (int i = 0; i < row.getColumnCount(); ++i) {
                if (database.areEqual(row.getValue(i), searchRow.getValue(i))) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return cursor;
        }
        return null;
    }
}

