/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.util.compute_engine.fjd;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sagacloud.util.compute_engine.fjd.ThreadCompute;
import com.sagacloud.util.compute_engine.fjd.ThreadDelay;
import com.sagacloud.util.compute_engine.util.Constant;
import com.sagacloud.util.compute_engine.util.ConstantCE;
import com.sagacloud.util.compute_engine.util.QueryUtil;
import com.zillion.database.agent.IZillionAgent;
import com.zillion.database.agent.ZillionAgent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class ThreadDelayStat
extends Thread {
    ZillionAgent agent;
    String database_name;
    private volatile boolean stop = false;
    List<ThreadCompute> threadList;
    String path_delay = ConstantCE.zk_root + "/delay";
    String path_delay_lock = ConstantCE.zk_root + "/delay_lock";
    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");

    public ThreadDelayStat(ZillionAgent agent, String database_name) {
        this.agent = agent;
        this.database_name = database_name;
    }

    public void requestStop() {
        this.stop = true;
    }

    @Override
    public void run() {
        while (!this.stop) {
            JSONObject job;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if ((job = ThreadDelay.Pop()) == null) continue;
            try {
                this.stat(job);
            }
            catch (Exception e) {
                Constant.warn(e);
            }
        }
    }

    private void stat(JSONObject job) throws Exception {
        String building = (String)job.get((Object)"building");
        Date curr_proc_time = this.sdf.parse((String)job.get((Object)"curr_proc_time"));
        Date last_time = new Date(curr_proc_time.getTime() - 86400000L);
        Constant.warn("delaystat\t" + building + "\t" + this.sdf.format(last_time) + "\tbegin");
        JSONObject Criteria = new JSONObject();
        Criteria.put("building", (Object)building);
        JSONArray Content = QueryUtil.select((IZillionAgent)this.agent, this.database_name, "original_present", Criteria);
        for (int i = 0; i < Content.size(); ++i) {
            JSONObject item = (JSONObject)Content.get(i);
            String meter = (String)item.get((Object)"meter");
            long funcid = (Long)item.get((Object)"funcid");
            String receivetime = (String)item.get((Object)"receivetime");
            if (last_time.getTime() - this.sdf.parse(receivetime).getTime() > 60000L * (long)ConstantCE.original_delay_period_minute * (long)ConstantCE.original_delay_delayperiodcount) continue;
            JSONObject CriteriaInner = new JSONObject();
            CriteriaInner.put("building", (Object)building);
            CriteriaInner.put("meter", (Object)meter);
            CriteriaInner.put("funcid", (Object)funcid);
            JSONObject Range = new JSONObject();
            Range.put("$gte", (Object)this.sdf.format(last_time));
            Range.put("$lt", (Object)this.sdf.format(curr_proc_time));
            CriteriaInner.put("operate_time", (Object)Range);
            JSONArray ContentInner = QueryUtil.select((IZillionAgent)this.agent, this.database_name, "original_delaydetail", CriteriaInner);
            if (ContentInner.size() <= 0) continue;
            long valid_count = 0L;
            long delay_second_total = 0L;
            Long delay_second_max = null;
            Long delay_second_min = null;
            for (int ii = 0; ii < ContentInner.size(); ++ii) {
                JSONObject itemInner = (JSONObject)ContentInner.get(ii);
                ++valid_count;
                long delay_second = (Long)itemInner.get((Object)"delay_second");
                delay_second_total += delay_second;
                if (delay_second_max == null || delay_second_max < delay_second) {
                    delay_second_max = delay_second;
                }
                if (delay_second_min != null && delay_second_min <= delay_second) continue;
                delay_second_min = delay_second;
            }
            JSONObject InsertObject = new JSONObject();
            InsertObject.put("building", (Object)building);
            InsertObject.put("meter", (Object)meter);
            InsertObject.put("funcid", (Object)funcid);
            InsertObject.put("operate_time", (Object)this.sdf.format(last_time));
            InsertObject.put("valid_count", (Object)valid_count);
            InsertObject.put("delay_second_avg", (Object)(1.0 * (double)delay_second_total / (double)ContentInner.size()));
            InsertObject.put("delay_second_max", (Object)delay_second_max);
            InsertObject.put("delay_second_min", (Object)delay_second_min);
            QueryUtil.insert((IZillionAgent)this.agent, this.database_name, "original_delaystat", InsertObject);
        }
        Constant.warn("delaystat\t" + building + "\t" + this.sdf.format(last_time) + "\tend");
    }
}

