/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep.messages;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

public class GridQueryNextPageRequest
implements Message {
    private static final long serialVersionUID = 0L;
    private long qryReqId;
    private int segmentId;
    private int qry;
    private int pageSize;

    public GridQueryNextPageRequest() {
    }

    public GridQueryNextPageRequest(long qryReqId, int qry, int segmentId, int pageSize) {
        this.qryReqId = qryReqId;
        this.qry = qry;
        this.segmentId = segmentId;
        this.pageSize = pageSize;
    }

    public long queryRequestId() {
        return this.qryReqId;
    }

    public int query() {
        return this.qry;
    }

    public int segmentId() {
        return this.segmentId;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public String toString() {
        return S.toString(GridQueryNextPageRequest.class, this);
    }

    @Override
    public void onAckReceived() {
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeInt("pageSize", this.pageSize)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeInt("qry", this.qry)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeLong("qryReqId", this.qryReqId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeInt("segmentId", this.segmentId)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.pageSize = reader.readInt("pageSize");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.qry = reader.readInt("qry");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.qryReqId = reader.readLong("qryReqId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.segmentId = reader.readInt("segmentId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridQueryNextPageRequest.class);
    }

    @Override
    public short directType() {
        return 108;
    }

    @Override
    public byte fieldsCount() {
        return 4;
    }
}

