/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.failure;

import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureHandler;
import org.apache.ignite.failure.StopNodeOrHaltFailureHandler;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;

public class FailureProcessor
extends GridProcessorAdapter {
    private final Ignite ignite;
    private volatile FailureHandler hnd;
    private volatile FailureContext failureCtx;
    private volatile byte[] reserveBuf;

    public FailureProcessor(GridKernalContext ctx) {
        super(ctx);
        this.ignite = ctx.grid();
    }

    @Override
    public void start() throws IgniteCheckedException {
        FailureHandler hnd = this.ctx.config().getFailureHandler();
        if (hnd == null) {
            hnd = this.getDefaultFailureHandler();
        }
        this.reserveBuf = new byte[IgniteSystemProperties.getInteger("IGNITE_FAILURE_HANDLER_RESERVE_BUFFER_SIZE", 65536)];
        assert (hnd != null);
        this.hnd = hnd;
        U.quietAndInfo(this.log, "Configured failure handler: [hnd=" + hnd + ']');
    }

    protected FailureHandler getDefaultFailureHandler() {
        return new StopNodeOrHaltFailureHandler();
    }

    public FailureContext failureContext() {
        return this.failureCtx;
    }

    public void process(FailureContext failureCtx) {
        this.process(failureCtx, this.hnd);
    }

    public synchronized void process(FailureContext failureCtx, FailureHandler hnd) {
        boolean invalidated;
        assert (failureCtx != null);
        assert (hnd != null);
        if (this.failureCtx != null) {
            return;
        }
        U.error(this.ignite.log(), "Critical system error detected. Will be handled accordingly to configured handler [hnd=" + hnd.getClass() + ", failureCtx=" + failureCtx + ']', failureCtx.error());
        if (this.reserveBuf != null && X.hasCause(failureCtx.error(), OutOfMemoryError.class)) {
            this.reserveBuf = null;
        }
        if (invalidated = hnd.onFailure(this.ignite, failureCtx)) {
            this.failureCtx = failureCtx;
            this.log.error("Ignite node is in invalid state due to a critical failure.");
        }
    }
}

